/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.entity;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import thut.api.entity.blockentity.BlockEntityUpdater;
import thut.api.entity.blockentity.BlockEntityWorld;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.maths.Vector3;
import thut.lib.CompatWrapper;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;
import thut.tech.common.entity.EventLiftConsumePower;
import thut.tech.common.entity.LiftInteractHandler;
import thut.tech.common.handlers.ConfigHandler;

public class EntityLift
extends EntityLivingBase
implements IEntityAdditionalSpawnData,
IBlockEntity {
    static final DataParameter<Integer> DESTINATIONFLOORDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Float> DESTINATIONYDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Float> DESTINATIONXDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Float> DESTINATIONZDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Integer> CURRENTFLOORDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Boolean> CALLEDDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187198_h);
    public static int ACCELERATIONTICKS = 20;
    public static boolean ENERGYUSE = false;
    public static int ENERGYCOST = 100;
    public BlockPos boundMin = BlockPos.field_177992_a;
    public BlockPos boundMax = BlockPos.field_177992_a;
    int energy = 0;
    private BlockEntityWorld world;
    public double speedUp = ConfigHandler.LiftSpeedUp;
    public double speedDown = -ConfigHandler.LiftSpeedDown;
    public double speedHoriz = 0.5;
    public double acceleration = 0.05;
    public boolean toMoveY = false;
    public boolean toMoveX = false;
    public boolean toMoveZ = false;
    public boolean axis = true;
    public boolean hasPassenger = false;
    int n = 0;
    int passengertime = 10;
    boolean first = true;
    Random r = new Random();
    public UUID id = null;
    public UUID owner;
    public double prevFloorY = 0.0;
    public double prevFloor = 0.0;
    TileEntityLiftAccess current;
    public List<AxisAlignedBB> blockBoxes = Lists.newArrayList();
    public int[] floors = new int[64];
    public IBlockState[][][] blocks = null;
    public TileEntity[][][] tiles = null;
    BlockEntityUpdater collider;
    LiftInteractHandler interacter;

    public EntityLift(World par1World) {
        super(par1World);
        this.field_70158_ak = true;
        this.field_70172_ad = 0;
        this.field_70178_ae = true;
        for (int i = 0; i < 64; ++i) {
            this.floors[i] = -1;
        }
    }

    public BlockEntityWorld getFakeWorld() {
        if (this.world == null) {
            this.world = new BlockEntityWorld((IBlockEntity)this, this.field_70170_p);
        }
        return this.world;
    }

    public EntityLift(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
        this.r.setSeed(100L);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public void func_70653_a(Entity entityIn, float strenght, double xRatio, double zRatio) {
    }

    private double getSpeed(double pos, double destPos, double speed, double speedPos, double speedNeg) {
        double ds = speed;
        if (destPos > pos) {
            boolean tooFast;
            boolean bl = tooFast = pos + ds * (double)(ACCELERATIONTICKS + 1) > destPos;
            if (!tooFast) {
                ds = Math.min(speedPos, ds + this.acceleration * speedPos);
            } else {
                while (ds >= 0.0 && tooFast) {
                    tooFast = pos + (ds -= this.acceleration * speedPos / 10.0) * (double)(ACCELERATIONTICKS + 1) > destPos;
                }
            }
        } else {
            boolean tooFast;
            speedNeg = Math.abs(speedNeg);
            boolean bl = tooFast = pos + ds * (double)(ACCELERATIONTICKS + 1) < destPos;
            if (!tooFast) {
                ds = Math.max(-speedNeg, ds - this.acceleration * speedNeg);
            } else {
                while (ds <= 0.0 && tooFast) {
                    tooFast = pos + (ds += this.acceleration * speedNeg / 10.0) * (double)(ACCELERATIONTICKS + 1) < destPos;
                }
            }
        }
        return ds;
    }

    private void accelerate() {
        if (this.func_70613_aW() && !this.consumePower()) {
            this.toMoveZ = false;
            this.toMoveX = false;
            this.toMoveY = false;
        }
        if (!this.toMoveX) {
            this.field_70159_w *= 0.5;
        }
        if (!this.toMoveZ) {
            this.field_70179_y *= 0.5;
        }
        if (!this.toMoveY) {
            this.field_70181_x *= 0.5;
        }
        if (this.getCalled()) {
            if (this.toMoveY) {
                double dy;
                float destY = this.getDestY();
                this.field_70181_x = dy = this.getSpeed(this.field_70163_u, destY, this.field_70181_x, this.speedUp, this.speedDown);
            }
            if (this.toMoveX) {
                double dx;
                float destX = this.getDestX();
                this.field_70159_w = dx = this.getSpeed(this.field_70165_t, destX, this.field_70159_w, this.speedHoriz, this.speedHoriz);
            }
            if (this.toMoveZ) {
                double dz;
                float destZ = this.getDestZ();
                this.field_70179_y = dz = this.getSpeed(this.field_70161_v, destZ, this.field_70179_y, this.speedHoriz, this.speedHoriz);
            }
        }
    }

    public void func_70108_f(Entity entity) {
        if (this.collider == null) {
            this.collider = new BlockEntityUpdater((IBlockEntity)this);
            this.collider.onSetPosition();
        }
        try {
            this.collider.applyEntityCollision(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void call(int floor) {
        if (floor == 0 || floor > 64) {
            return;
        }
        if (this.floors[floor - 1] > 0) {
            this.callYValue(this.floors[floor - 1]);
            this.setDestinationFloor(floor);
        }
    }

    public void callYValue(int yValue) {
        this.setDestY(yValue);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public void checkCollision() {
        int zMax;
        int xMax;
        int zMin;
        int xMin = this.boundMin.func_177958_n();
        List list = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.field_70165_t + (double)(xMin - 1), this.field_70163_u, this.field_70161_v + (double)((zMin = this.boundMin.func_177952_p()) - 1), this.field_70165_t + (double)(xMax = this.boundMax.func_177958_n()) + 1.0, this.field_70163_u + 64.0, this.field_70161_v + (double)(zMax = this.boundMax.func_177952_p()) + 1.0));
        if (list != null && !list.isEmpty()) {
            if (list.size() == 1 && this.func_184182_bu() != null && !this.func_184182_bu().isEmpty()) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                this.func_70108_f(entity);
            }
        }
    }

    private boolean consumePower() {
        if (!ENERGYUSE || !this.getCalled()) {
            return true;
        }
        boolean power = false;
        Vector3 bounds = Vector3.getNewVector().set((Object)this.boundMax.func_177973_b((Vec3i)this.boundMin));
        double volume = bounds.x * bounds.y * bounds.z;
        double energyCost = Math.abs((double)this.getDestY() - this.field_70163_u) * (double)ENERGYCOST * volume * 0.01;
        this.energy = (int)((double)this.energy - (energyCost = Math.max(energyCost, 1.0)));
        boolean bl = power = this.energy > 0;
        if (this.energy < 0) {
            this.energy = 0;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EventLiftConsumePower(this, (long)energyCost));
        if (!power) {
            this.setDestinationFloor(-1);
            this.setDestY((float)this.field_70163_u);
            this.toMoveY = false;
        }
        return power;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void doMotion() {
        if (this.field_70159_w != 0.0 || this.field_70179_y != 0.0) {
            System.out.println(this.field_70159_w + " " + this.field_70181_x + " " + this.field_70179_y);
        }
        if (!this.toMoveX) {
            this.field_70159_w = 0.0;
        }
        if (!this.toMoveY) {
            this.field_70181_x = 0.0;
        }
        if (!this.toMoveZ) {
            this.field_70179_y = 0.0;
        }
        if (this.getCalled()) {
            CompatWrapper.moveEntitySelf((Entity)this, (double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y);
        }
    }

    public void func_174829_m() {
        BlockPos min = this.getMin();
        BlockPos max = this.getMax();
        float xDiff = (float)(max.func_177958_n() - min.func_177958_n()) / 2.0f;
        float zDiff = (float)(max.func_177952_p() - min.func_177952_p()) / 2.0f;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.field_70165_t = xDiff % 1.0f != 0.0f ? axisalignedbb.field_72340_a + (double)xDiff : (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
        this.field_70163_u = axisalignedbb.field_72338_b;
        this.field_70161_v = zDiff % 1.0f != 0.0f ? axisalignedbb.field_72339_c + (double)zDiff : (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DESTINATIONFLOORDW, (Object)0);
        this.field_70180_af.func_187214_a(DESTINATIONYDW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DESTINATIONXDW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DESTINATIONZDW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CURRENTFLOORDW, (Object)-1);
        this.field_70180_af.func_187214_a(CALLEDDW, (Object)Boolean.FALSE);
    }

    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    public boolean getCanSpawnHere() {
        return false;
    }

    public boolean getCalled() {
        return (Boolean)this.field_70180_af.func_187225_a(CALLEDDW);
    }

    private void setCalled(boolean called) {
        this.field_70180_af.func_187227_b(CALLEDDW, (Object)called);
    }

    public int getCurrentFloor() {
        return (Integer)this.field_70180_af.func_187225_a(CURRENTFLOORDW);
    }

    public int getDestinationFloor() {
        return (Integer)this.field_70180_af.func_187225_a(DESTINATIONFLOORDW);
    }

    public float getDestX() {
        return ((Float)this.field_70180_af.func_187225_a(DESTINATIONXDW)).floatValue();
    }

    public float getDestY() {
        return ((Float)this.field_70180_af.func_187225_a(DESTINATIONYDW)).floatValue();
    }

    public float getDestZ() {
        return ((Float)this.field_70180_af.func_187225_a(DESTINATIONZDW)).floatValue();
    }

    public EnumActionResult applyPlayerInteraction(EntityPlayer player, Vec3d vec, EnumHand hand) {
        return this.func_184199_a(player, vec, player.func_184586_b(hand), hand);
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, @Nullable ItemStack stack, EnumHand hand) {
        if (this.interacter == null) {
            this.interacter = new LiftInteractHandler(this);
        }
        return this.interacter.applyPlayerInteraction(player, vec, stack, hand);
    }

    public boolean processInitialInteract(EntityPlayer player, EnumHand hand) {
        return this.func_184230_a(player, player.func_184586_b(hand), hand);
    }

    public boolean func_184230_a(EntityPlayer player, @Nullable ItemStack stack, EnumHand hand) {
        return this.interacter.processInitialInteract(player, stack, hand);
    }

    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        return false;
    }

    public void func_70071_h_() {
        if (ForgeHooks.onLivingUpdate((EntityLivingBase)this)) {
            return;
        }
        if (this.collider == null) {
            this.collider = new BlockEntityUpdater((IBlockEntity)this);
            this.collider.onSetPosition();
        }
        this.field_70167_r = this.field_70163_u;
        this.field_70169_q = this.field_70165_t;
        this.field_70166_s = this.field_70161_v;
        this.collider.onUpdate();
        int dy = (int)(((double)this.getDestY() - this.field_70163_u) * 16.0);
        int dx = (int)(((double)this.getDestX() - this.field_70165_t) * 16.0);
        int dz = (int)(((double)this.getDestZ() - this.field_70161_v) * 16.0);
        this.toMoveZ = 0 != dz;
        this.toMoveY = 0 != dy;
        this.toMoveX = 0 != dx;
        this.accelerate();
        if (this.toMoveY || this.toMoveX || this.toMoveZ) {
            this.doMotion();
        } else {
            this.setCalled(false);
            BlockPos pos = this.func_180425_c();
            this.func_70107_b((double)pos.func_177958_n() + 0.5, Math.round(this.field_70163_u), (double)pos.func_177952_p() + 0.5);
        }
        this.field_70177_z = 0.0f;
        this.checkCollision();
        this.passengertime = this.hasPassenger ? 20 : this.passengertime - 1;
        ++this.n;
    }

    public void passengerCheck() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
        this.hasPassenger = list.size() > 0;
    }

    public void readBlocks(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Blocks")) {
            NBTTagCompound blockTag = nbt.func_74775_l("Blocks");
            int sizeX = blockTag.func_74762_e("BlocksLengthX");
            int sizeZ = blockTag.func_74762_e("BlocksLengthZ");
            int sizeY = blockTag.func_74762_e("BlocksLengthY");
            if (sizeX == 0 || sizeZ == 0) {
                sizeX = sizeZ = nbt.func_74762_e("BlocksLength");
            }
            if (sizeY == 0) {
                sizeY = 1;
            }
            int version = blockTag.func_74762_e("v");
            this.blocks = new IBlockState[sizeX][sizeY][sizeZ];
            this.tiles = new TileEntity[sizeX][sizeY][sizeZ];
            for (int i = 0; i < sizeX; ++i) {
                for (int k = 0; k < sizeY; ++k) {
                    for (int j = 0; j < sizeZ; ++j) {
                        IBlockState state;
                        int meta;
                        Block b;
                        int n = -1;
                        if (blockTag.func_74764_b("I" + i + "," + j)) {
                            n = blockTag.func_74762_e("I" + i + "," + j);
                        } else if (blockTag.func_74764_b("I" + i + "," + k + "," + j)) {
                            n = blockTag.func_74762_e("I" + i + "," + k + "," + j);
                        }
                        if (n == -1) continue;
                        if (version == 0) {
                            b = Block.func_149634_a((Item)Item.func_150899_d((int)n));
                            meta = blockTag.func_74762_e("M" + i + "," + k + "," + j);
                            state = CompatWrapper.getBlockStateFromMeta((Block)b, (int)meta);
                        } else {
                            b = Block.func_149729_e((int)n);
                            meta = blockTag.func_74762_e("M" + i + "," + k + "," + j);
                            state = CompatWrapper.getBlockStateFromMeta((Block)b, (int)meta);
                        }
                        this.blocks[i][k][j] = state;
                        if (!blockTag.func_74764_b("T" + i + "," + k + "," + j)) continue;
                        try {
                            NBTTagCompound tag = blockTag.func_74775_l("T" + i + "," + k + "," + j);
                            this.tiles[i][k][j] = IBlockEntity.BlockEntityFormer.makeTile((NBTTagCompound)tag);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.axis = nbt.func_74767_n("axis");
        this.energy = nbt.func_74762_e("energy");
        if (nbt.func_74764_b("bounds")) {
            NBTTagCompound bounds = nbt.func_74775_l("bounds");
            this.boundMin = new BlockPos(bounds.func_74769_h("minx"), bounds.func_74769_h("miny"), bounds.func_74769_h("minz"));
            this.boundMax = new BlockPos(bounds.func_74769_h("maxx"), bounds.func_74769_h("maxy"), bounds.func_74769_h("maxz"));
        }
        if (nbt.func_74764_b("higher")) {
            this.id = new UUID(nbt.func_74763_f("higher"), nbt.func_74763_f("lower"));
        }
        if (nbt.func_74764_b("ownerhigher")) {
            this.owner = new UUID(nbt.func_74763_f("ownerhigher"), nbt.func_74763_f("ownerlower"));
        }
        this.readList(nbt);
        this.readBlocks(nbt);
    }

    public void readList(NBTTagCompound nbt) {
        if (nbt.func_74764_b("floors 0")) {
            for (int i = 0; i < 64; ++i) {
                this.floors[i] = nbt.func_74762_e("floors " + i);
                if (this.floors[i] != 0) continue;
                this.floors[i] = -1;
            }
        } else {
            NBTTagCompound floorTag = nbt.func_74775_l("floors");
            for (int i = 0; i < 64; ++i) {
                this.floors[i] = floorTag.func_74762_e("" + i);
                if (this.floors[i] != 0) continue;
                this.floors[i] = -1;
            }
        }
    }

    public void readSpawnData(ByteBuf data) {
        PacketBuffer buff = new PacketBuffer(data);
        NBTTagCompound tag = new NBTTagCompound();
        try {
            tag = buff.func_150793_b();
            this.func_70037_a(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCurrentFloor(int currentFloor) {
        this.field_70180_af.func_187227_b(CURRENTFLOORDW, (Object)currentFloor);
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            IBlockEntity.BlockEntityFormer.RevertEntity((IBlockEntity)this);
        }
        super.func_70106_y();
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.collider != null) {
            this.collider.onSetPosition();
        }
    }

    public void setDestinationFloor(int destinationFloor) {
        this.field_70180_af.func_187227_b(DESTINATIONFLOORDW, (Object)destinationFloor);
    }

    public void setDestX(float dest) {
        this.field_70180_af.func_187227_b(DESTINATIONXDW, (Object)Float.valueOf(dest));
        this.field_70180_af.func_187227_b(DESTINATIONYDW, (Object)Float.valueOf((float)this.field_70163_u));
        this.field_70180_af.func_187227_b(DESTINATIONZDW, (Object)Float.valueOf((float)this.field_70161_v));
        this.setCalled(true);
    }

    public void setDestY(float dest) {
        this.field_70180_af.func_187227_b(DESTINATIONYDW, (Object)Float.valueOf(dest));
        this.field_70180_af.func_187227_b(DESTINATIONXDW, (Object)Float.valueOf((float)this.field_70165_t));
        this.field_70180_af.func_187227_b(DESTINATIONZDW, (Object)Float.valueOf((float)this.field_70161_v));
        this.setCalled(true);
    }

    public void setDestZ(float dest) {
        this.field_70180_af.func_187227_b(DESTINATIONZDW, (Object)Float.valueOf(dest));
        this.field_70180_af.func_187227_b(DESTINATIONYDW, (Object)Float.valueOf((float)this.field_70163_u));
        this.field_70180_af.func_187227_b(DESTINATIONXDW, (Object)Float.valueOf((float)this.field_70165_t));
        this.setCalled(true);
    }

    public void setFoor(TileEntityLiftAccess te, int floor) {
        if (te.floor == 0) {
            this.floors[floor - 1] = te.func_174877_v().func_177956_o() - 2;
        } else if (te.floor != 0) {
            this.floors[te.floor - 1] = -1;
            this.floors[floor - 1] = te.func_174877_v().func_177956_o() - 2;
        }
    }

    public void writeBlocks(NBTTagCompound nbt) {
        if (this.blocks != null) {
            NBTTagCompound blocksTag = new NBTTagCompound();
            blocksTag.func_74768_a("BlocksLengthX", this.blocks.length);
            blocksTag.func_74768_a("BlocksLengthY", this.blocks[0].length);
            blocksTag.func_74768_a("BlocksLengthZ", this.blocks[0][0].length);
            blocksTag.func_74768_a("v", 1);
            int sizeX = this.blocks.length;
            int sizeY = this.blocks[0].length;
            int sizeZ = this.blocks[0][0].length;
            for (int i = 0; i < sizeX; ++i) {
                for (int k = 0; k < sizeY; ++k) {
                    for (int j = 0; j < sizeZ; ++j) {
                        IBlockState b = this.blocks[i][k][j];
                        if (b == null) continue;
                        blocksTag.func_74768_a("I" + i + "," + k + "," + j, Block.func_149682_b((Block)b.func_177230_c()));
                        blocksTag.func_74768_a("M" + i + "," + k + "," + j, b.func_177230_c().func_176201_c(b));
                        try {
                            if (this.tiles[i][k][j] == null) continue;
                            NBTTagCompound tag = new NBTTagCompound();
                            tag = this.tiles[i][k][j].func_189515_b(tag);
                            blocksTag.func_74782_a("T" + i + "," + k + "," + j, (NBTBase)tag);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            nbt.func_74782_a("Blocks", (NBTBase)blocksTag);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("axis", this.axis);
        NBTTagCompound vector = new NBTTagCompound();
        vector.func_74780_a("minx", (double)this.boundMin.func_177958_n());
        vector.func_74780_a("miny", (double)this.boundMin.func_177956_o());
        vector.func_74780_a("minz", (double)this.boundMin.func_177952_p());
        vector.func_74780_a("maxx", (double)this.boundMax.func_177958_n());
        vector.func_74780_a("maxy", (double)this.boundMax.func_177956_o());
        vector.func_74780_a("maxz", (double)this.boundMax.func_177952_p());
        nbt.func_74782_a("bounds", (NBTBase)vector);
        nbt.func_74768_a("energy", this.energy);
        if (this.owner != null) {
            nbt.func_74772_a("ownerlower", this.owner.getLeastSignificantBits());
            nbt.func_74772_a("ownerhigher", this.owner.getMostSignificantBits());
        }
        this.writeList(nbt);
        try {
            this.writeBlocks(nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeList(NBTTagCompound nbt) {
        NBTTagCompound floorTag = new NBTTagCompound();
        for (int i = 0; i < 64; ++i) {
            floorTag.func_74768_a("" + i, this.floors[i]);
        }
        nbt.func_74782_a("floors", (NBTBase)floorTag);
    }

    public void writeSpawnData(ByteBuf data) {
        PacketBuffer buff = new PacketBuffer(data);
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70014_b(tag);
        buff.func_150786_a(tag);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Lists.newArrayList();
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return null;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }

    public ItemStack func_184586_b(EnumHand hand) {
        return null;
    }

    public void func_184611_a(EnumHand hand, @Nullable ItemStack stack) {
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.LEFT;
    }

    public void setBlocks(IBlockState[][][] blocks) {
        this.blocks = blocks;
    }

    public IBlockState[][][] getBlocks() {
        return this.blocks;
    }

    public void setTiles(TileEntity[][][] tiles) {
        this.tiles = tiles;
    }

    public TileEntity[][][] getTiles() {
        return this.tiles;
    }

    public BlockPos getMin() {
        return this.boundMin;
    }

    public BlockPos getMax() {
        return this.boundMax;
    }

    public void setMin(BlockPos pos) {
        this.boundMin = pos;
    }

    public void setMax(BlockPos pos) {
        this.boundMax = pos;
    }

    public void setFakeWorld(BlockEntityWorld world) {
        this.world = world;
    }

    public static EntityLift getLiftFromUUID(final UUID liftID, World world) {
        EntityLift ret = null;
        if (world instanceof BlockEntityWorld) {
            world = ((BlockEntityWorld)world).getWorld();
        }
        if (world instanceof WorldServer) {
            WorldServer worlds = (WorldServer)world;
            return (EntityLift)worlds.func_175733_a(liftID);
        }
        List entities = world.func_175644_a(EntityLift.class, (Predicate)new Predicate<EntityLift>(){

            public boolean apply(EntityLift input) {
                return input.func_110124_au().equals(liftID);
            }
        });
        if (!entities.isEmpty()) {
            return (EntityLift)((Object)entities.get(0));
        }
        return ret;
    }
}

