/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.entity;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thut.api.boom.ExplosionCustom;
import thut.api.maths.Matrix3;
import thut.api.maths.Vector3;

public class EntityProjectile
extends EntityFallingBlock {
    IBlockState block;
    boolean accelerated = false;

    public EntityProjectile(World worldIn) {
        super(worldIn);
    }

    public EntityProjectile(World worldIn, double x, double y, double z, IBlockState fallingBlockState) {
        super(worldIn, x, y, z, fallingBlockState);
        this.block = fallingBlockState;
    }

    public Vector3 getAccelerationFromRails(Vector3 here) {
        Vector3 ret = Vector3.getNewVector();
        EnumFacing dir = null;
        for (EnumFacing side : EnumFacing.values()) {
            Block b;
            if (side.func_96559_d() != 0 || (b = here.getBlock((IBlockAccess)this.field_70170_p, side)) != Blocks.field_150318_D) continue;
            dir = side;
            break;
        }
        if (dir == null) {
            return ret;
        }
        ret.set(dir);
        int n = 1;
        boolean end = false;
        Vector3 temp = Vector3.getNewVector();
        Vector3 temp1 = Vector3.getNewVector();
        while (!end) {
            temp1.set(ret).scalarMultBy((double)n++);
            temp.set(temp1.addTo(here));
            end = temp.getBlock((IBlockAccess)this.field_70170_p) != Blocks.field_150318_D;
        }
        ret.scalarMultBy((double)n);
        return ret;
    }

    boolean isOnRails(Vector3 here) {
        return here.getBlock((IBlockAccess)this.field_70170_p) == Blocks.field_150318_D;
    }

    public void func_70071_h_() {
        if (this.block == null || this.block.func_185904_a() == Material.field_151579_a) {
            this.func_70106_y();
        } else {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            ++this.field_145812_b;
            Vector3 here = Vector3.getNewVector().set((Object)this);
            Vector3 velocity = Vector3.getNewVector().setToVelocity((Entity)this);
            double d = velocity.mag() + 1.0;
            IBlockState downState = here.offset(EnumFacing.DOWN).getBlockState((IBlockAccess)this.field_70170_p);
            Vector3 hit = here.findNextSolidBlock((IBlockAccess)this.field_70170_p, velocity, d);
            d -= 1.0;
            if (this.isOnRails(here) && !this.accelerated) {
                hit = null;
                Vector3 dir = this.getAccelerationFromRails(here);
                this.accelerated = !dir.isEmpty();
                dir.addVelocities((Entity)this);
            } else if (d < 0.04 && this.field_145812_b > 2 && downState.func_185904_a().func_76220_a() && hit == null) {
                hit = here.copy();
            }
            if (hit != null) {
                double dist = here.distanceTo(hit);
                velocity.scalarMultBy(dist);
                velocity.setVelocities((Entity)this);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                ExplosionCustom boom = new ExplosionCustom(this.field_70170_p, (Entity)this, hit, 100.0f);
                float h = this.block.func_185887_b(this.field_70170_p, hit.getPos());
                double oldD = d;
                d /= 100.0;
                d = Math.max(d, oldD / 2.0);
                d *= d;
                d *= (double)h;
                d = Math.min(100.0, d);
                boom.doExplosion();
                this.func_70106_y();
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                return;
            }
            this.field_70181_x -= (double)0.04f;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.98f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)0.98f;
        }
    }

    public void func_70091_d(double x, double y, double z) {
        List aabbs = Lists.newArrayList();
        Matrix3 mainBox = new Matrix3();
        Vector3 offset = Vector3.getNewVector();
        mainBox.boxMin().clear();
        mainBox.boxMax().x = this.field_70130_N;
        mainBox.boxMax().z = this.field_70131_O;
        mainBox.boxMax().y = this.field_70130_N;
        offset.set(-mainBox.boxMax().x / 2.0, 0.0, -mainBox.boxMax().z / 2.0);
        Vector3 vec = Vector3.getNewVector().set((Object)this);
        mainBox.addOffsetTo(offset).addOffsetTo(vec);
        AxisAlignedBB box = mainBox.getBoundingBox();
        AxisAlignedBB box1 = box.func_72314_b((double)(2.0f + this.field_70130_N), (double)(2.0f + this.field_70131_O), (double)(2.0f + this.field_70130_N));
        box1 = box1.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        aabbs = mainBox.getCollidingBoxes(box1, this.field_70170_p, (IBlockAccess)this.field_70170_p);
        Matrix3.expandAABBs((List)aabbs, (AxisAlignedBB)box);
        Matrix3.mergeAABBs((List)aabbs, (double)0.01, (double)0.01, (double)0.01);
        Vector3 diffs = Vector3.getNewVector().set(x, y, z);
        mainBox.set(this.func_174813_aQ());
        diffs.set(mainBox.doTileCollision((IBlockAccess)this.field_70170_p, aabbs, (Entity)this, Vector3.empty, diffs, false));
        boolean lock = false;
        if (diffs.x != x || diffs.y != y || diffs.z != z) {
            lock = true;
        }
        x = diffs.x;
        y = diffs.y;
        z = diffs.z;
        super.func_70091_d(x, y, z);
        if (lock) {
            this.field_70170_p.func_175656_a(this.func_180425_c(), this.block);
            this.func_70106_y();
        }
    }
}

