/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thut.api.ThutBlocks;
import thut.api.maths.Vector3;
import thut.api.network.PacketHandler;
import thut.core.common.CreativeTabThut;
import thut.lib.CompatWrapper;
import thut.tech.common.CommonProxy;
import thut.tech.common.LogFormatter;
import thut.tech.common.blocks.lift.BlockLift;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;
import thut.tech.common.entity.EntityLift;
import thut.tech.common.handlers.BlockHandler;
import thut.tech.common.handlers.ConfigHandler;
import thut.tech.common.handlers.ItemHandler;
import thut.tech.common.network.PacketPipeline;
import thut.tech.common.tesla.TeslaHandler;

@Mod(modid="thuttech", name="Thut's Tech", dependencies="required-after:thutcore", version="5.0.3", acceptedMinecraftVersions="[1.11.2]")
public class TechCore {
    @SidedProxy(clientSide="thut.tech.client.ClientProxy", serverSide="thut.tech.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="thuttech")
    public static TechCore instance;
    public static CreativeTabThut tabThut;
    public static Logger logger;
    protected static FileHandler logHandler;

    private static void initLogger() {
        logger.setLevel(Level.ALL);
        try {
            File logfile = new File("." + File.separator + "logs", "thuttech.log");
            if ((logfile.exists() || logfile.createNewFile()) && logfile.canWrite() && logHandler == null) {
                logHandler = new FileHandler(logfile.getPath());
                logHandler.setFormatter(new LogFormatter());
                logger.addHandler(logHandler);
            }
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
        }
    }

    public static ItemStack getInfoBook() {
        String name = I18n.func_74838_a((String)"ttinfobook.json");
        ItemStack stack = new ItemStack(Items.field_151164_bB);
        try {
            stack.func_77982_d(JsonToNBT.func_180713_a((String)name));
        }
        catch (NBTException e) {
            e.printStackTrace();
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void livingRender(RenderLivingEvent.Post evt) {
        if (!Minecraft.func_71410_x().func_175598_ae().func_178634_b()) {
            return;
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        proxy.initClient();
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thuttech", "lift"), EntityLift.class, (String)"lift", (int)0, (Object)this, (int)32, (int)1, (boolean)true);
        TechCore.initLogger();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        ItemHandler.registerRecipes();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        BlockHandler.registerBlocks(e);
        ItemHandler.registerItems();
        proxy.preinit(e);
        Configuration config = new Configuration(e.getSuggestedConfigurationFile());
        ConfigHandler.load(config);
        if (!Loader.isModLoaded((String)"tesla")) {
            EntityLift.ENERGYUSE = false;
        }
        PacketPipeline.packetPipeline = NetworkRegistry.INSTANCE.newSimpleChannel("thuttech");
        MinecraftForge.EVENT_BUS.register((Object)this);
        PacketPipeline.packetPipeline.registerMessage(PacketPipeline.ClientPacket.MessageHandlerClient.class, PacketPipeline.ClientPacket.class, 0, Side.CLIENT);
        PacketPipeline.packetPipeline.registerMessage(PacketPipeline.ServerPacket.MessageHandlerServer.class, PacketPipeline.ServerPacket.class, 1, Side.SERVER);
    }

    @Optional.Method(modid="tesla")
    @Mod.EventHandler
    public void preInitTesla(FMLPreInitializationEvent e) {
        System.out.println("TESLA LOCATED");
        new TeslaHandler();
    }

    @SubscribeEvent
    public void interactRightClickBlock(PlayerInteractEvent.RightClickBlock evt) {
        if (evt.getHand() == EnumHand.OFF_HAND || evt.getWorld().field_72995_K || !CompatWrapper.isValid((ItemStack)evt.getItemStack()) || !evt.getEntityPlayer().func_70093_af() || evt.getItemStack().func_77973_b() != Items.field_151055_y || evt.getFace() == EnumFacing.DOWN || evt.getFace() == EnumFacing.UP) {
            return;
        }
        IBlockState state = evt.getWorld().func_180495_p(evt.getPos());
        if (state.func_177230_c() == ThutBlocks.lift && state.func_177229_b(BlockLift.VARIANT) == BlockLift.EnumType.CONTROLLER) {
            int button;
            TileEntityLiftAccess te = (TileEntityLiftAccess)evt.getWorld().func_175625_s(evt.getPos());
            Vector3 hit = Vector3.getNewVector().set((Object)evt.getHitVec());
            hit.x -= (double)evt.getPos().func_177958_n();
            hit.y -= (double)evt.getPos().func_177956_o();
            hit.z -= (double)evt.getPos().func_177952_p();
            if (te.lift != null && te.lift.floors[(button = te.getButtonFromClick(evt.getFace(), (float)hit.x, (float)hit.y, (float)hit.z)) - 1] != -1 && button == te.floor) {
                te.lift.floors[button - 1] = -1;
                EntityLift lift = te.lift;
                te.lift = null;
                te.liftID = null;
                te.floor = 0;
                PacketHandler.sendTileUpdate((TileEntity)te);
                PacketHandler.sendEntityUpdate((Entity)lift);
            }
        }
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent e) {
    }

    static {
        tabThut = CreativeTabThut.tabThut;
        logger = Logger.getLogger("thuttech");
        logHandler = null;
    }
}

