/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.entity;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import thut.api.entity.blockentity.IBlockEntity;
import thut.lib.CompatWrapper;
import thut.tech.common.entity.EntityLift;
import thut.tech.common.items.ItemLinker;

public class LiftInteractHandler {
    final EntityLift lift;

    public LiftInteractHandler(EntityLift lift) {
        this.lift = lift;
    }

    public EnumActionResult applyPlayerInteraction(EntityPlayer player, Vec3d vec, @Nullable ItemStack stack, EnumHand hand) {
        float hitX;
        float hitY;
        float hitZ;
        BlockPos pos;
        vec = vec.func_72441_c(vec.field_72450_a > 0.0 ? -0.01 : 0.01, vec.field_72448_b > 0.0 ? -0.01 : 0.01, vec.field_72449_c > 0.0 ? -0.01 : 0.01);
        Vec3d playerPos = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d start = playerPos.func_178788_d(this.lift.func_174791_d());
        RayTraceResult trace = IBlockEntity.BlockEntityFormer.rayTraceInternal((Vec3d)start.func_178787_e(this.lift.func_174791_d()), (Vec3d)vec.func_178787_e(this.lift.func_174791_d()), (IBlockEntity)this.lift);
        EnumFacing side = EnumFacing.DOWN;
        if (trace == null) {
            pos = new BlockPos(0, 0, 0);
            hitZ = 0.0f;
            hitY = 0.0f;
            hitX = 0.0f;
        } else {
            pos = trace.func_178782_a();
            hitX = (float)(trace.field_72307_f.field_72450_a - (double)pos.func_177958_n());
            hitY = (float)(trace.field_72307_f.field_72448_b - (double)pos.func_177956_o());
            hitZ = (float)(trace.field_72307_f.field_72449_c - (double)pos.func_177952_p());
            side = trace.field_178784_b;
        }
        IBlockState state = this.lift.getFakeWorld().func_180495_p(pos);
        boolean activate = CompatWrapper.interactWithBlock((Block)state.func_177230_c(), (World)this.lift.getFakeWorld(), (BlockPos)pos, (IBlockState)state, (EntityPlayer)player, (EnumHand)hand, (ItemStack)stack, (EnumFacing)side, (float)hitX, (float)hitY, (float)hitZ);
        if (activate) {
            return EnumActionResult.SUCCESS;
        }
        if (trace == null || !state.func_185904_a().func_76220_a()) {
            Vec3d playerLook = playerPos.func_178787_e(player.func_70040_Z().func_186678_a(4.0));
            RayTraceResult result = this.lift.func_130014_f_().func_147447_a(playerPos, playerLook, false, true, false);
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                EnumActionResult itemUse;
                pos = result.func_178782_a();
                state = this.lift.func_130014_f_().func_180495_p(pos);
                hitX = (float)(result.field_72307_f.field_72450_a - (double)pos.func_177958_n());
                hitY = (float)(result.field_72307_f.field_72448_b - (double)pos.func_177956_o());
                hitZ = (float)(result.field_72307_f.field_72449_c - (double)pos.func_177952_p());
                if (player.func_70093_af() && (itemUse = ForgeHooks.onPlaceItemIntoWorld((ItemStack)stack, (EntityPlayer)player, (World)player.func_130014_f_(), (BlockPos)pos, (EnumFacing)result.field_178784_b, (float)hitX, (float)hitY, (float)hitZ, (EnumHand)hand)) != EnumActionResult.PASS) {
                    return itemUse;
                }
                activate = CompatWrapper.interactWithBlock((Block)state.func_177230_c(), (World)this.lift.func_130014_f_(), (BlockPos)pos, (IBlockState)state, (EntityPlayer)player, (EnumHand)hand, (ItemStack)stack, (EnumFacing)result.field_178784_b, (float)hitX, (float)hitY, (float)hitZ);
                if (activate) {
                    return EnumActionResult.SUCCESS;
                }
                if (!player.func_70093_af() && (itemUse = ForgeHooks.onPlaceItemIntoWorld((ItemStack)stack, (EntityPlayer)player, (World)player.func_130014_f_(), (BlockPos)pos, (EnumFacing)result.field_178784_b, (float)hitX, (float)hitY, (float)hitZ, (EnumHand)hand)) != EnumActionResult.PASS) {
                    return itemUse;
                }
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public boolean processInitialInteract(EntityPlayer player, @Nullable ItemStack stack, EnumHand hand) {
        if (stack != null && stack.func_77973_b() == Items.field_151055_y) {
            if (stack.func_82833_r().equals("x")) {
                this.lift.setDestX((float)(this.lift.field_70165_t + 10.0));
                return true;
            }
            if (stack.func_82833_r().equals("-x")) {
                this.lift.setDestX((float)(this.lift.field_70165_t - 10.0));
                return true;
            }
            if (stack.func_82833_r().equals("z")) {
                this.lift.setDestZ((float)(this.lift.field_70161_v + 10.0));
                return true;
            }
            if (stack.func_82833_r().equals("-z")) {
                this.lift.setDestZ((float)(this.lift.field_70161_v - 10.0));
                return true;
            }
            if (stack.func_82833_r().equals("y")) {
                this.lift.setDestY((float)(this.lift.field_70163_u + 10.0));
                return true;
            }
            if (stack.func_82833_r().equals("-y")) {
                this.lift.setDestY((float)(this.lift.field_70163_u - 10.0));
                return true;
            }
        }
        if (player.func_70093_af() && stack != null && stack.func_77973_b() instanceof ItemLinker && (this.lift.owner != null && player.func_110124_au().equals(this.lift.owner) || player.field_71075_bZ.field_75098_d)) {
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74778_a("lift", this.lift.func_189512_bd());
            String message = "msg.liftSet.name";
            if (this.lift.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[0]));
            }
            return true;
        }
        if (stack != null && stack.func_77973_b() instanceof ItemLinker && (this.lift.owner != null && player.func_110124_au().equals(this.lift.owner) || player.field_71075_bZ.field_75098_d)) {
            if (!this.lift.func_130014_f_().field_72995_K && this.lift.owner != null) {
                EntityPlayer ownerentity = this.lift.func_130014_f_().func_152378_a(this.lift.owner);
                String message = "msg.lift.owner";
                player.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[]{ownerentity.func_70005_c_()}));
            }
            return true;
        }
        if (player.func_70093_af() && stack != null && (player.func_184586_b(hand).func_77973_b().func_77658_a().toLowerCase().contains("wrench") || player.func_184586_b(hand).func_77973_b().func_77658_a().toLowerCase().contains("screwdriver") || player.func_184586_b(hand).func_77973_b().func_77658_a().equals(Items.field_151055_y.func_77658_a())) && (this.lift.owner != null && player.func_110124_au().equals(this.lift.owner) || player.field_71075_bZ.field_75098_d)) {
            if (!this.lift.func_130014_f_().field_72995_K) {
                String message = "msg.lift.killed";
                player.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[0]));
                this.lift.func_70606_j(0.0f);
                this.lift.func_70106_y();
            }
            return true;
        }
        return false;
    }
}

