/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.block;

import info.u_team.u_team_core.UCoreConstants;
import info.u_team.u_team_core.api.IMetaType;
import info.u_team.u_team_core.api.IPropertyList;
import info.u_team.u_team_core.block.UBlock;
import info.u_team.u_team_core.creativetab.UCreativeTab;
import info.u_team.u_team_core.item.UItemBlock;
import info.u_team.u_team_core.item.UItemBlockMetaData;
import info.u_team.u_team_core.property.PropertyList;
import info.u_team.u_team_core.util.CustomResourceLocation;
import info.u_team.u_team_core.util.MathUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;

public class UBlockMetaData
extends UBlock {
    private IMetaType[] list;
    private MetaTypeWrapper[] wrapped;
    public final PropertyList<MetaTypeWrapper> property;
    private BlockStateContainer blockstate;

    public UBlockMetaData(String name, Material material, IMetaType[] list) {
        this(name, material, null, list);
    }

    public UBlockMetaData(String name, Material material, UCreativeTab tab, IMetaType[] list) {
        super(name, material, tab);
        this.list = list;
        this.wrapped = new MetaTypeWrapper[list.length];
        for (int i = 0; i < list.length; ++i) {
            this.wrapped[i] = new MetaTypeWrapper(list[i]);
        }
        this.property = PropertyList.create((String)"meta", MetaTypeWrapper.class, (IPropertyList[])this.wrapped);
        this.blockstate = new BlockStateContainer((Block)this, new IProperty[]{this.property});
        this.func_180632_j(this.blockstate.func_177621_b());
    }

    public BlockStateContainer func_176194_O() {
        return this.blockstate;
    }

    public IBlockState func_176203_a(int meta) {
        if (MathUtil.isInRange(meta, 0, this.list.length - 1)) {
            return this.func_176223_P().func_177226_a(this.property, (Comparable)this.wrapped[meta]);
        }
        UCoreConstants.LOGGER.warn("Unsupported metadata value {} for property meta in UBlockMetaData ( {} )", (Object)meta, (Object)this.getRegistryName());
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return ((MetaTypeWrapper)state.func_177229_b(this.property)).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public UItemBlock getItemBlock() {
        return new UItemBlockMetaData(this, this.list);
    }

    @Override
    public void registerModel() {
        for (int i = 0; i < this.list.length; ++i) {
            this.setModel(this.getItem(), i, new CustomResourceLocation(this.getRegistryName(), "/" + this.list[i].getName()));
        }
    }

    public IMetaType[] getList() {
        return this.list;
    }

    public MetaTypeWrapper[] getWrapped() {
        return this.wrapped;
    }

    public static class MetaTypeWrapper
    implements IPropertyList,
    Comparable<MetaTypeWrapper> {
        private IMetaType wrapped;

        public MetaTypeWrapper(IMetaType wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public String getName() {
            return this.wrapped.getName();
        }

        public int getMetadata() {
            return this.wrapped.getMetadata();
        }

        @Override
        public int compareTo(MetaTypeWrapper wrapper) {
            return this.getName().compareTo(wrapper.getName());
        }

        public boolean equals(Object object) {
            return this.getName().equals(((MetaTypeWrapper)object).getName());
        }

        public String toString() {
            return this.getName();
        }

        public IMetaType getWrapped() {
            return this.wrapped;
        }
    }
}

