/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network.message;

import info.u_team.u_team_core.UCoreConstants;
import info.u_team.u_team_core.api.ISyncedContainerTileEntity;
import info.u_team.u_team_core.gui.UGuiContainerTileEntity;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSyncedContainer
implements IMessage {
    private BlockPos pos;
    private NBTTagCompound compound;

    public MessageSyncedContainer() {
    }

    public MessageSyncedContainer(BlockPos pos, NBTTagCompound compound) {
        this.pos = pos;
        this.compound = compound;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetbuf = new PacketBuffer(buf);
        try {
            this.pos = packetbuf.func_179259_c();
            this.compound = packetbuf.func_150793_b();
        }
        catch (IOException ex) {
            UCoreConstants.LOGGER.warn("Error in Synced Container packet decoding.", (Throwable)ex);
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetbuf = new PacketBuffer(buf);
        packetbuf.func_179255_a(this.pos);
        packetbuf.func_150786_a(this.compound);
    }

    private NBTTagCompound getCompound() {
        return this.compound;
    }

    private BlockPos getPos() {
        return this.pos;
    }

    public static class Handler
    implements IMessageHandler<MessageSyncedContainer, IMessage> {
        public IMessage onMessage(MessageSyncedContainer message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                this.handleClient(message.getPos(), message.getCompound(), ctx);
            } else {
                this.handleServer(message.getPos(), message.getCompound(), ctx);
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void handleClient(BlockPos pos, NBTTagCompound compound, MessageContext ctx) {
            Minecraft minecraft = Minecraft.func_71410_x();
            WorldClient world = minecraft.field_71441_e;
            if (!world.func_175667_e(pos)) {
                return;
            }
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof ISyncedContainerTileEntity) {
                ISyncedContainerTileEntity synced = (ISyncedContainerTileEntity)tileentity;
                minecraft.func_152344_a(() -> synced.handleFromServerSyncContainerData(compound));
            }
            minecraft.func_152344_a(() -> {
                GuiScreen gui = minecraft.field_71462_r;
                if (gui instanceof UGuiContainerTileEntity) {
                    UGuiContainerTileEntity guicontainer = (UGuiContainerTileEntity)gui;
                    guicontainer.handleServerDataInstant(compound);
                    minecraft.func_152344_a(() -> guicontainer.handleServerData(compound));
                }
            });
        }

        private void handleServer(BlockPos pos, NBTTagCompound compound, MessageContext ctx) {
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            MinecraftServer server = world.func_73046_m();
            if (!world.func_175667_e(pos)) {
                return;
            }
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof ISyncedContainerTileEntity) {
                ISyncedContainerTileEntity synced = (ISyncedContainerTileEntity)tileentity;
                server.func_152344_a(() -> synced.handleFromClientSyncContainerData(compound));
            }
        }
    }
}

