/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.tileentity;

import info.u_team.u_team_core.UCoreConstants;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class UTileEntityProvider {
    private final Class<? extends TileEntity> tileentity;
    private final Object[] objects;

    public UTileEntityProvider(ResourceLocation location, Class<? extends TileEntity> tileentity, Object ... objects) {
        this(location, true, tileentity, objects);
    }

    public UTileEntityProvider(ResourceLocation location, boolean shouldRegister, Class<? extends TileEntity> tileentity, Object ... objects) {
        this.tileentity = tileentity;
        this.objects = objects;
        if (shouldRegister) {
            GameRegistry.registerTileEntity(tileentity, (ResourceLocation)location);
        }
    }

    public Class<? extends TileEntity> getTileEntityClass() {
        return this.tileentity;
    }

    public TileEntity create(World world, int meta) {
        try {
            if (this.objects == null || this.objects.length == 0) {
                return this.tileentity.newInstance();
            }
            Class[] classes = new Class[this.objects.length];
            int i = 0;
            for (Object object : this.objects) {
                classes[i] = object.getClass();
                ++i;
            }
            this.tileentity.getConstructor(classes).newInstance(this.objects);
        }
        catch (Exception ex) {
            UCoreConstants.LOGGER.error("Couldn't create tileentity object.", (Throwable)ex);
        }
        return null;
    }
}

