/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api;

import info.u_team.u_team_core.intern.init.UCoreNetwork;
import info.u_team.u_team_core.intern.network.MessageSyncedContainer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public interface ISyncedContainerTileEntity {
    public void writeOnContainerSyncServer(NBTTagCompound var1);

    @OnlyIn(value=Dist.CLIENT)
    public void readOnContainerSyncClient(NBTTagCompound var1);

    @OnlyIn(value=Dist.CLIENT)
    public void writeOnContainerSyncClient(NBTTagCompound var1);

    public void readOnContainerSyncServer(NBTTagCompound var1);

    default public void writeOnGuiOpenServer(NBTTagCompound compound) {
        this.writeOnContainerSyncServer(compound);
    }

    default public void syncServerToClient(EntityPlayerMP player, BlockPos pos) {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeOnContainerSyncServer(compound);
        this.sendMessageToClient(player, pos, compound);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void syncClientToServer(BlockPos pos) {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeOnContainerSyncClient(compound);
        this.sendMessageToServer(pos, compound);
    }

    default public void sendMessageToClient(EntityPlayerMP player, BlockPos pos, NBTTagCompound compound) {
        UCoreNetwork.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageSyncedContainer(pos, compound));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void sendMessageToServer(BlockPos pos, NBTTagCompound compound) {
        UCoreNetwork.network.sendToServer((Object)new MessageSyncedContainer(pos, compound));
    }
}

