/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.block;

import info.u_team.u_team_core.api.ISyncedContainerTileEntity;
import info.u_team.u_team_core.block.UBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;

public class UBlockTileEntity
extends UBlock {
    protected final TileEntityType<?> tileentitytype;

    public UBlockTileEntity(String name, Block.Properties properties, TileEntityType<?> tileentitytype) {
        this(name, null, properties, tileentitytype);
    }

    public UBlockTileEntity(String name, ItemGroup group, Block.Properties properties, TileEntityType<?> tileentitytype) {
        this(name, group, properties, null, tileentitytype);
    }

    public UBlockTileEntity(String name, Block.Properties properties, Item.Properties itemblockproperties, TileEntityType<?> tileentitytype) {
        this(name, null, properties, itemblockproperties, tileentitytype);
    }

    public UBlockTileEntity(String name, ItemGroup group, Block.Properties properties, Item.Properties itemblockproperties, TileEntityType<?> tileentitytype) {
        super(name, group, properties, itemblockproperties);
        this.tileentitytype = tileentitytype;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return this.tileentitytype.func_200968_a();
    }

    public boolean openContainer(World world, BlockPos pos, EntityPlayer player) {
        return this.openContainer(world, pos, player, false);
    }

    public boolean openContainer(World world, BlockPos pos, EntityPlayer player, boolean canOpenSneak) {
        if (world.field_72995_K || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        EntityPlayerMP playermp = (EntityPlayerMP)player;
        Pair<Boolean, TileEntity> pair = this.isTileEntityFromProvider((IBlockReader)world, pos);
        if (!((Boolean)pair.getLeft()).booleanValue()) {
            return false;
        }
        TileEntity tileentity = (TileEntity)pair.getRight();
        if (!(tileentity instanceof IInteractionObject)) {
            return false;
        }
        if (!canOpenSneak && playermp.func_70093_af()) {
            return true;
        }
        NBTTagCompound compound = null;
        if (tileentity instanceof ISyncedContainerTileEntity) {
            compound = new NBTTagCompound();
            ((ISyncedContainerTileEntity)tileentity).writeOnGuiOpenServer(compound);
        }
        NBTTagCompound finalCompound = compound;
        NetworkHooks.openGui((EntityPlayerMP)playermp, (IInteractionObject)((IInteractionObject)tileentity), buf -> {
            buf.func_179255_a(pos);
            if (finalCompound != null) {
                buf.func_150786_a(finalCompound);
            }
        });
        return true;
    }

    public Pair<Boolean, TileEntity> isTileEntityFromProvider(IBlockReader world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        boolean isValid = tileentity != null && this.tileentitytype == tileentity.func_200662_C();
        return Pair.of((Object)isValid, (Object)tileentity);
    }
}

