/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.entitytype;

import info.u_team.u_team_core.api.registry.IUEntityType;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class UEntityType<T extends Entity>
extends EntityType<T>
implements IUEntityType {
    protected final String field_212547_aX;

    public UEntityType(String name, Class<? extends T> clazz, Function<? super World, ? extends T> factory, boolean serializable, boolean summonable, boolean useVanillaSpawning, Function<FMLPlayMessages.SpawnEntity, Entity> customSpawnCallback, boolean hasCustomTracking, int range, int updateFreq, boolean sendVelocityUpdates) {
        super(clazz, factory, serializable, summonable, null, useVanillaSpawning, customSpawnCallback, hasCustomTracking, range, updateFreq, sendVelocityUpdates);
        this.field_212547_aX = name;
    }

    @Override
    public String getEntryName() {
        return this.field_212547_aX;
    }

    public static class Builder<T extends Entity> {
        private final String name;
        private final Class<? extends T> entityClass;
        private final Function<? super World, ? extends T> factory;
        private boolean serializable = true;
        private boolean summonable = true;
        private Function<FMLPlayMessages.SpawnEntity, Entity> customSpawnCallback = null;
        private boolean hasCustomTracking = false;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendVelocityUpdates;

        private Builder(String name, Class<? extends T> entityClass, Function<? super World, ? extends T> factory) {
            this.name = name;
            this.entityClass = entityClass;
            this.factory = factory;
        }

        public static <T extends Entity> Builder<T> create(String name, Class<? extends T> entityClass, Function<? super World, ? extends T> factory) {
            return new Builder<T>(name, entityClass, factory);
        }

        public Builder<T> disableSummoning() {
            this.summonable = false;
            return this;
        }

        public Builder<T> disableSerialization() {
            this.serializable = false;
            return this;
        }

        public Builder<T> customSpawning(Function<FMLPlayMessages.SpawnEntity, Entity> function, boolean useVanillaSpawning) {
            this.customSpawnCallback = function;
            return this;
        }

        public Builder<T> tracker(int range, int updateFrequency, boolean sendVelocityUpdates) {
            this.hasCustomTracking = true;
            this.trackingRange = range;
            this.updateFrequency = updateFrequency;
            this.sendVelocityUpdates = sendVelocityUpdates;
            return this;
        }

        public UEntityType<T> build() {
            return new UEntityType<T>(this.name, this.entityClass, this.factory, this.serializable, this.summonable, false, this.customSpawnCallback, this.hasCustomTracking, this.trackingRange, this.updateFrequency, this.sendVelocityUpdates);
        }
    }
}

