/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.api.ISyncedContainerTileEntity;
import info.u_team.u_team_core.gui.UGuiContainerTileEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncedContainer {
    private BlockPos pos;
    private NBTTagCompound compound;

    public MessageSyncedContainer(BlockPos pos, NBTTagCompound compound) {
        this.pos = pos;
        this.compound = compound;
    }

    public static void encode(MessageSyncedContainer msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        buf.func_150786_a(msg.compound);
    }

    public static MessageSyncedContainer decode(PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        NBTTagCompound compound = buf.func_150793_b();
        return new MessageSyncedContainer(pos, compound);
    }

    public static class Handler {
        public static void handle(MessageSyncedContainer message, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            ctx.enqueueWork(() -> {
                if (ctx.getDirection().getOriginationSide() == LogicalSide.SERVER) {
                    Handler.handleClient(message.pos, message.compound, ctx);
                } else {
                    Handler.handleServer(message.pos, message.compound, ctx);
                }
            });
            ctx.setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void handleClient(BlockPos pos, NBTTagCompound compound, NetworkEvent.Context ctx) {
            GuiScreen gui;
            Minecraft minecraft = Minecraft.func_71410_x();
            WorldClient world = minecraft.field_71441_e;
            if (!world.func_175667_e(pos)) {
                return;
            }
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof ISyncedContainerTileEntity) {
                ISyncedContainerTileEntity synced = (ISyncedContainerTileEntity)tileentity;
                synced.readOnContainerSyncClient(compound);
            }
            if ((gui = minecraft.field_71462_r) instanceof UGuiContainerTileEntity) {
                UGuiContainerTileEntity guicontainer = (UGuiContainerTileEntity)gui;
                guicontainer.handleServerNBT(compound);
            }
        }

        private static void handleServer(BlockPos pos, NBTTagCompound compound, NetworkEvent.Context ctx) {
            EntityPlayerMP player = ctx.getSender();
            WorldServer world = player.func_71121_q();
            if (!world.func_175667_e(pos)) {
                return;
            }
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof ISyncedContainerTileEntity) {
                ISyncedContainerTileEntity synced = (ISyncedContainerTileEntity)tileentity;
                synced.readOnContainerSyncServer(compound);
            }
        }
    }
}

