/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.item.armor;

import info.u_team.u_team_core.api.registry.IUItem;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UItemArmor
extends ItemArmor
implements IUItem {
    protected final String type_name;
    protected final String name;

    public UItemArmor(String name, Item.Properties properties, IArmorMaterial material, EntityEquipmentSlot slot) {
        this(name, null, properties, material, slot);
    }

    public UItemArmor(String name, ItemGroup group, Item.Properties properties, IArmorMaterial material, EntityEquipmentSlot slot) {
        super(material, slot, group == null ? properties : properties.func_200916_a(group));
        this.type_name = name + "_" + this.getTypeString(slot);
        this.name = name;
    }

    @Override
    public String getEntryName() {
        return this.type_name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (!this.field_200882_e.func_200897_d().equals("invalid")) {
            return null;
        }
        return String.format("%s:textures/models/armor/%s_layer_%d%s.png", this.getRegistryName().func_110624_b(), this.name, slot == EntityEquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
    }

    protected String getTypeString(EntityEquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return "helmet";
            }
            case CHEST: {
                return "chestplate";
            }
            case LEGS: {
                return "leggings";
            }
            case FEET: {
                return "boots";
            }
        }
        return "invalid";
    }
}

