/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.potion;

import info.u_team.u_team_core.api.registry.IUPotion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UPotion
extends Potion
implements IUPotion {
    protected final String field_76416_I;
    protected final int texturesize;
    protected String texturedomain;
    protected final String texturename;
    @OnlyIn(value=Dist.CLIENT)
    private ResourceLocation texture;

    public UPotion(String name, boolean isBadEffect, int liquidColor) {
        this(name, isBadEffect, liquidColor, (String)null, 0);
    }

    public UPotion(String name, boolean isBadEffect, int liquidColor, int texturesize) {
        this(name, isBadEffect, liquidColor, "textures/potion/" + name + ".png", texturesize);
    }

    public UPotion(String name, boolean isBadEffect, int liquidColor, String texturename, int texturesize) {
        this(name, isBadEffect, liquidColor, null, texturename, texturesize);
    }

    public UPotion(String name, boolean isBadEffect, int liquidColor, ResourceLocation textureresource, int texturesize) {
        this(name, isBadEffect, liquidColor, textureresource.func_110624_b(), textureresource.func_110623_a(), texturesize);
    }

    public UPotion(String name, boolean isBadEffect, int liquidColor, String texturedomain, String texturename, int texturesize) {
        super(isBadEffect, liquidColor);
        this.field_76416_I = name;
        this.texturedomain = texturedomain;
        this.texturename = texturename;
        this.texturesize = texturesize;
    }

    @Override
    public String getEntryName() {
        return this.field_76416_I;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bindTexture(TextureManager manager) {
        if (this.texturename == null) {
            return;
        }
        if (this.texture == null) {
            this.texture = new ResourceLocation(this.texturedomain == null ? this.getRegistryName().func_110624_b() : this.texturedomain, this.texturename);
        }
        manager.func_110577_a(this.texture);
    }

    public boolean shouldRender(PotionEffect effect) {
        return this.texturename != null;
    }

    public boolean shouldRenderHUD(PotionEffect effect) {
        return this.texturename != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInventoryEffect(PotionEffect effect, Gui gui, int x, int y, float z) {
        this.bindTexture(Minecraft.func_71410_x().func_110434_K());
        Gui.func_152125_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)this.texturesize, (int)this.texturesize, (int)18, (int)18, (float)this.texturesize, (float)this.texturesize);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUDEffect(PotionEffect effect, Gui gui, int x, int y, float z, float alpha) {
        this.bindTexture(Minecraft.func_71410_x().func_110434_K());
        Gui.func_152125_a((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)this.texturesize, (int)this.texturesize, (int)18, (int)18, (float)this.texturesize, (float)this.texturesize);
    }
}

