/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.registry;

import info.u_team.u_team_core.api.registry.IUBlock;
import info.u_team.u_team_core.registry.ItemRegistry;
import info.u_team.u_team_core.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="uteamcore", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlockRegistry {
    static List<Block> blocks = new ArrayList<Block>();

    public static void register(String modid, Block block) {
        if (block instanceof IUBlock) {
            IUBlock ublock = (IUBlock)block;
            block.setRegistryName(modid, ublock.getEntryName());
            ItemBlock itemblock = ublock.getItemBlock();
            if (itemblock != null) {
                itemblock.setRegistryName(block.getRegistryName());
                ItemRegistry.items.add((Item)itemblock);
            }
        }
        blocks.add(block);
    }

    public static void register(String modid, Collection<Block> list) {
        list.forEach(block -> BlockRegistry.register(modid, block));
    }

    public static void register(String modid, Class<?> clazz) {
        BlockRegistry.register(modid, RegistryUtil.getRegistryEntries(Block.class, clazz));
    }

    @SubscribeEvent
    public static void event(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        blocks.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }
}

