/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="uteamcore", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ColorsRegistry {
    static List<Pair<IBlockColor, Block[]>> blocks = new ArrayList<Pair<IBlockColor, Block[]>>();
    static List<Pair<IItemColor, IItemProvider[]>> items = new ArrayList<Pair<IItemColor, IItemProvider[]>>();

    public static void register(IBlockColor color, Block block, Block ... moreBlocks) {
        blocks.add((Pair<IBlockColor, Block[]>)Pair.of((Object)color, (Object)ArrayUtils.add((Object[])moreBlocks, (Object)block)));
    }

    public static void register(IItemColor color, IItemProvider item, IItemProvider ... moreItems) {
        items.add((Pair<IItemColor, IItemProvider[]>)Pair.of((Object)color, (Object)ArrayUtils.add((Object[])moreItems, (Object)item)));
    }

    @SubscribeEvent
    public static void event(ColorHandlerEvent.Item event) {
        BlockColors blockcolors = event.getBlockColors();
        ItemColors itemcolors = event.getItemColors();
        blocks.forEach(pair -> blockcolors.func_186722_a((IBlockColor)pair.getKey(), (Block[])pair.getValue()));
        items.forEach(pair -> itemcolors.func_199877_a((IItemColor)pair.getKey(), (IItemProvider[])pair.getValue()));
    }
}

