/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.registry;

import info.u_team.u_team_core.api.ISyncedContainerTileEntity;
import info.u_team.u_team_core.gui.UGuiContainerTileEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;

@OnlyIn(value=Dist.CLIENT)
public class GuiRegistry {
    static Map<ModContainer, Map<ResourceLocation, Function<FMLPlayMessages.OpenContainer, GuiScreen>>> guis = new HashMap<ModContainer, Map<ResourceLocation, Function<FMLPlayMessages.OpenContainer, GuiScreen>>>();

    public static void registerTileEntity(ResourceLocation location, Function<Data, UGuiContainerTileEntity> function) {
        GuiRegistry.register(location, openContainer -> {
            PacketBuffer buffer;
            BlockPos pos;
            TileEntity tileentity;
            World world;
            EntityPlayerSP player;
            Data data = new Data((FMLPlayMessages.OpenContainer)openContainer, player, world, tileentity, (tileentity = (world = (player = Minecraft.func_71410_x().field_71439_g).func_130014_f_()).func_175625_s(pos = (buffer = openContainer.getAdditionalData()).func_179259_c())) instanceof ISyncedContainerTileEntity ? buffer.func_150793_b() : null);
            return (GuiScreen)function.apply(data);
        });
    }

    public static void register(ResourceLocation location, Function<FMLPlayMessages.OpenContainer, GuiScreen> function) {
        ModLoadingContext context = ModLoadingContext.get();
        ModContainer container = context.getActiveContainer();
        if (!guis.containsKey(container)) {
            guis.put(container, new HashMap());
            context.registerExtensionPoint(ExtensionPoint.GUIFACTORY, () -> openContainer -> guis.get(container).getOrDefault(openContainer.getId(), nullFunction -> null).apply((FMLPlayMessages.OpenContainer)openContainer));
        }
        guis.get(container).put(location, function);
    }

    public static class Data {
        private FMLPlayMessages.OpenContainer openContainer;
        private EntityPlayerSP player;
        private World world;
        private TileEntity tileentity;
        private NBTTagCompound extraNBT;

        private Data(FMLPlayMessages.OpenContainer openContainer, EntityPlayerSP player, World world, TileEntity tileentity, NBTTagCompound extraNBT) {
            this.openContainer = openContainer;
            this.player = player;
            this.world = world;
            this.tileentity = tileentity;
            this.extraNBT = extraNBT;
        }

        public FMLPlayMessages.OpenContainer getOpenContainer() {
            return this.openContainer;
        }

        public EntityPlayerSP getPlayer() {
            return this.player;
        }

        public World getWorld() {
            return this.world;
        }

        public TileEntity getTileentity() {
            return this.tileentity;
        }

        public NBTTagCompound getExtraNBT() {
            return this.extraNBT;
        }
    }
}

