/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.world;

import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.WorldSavedData;

public class WorldUtil {
    public static RayTraceResult rayTraceServerSide(EntityPlayer player, double range) {
        return WorldUtil.rayTraceServerSide(player, range, RayTraceFluidMode.NEVER, false, true);
    }

    public static RayTraceResult rayTraceServerSide(EntityPlayer player, double range, RayTraceFluidMode liquidMode, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        Vec3d playerVector = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d lookVector = player.func_70040_Z();
        Vec3d locationVector = playerVector.func_72441_c(lookVector.field_72450_a * range, lookVector.field_72448_b * range, lookVector.field_72449_c * range);
        return player.field_70170_p.func_200259_a(playerVector, locationVector, liquidMode, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
    }

    public static <T extends WorldSavedData> T getSaveData(World world, String name, Function<String, T> function) {
        DimensionType type = world.func_201675_m().func_186058_p();
        WorldSavedData instance = world.func_212411_a(type, function, name);
        if (instance == null) {
            instance = (WorldSavedData)function.apply(name);
            world.func_212409_a(type, name, instance);
        }
        return (T)instance;
    }
}

