/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.container;

import com.google.common.collect.Lists;
import info.u_team.u_team_core.api.fluid.IFluidHandlerModifiable;
import info.u_team.u_team_core.container.FluidSlot;
import info.u_team.u_team_core.intern.init.UCoreNetwork;
import info.u_team.u_team_core.intern.network.FluidSetAllContainerMessage;
import info.u_team.u_team_core.intern.network.FluidSetSlotContainerMessage;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public abstract class FluidContainer
extends Container {
    private final NonNullList<FluidStack> fluidStacks = NonNullList.func_191196_a();
    public final List<FluidSlot> fluidSlots = Lists.newArrayList();

    public FluidContainer(ContainerType<?> type, int id) {
        super(type, id);
    }

    protected FluidSlot addFluidSlot(FluidSlot slot) {
        slot.slotNumber = this.fluidSlots.size();
        this.fluidSlots.add(slot);
        this.fluidStacks.add((Object)FluidStack.EMPTY);
        return slot;
    }

    public FluidSlot getFluidSlot(int slot) {
        return this.fluidSlots.get(slot);
    }

    public NonNullList<FluidStack> getFluids() {
        NonNullList list = NonNullList.func_191196_a();
        for (int index = 0; index < this.fluidSlots.size(); ++index) {
            list.add((Object)this.fluidSlots.get(index).getStack());
        }
        return list;
    }

    public void fluidSlotClick(ServerPlayerEntity player, int index, boolean shift, ItemStack clientClickStack) {
        int maximumTries;
        ItemStack serverClickStack = player.field_71071_by.func_70445_o();
        if (serverClickStack.func_190926_b()) {
            return;
        }
        if (!ItemStack.func_77989_b((ItemStack)clientClickStack, (ItemStack)serverClickStack)) {
            return;
        }
        if (index < 0 && index >= this.fluidSlots.size()) {
            return;
        }
        FluidSlot fluidSlot = this.fluidSlots.get(index);
        LazyOptional containedFluidOptional = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)serverClickStack, (int)1)).map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
        if (!containedFluidOptional.isPresent()) {
            return;
        }
        int n = maximumTries = shift ? serverClickStack.func_190916_E() : 1;
        if (!((FluidStack)containedFluidOptional.orElseThrow(AssertionError::new)).isEmpty()) {
            for (int i = 0; i < maximumTries && this.insertFluidFromItem(player, fluidSlot, shift); ++i) {
            }
        } else {
            for (int i = 0; i < maximumTries && this.extractFluidToItem(player, fluidSlot, shift); ++i) {
            }
        }
    }

    private boolean insertFluidFromItem(ServerPlayerEntity player, FluidSlot fluidSlot, boolean shift) {
        int maxAmountToFill;
        PlayerMainInvWrapper playerInventory = new PlayerMainInvWrapper(player.field_71071_by);
        ItemStack stack = player.field_71071_by.func_70445_o();
        LazyOptional fluidHandlerOptional = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        if (!fluidHandlerOptional.isPresent()) {
            return false;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)fluidHandlerOptional.orElseThrow(AssertionError::new);
        FluidStack drainedFluidStack = handler.drain(maxAmountToFill = fluidSlot.getSlotCurrentyCapacity(), IFluidHandler.FluidAction.EXECUTE);
        if (drainedFluidStack.isEmpty()) {
            return false;
        }
        if (!fluidSlot.isFluidValid(drainedFluidStack)) {
            return false;
        }
        boolean slotEmpty = fluidSlot.getStack().isEmpty();
        if (!slotEmpty && !drainedFluidStack.isFluidEqual(fluidSlot.getStack())) {
            return false;
        }
        ItemStack outputStack = handler.getContainer();
        if (stack.func_190916_E() == 1 && !shift) {
            if (slotEmpty) {
                fluidSlot.putStack(drainedFluidStack);
            } else {
                fluidSlot.getStack().grow(drainedFluidStack.getAmount());
                fluidSlot.onSlotChanged();
            }
            player.field_71071_by.func_70437_b(outputStack);
        } else if (ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)outputStack, (boolean)true).func_190926_b()) {
            if (slotEmpty) {
                fluidSlot.putStack(drainedFluidStack);
            } else {
                fluidSlot.getStack().grow(drainedFluidStack.getAmount());
                fluidSlot.onSlotChanged();
            }
            ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)outputStack, (boolean)false);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
            }
        }
        player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, player.field_71071_by.func_70445_o()));
        return true;
    }

    private boolean extractFluidToItem(ServerPlayerEntity player, FluidSlot fluidSlot, boolean shift) {
        PlayerMainInvWrapper playerInventory = new PlayerMainInvWrapper(player.field_71071_by);
        ItemStack stack = player.field_71071_by.func_70445_o();
        LazyOptional fluidHandlerOptional = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        if (!fluidHandlerOptional.isPresent()) {
            return false;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)fluidHandlerOptional.orElseThrow(AssertionError::new);
        int amountFilled = handler.fill(fluidSlot.getStack(), IFluidHandler.FluidAction.EXECUTE);
        if (amountFilled <= 0) {
            return false;
        }
        ItemStack outputStack = handler.getContainer();
        if (stack.func_190916_E() == 1 && !shift) {
            fluidSlot.getStack().shrink(amountFilled);
            if (fluidSlot.getStack().isEmpty()) {
                fluidSlot.putStack(FluidStack.EMPTY);
            } else {
                fluidSlot.onSlotChanged();
            }
            player.field_71071_by.func_70437_b(outputStack);
        } else if (ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)outputStack, (boolean)true).func_190926_b()) {
            fluidSlot.getStack().shrink(amountFilled);
            if (fluidSlot.getStack().isEmpty()) {
                fluidSlot.putStack(FluidStack.EMPTY);
            } else {
                fluidSlot.onSlotChanged();
            }
            ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)outputStack, (boolean)false);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
            }
        }
        player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, player.field_71071_by.func_70445_o()));
        return true;
    }

    public void setFluidStackInSlot(int slot, FluidStack stack) {
        this.getFluidSlot(slot).putStack(stack);
    }

    public void setAllFluidSlots(List<FluidStack> list) {
        for (int index = 0; index < list.size(); ++index) {
            this.getFluidSlot(index).putStack(list.get(index));
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        if (listener instanceof ServerPlayerEntity) {
            UCoreNetwork.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)listener), (Object)new FluidSetAllContainerMessage(this.field_75152_c, (List<FluidStack>)this.getFluids()));
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int index = 0; index < this.fluidSlots.size(); ++index) {
            FluidStack stackSlot = this.fluidSlots.get(index).getStack();
            FluidStack stackSynced = (FluidStack)this.fluidStacks.get(index);
            if (stackSynced.isFluidStackIdentical(stackSlot)) continue;
            FluidStack stackNewSynced = stackSlot.copy();
            this.fluidStacks.set(index, (Object)stackNewSynced);
            List networkManagers = this.field_75149_d.stream().filter(listener -> listener instanceof ServerPlayerEntity).map(listener -> ((ServerPlayerEntity)listener).field_71135_a.func_147298_b()).collect(Collectors.toList());
            UCoreNetwork.NETWORK.send(PacketDistributor.NMLIST.with(() -> networkManagers), (Object)new FluidSetSlotContainerMessage(this.field_75152_c, index, stackNewSynced));
        }
    }

    protected void appendFluidInventory(IFluidHandlerModifiable handler, int inventoryHeight, int inventoryWidth, int x, int y) {
        this.appendFluidInventory(handler, 0, inventoryHeight, inventoryWidth, x, y);
    }

    protected void appendFluidInventory(IFluidHandlerModifiable handler, FluidSlotHandlerFunction function, int inventoryHeight, int inventoryWidth, int x, int y) {
        this.appendFluidInventory(handler, function, 0, inventoryHeight, inventoryWidth, x, y);
    }

    protected void appendFluidInventory(IFluidHandlerModifiable handler, int startIndex, int inventoryHeight, int inventoryWidth, int x, int y) {
        this.appendFluidInventory(handler, FluidSlot::new, startIndex, inventoryHeight, inventoryWidth, x, y);
    }

    protected void appendFluidInventory(IFluidHandlerModifiable handler, FluidSlotHandlerFunction function, int startIndex, int inventoryHeight, int inventoryWidth, int x, int y) {
        for (int height = 0; height < inventoryHeight; ++height) {
            for (int width = 0; width < inventoryWidth; ++width) {
                this.addFluidSlot(function.getSlot(handler, startIndex + (width + height * inventoryWidth), width * 18 + x, height * 18 + y));
            }
        }
    }

    @FunctionalInterface
    public static interface FluidSlotHandlerFunction {
        public FluidSlot getSlot(IFluidHandlerModifiable var1, int var2, int var3, int var4);
    }
}

