/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.registry;

import info.u_team.u_team_core.api.registry.IBlockItemProvider;
import info.u_team.u_team_core.util.registry.BlockRegistryObject;
import info.u_team.u_team_core.util.registry.CommonDeferredRegister;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockDeferredRegister {
    private final CommonDeferredRegister<Block> blocks;
    private final CommonDeferredRegister<Item> items;
    private final Map<RegistryObject<? extends Block>, RegistryObject<? extends Item>> blockToItemsMap;

    public static BlockDeferredRegister create(String modid) {
        return new BlockDeferredRegister(modid);
    }

    protected BlockDeferredRegister(String modid) {
        this.blocks = CommonDeferredRegister.create(ForgeRegistries.BLOCKS, modid);
        this.items = CommonDeferredRegister.create(ForgeRegistries.ITEMS, modid);
        this.blockToItemsMap = new HashMap<RegistryObject<? extends Block>, RegistryObject<? extends Item>>();
    }

    public <B extends Block, I extends BlockItem> BlockRegistryObject<B, I> register(String name, Supplier<? extends B> supplier) {
        RegistryObject<? extends B> block = this.blocks.register(name, supplier);
        RegistryObject item = RegistryObject.of((ResourceLocation)new ResourceLocation(this.blocks.getModid(), name), (IForgeRegistry)ForgeRegistries.ITEMS);
        this.blockToItemsMap.put(block, (RegistryObject<? extends Item>)item);
        return new BlockRegistryObject(block, item);
    }

    public <B extends Block, I extends BlockItem> BlockRegistryObject<B, I> register(String name, Supplier<? extends B> blockSupplier, Supplier<? extends I> itemSupplier) {
        RegistryObject<? extends B> block = this.blocks.register(name, blockSupplier);
        RegistryObject<? extends I> item = this.items.register(name, itemSupplier);
        return new BlockRegistryObject<B, I>(block, item);
    }

    public <B extends Block> RegistryObject<B> registerBlock(String name, Supplier<? extends B> supplier) {
        return this.blocks.register(name, supplier);
    }

    public void register(IEventBus bus) {
        this.blocks.register(bus);
        this.items.register(bus);
        bus.addGenericListener(Item.class, this::registerItems);
    }

    private void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        this.blockToItemsMap.forEach((blockObject, itemObject) -> {
            Block block = (Block)blockObject.get();
            if (block instanceof IBlockItemProvider) {
                BlockItem blockItem = ((IBlockItemProvider)block).getBlockItem();
                registry.register(blockItem.setRegistryName(itemObject.getId()));
                itemObject.updateReference(registry);
            }
        });
    }

    public CommonDeferredRegister<Block> getBlockRegister() {
        return this.blocks;
    }

    public CommonDeferredRegister<Item> getItemRegister() {
        return this.items;
    }
}

