/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.command;

import com.google.common.collect.Lists;
import info.u_team.u_team_core.schematic.USchematicLoadRegion;
import info.u_team.u_team_core.schematic.USchematicReader;
import info.u_team.u_team_core.schematic.USchematicRotation;
import info.u_team.u_team_core.schematic.USchematicSaveRegion;
import info.u_team.u_team_core.schematic.USchematicWriter;
import info.u_team.u_team_core.util.io.FileUtil;
import java.io.File;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class CommandUSchematic
extends CommandBase {
    private String lang = "command.uschematic.";

    public String func_71517_b() {
        return "uschematic";
    }

    public String func_71518_a(ICommandSender sender) {
        return this.lang + "usage";
    }

    public int func_82362_a() {
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = CommandUSchematic.func_71521_c((ICommandSender)sender);
        World world = player.func_130014_f_();
        if (args.length <= 0) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        if (args[0].equalsIgnoreCase("save")) {
            if (args.length != 8) {
                throw new WrongUsageException(this.func_71518_a(sender) + ".save", new Object[0]);
            }
            try {
                String name = this.stripName(args[1]);
                BlockPos pos1 = CommandUSchematic.func_175757_a((ICommandSender)sender, (String[])args, (int)2, (boolean)false);
                BlockPos pos2 = CommandUSchematic.func_175757_a((ICommandSender)sender, (String[])args, (int)5, (boolean)false);
                File file = new File(this.getSchematicPath(), name + ".uschematic");
                USchematicSaveRegion region = new USchematicSaveRegion(world, pos1, pos2);
                USchematicWriter writer = new USchematicWriter(region, file);
                writer.finished((success, seconds) -> {
                    if (success.booleanValue()) {
                        CommandUSchematic.func_152373_a((ICommandSender)player, (ICommand)this, (String)(this.lang + "success.save"), (Object[])new Object[]{pos1, pos2, name, seconds});
                    }
                }).start();
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new CommandException(this.lang + "error", new Object[]{"saving", ex.getClass().getName()});
            }
        }
        if (!args[0].equalsIgnoreCase("load")) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        if (args.length != 4 && args.length != 7) {
            throw new WrongUsageException(this.func_71518_a(sender) + ".load", new Object[0]);
        }
        try {
            String name = this.stripName(args[1]);
            USchematicRotation rotation = this.parseRotation(args[2]);
            boolean center = args[3].equalsIgnoreCase("true");
            BlockPos pos = args.length == 4 ? player.func_180425_c() : CommandUSchematic.func_175757_a((ICommandSender)sender, (String[])args, (int)4, (boolean)false);
            File file = new File(this.getSchematicPath(), name + ".uschematic");
            USchematicLoadRegion region = new USchematicLoadRegion(world, pos).rotate(rotation);
            if (center) {
                region.center();
            }
            USchematicReader reader = new USchematicReader(region, file);
            reader.finished((success, seconds) -> {
                if (success.booleanValue()) {
                    CommandUSchematic.func_152373_a((ICommandSender)player, (ICommand)this, (String)(this.lang + "success.load"), (Object[])new Object[]{name, pos, seconds});
                }
            }).start();
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CommandException(this.lang + "error", new Object[]{"loading", ex.getClass().getName()});
        }
    }

    public List func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandUSchematic.func_71530_a((String[])args, (String[])new String[]{"save", "load"});
        }
        if (args[0].equalsIgnoreCase("save")) {
            if (args.length == 2) {
                return CommandUSchematic.func_71530_a((String[])args, (String[])new String[]{"name"});
            }
            if (args.length >= 3 && args.length <= 5) {
                return CommandUSchematic.func_175771_a((String[])args, (int)2, (BlockPos)pos);
            }
            if (args.length >= 5 && args.length <= 8) {
                return CommandUSchematic.func_175771_a((String[])args, (int)5, (BlockPos)pos);
            }
        } else if (args[0].equalsIgnoreCase("load")) {
            if (args.length == 2) {
                try {
                    return CommandUSchematic.func_71530_a((String[])args, (String[])FileUtil.getFileNamesInDirectionary(this.getSchematicPath(), ".uschematic", ""));
                }
                catch (Exception exception) {
                }
            } else {
                if (args.length == 3) {
                    return Lists.newArrayList((Object[])new String[]{"0", "90", "180", "270"});
                }
                if (args.length == 4) {
                    return Lists.newArrayList((Object[])new String[]{"true", "false"});
                }
                if (args.length >= 1 && args.length <= 7) {
                    return CommandUSchematic.func_175771_a((String[])args, (int)4, (BlockPos)pos);
                }
            }
        }
        return super.func_180525_a(sender, args, pos);
    }

    private String stripName(String name) {
        return name.replaceAll("[^a-zA-Z0-9_.-]", "");
    }

    private File getSchematicPath() {
        File file = new File(FileUtil.getMainDirectory(), "uschematic");
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    private USchematicRotation parseRotation(String string) {
        if (string.equalsIgnoreCase("90")) {
            return USchematicRotation.ROTATION_90;
        }
        if (string.equalsIgnoreCase("180")) {
            return USchematicRotation.ROTATION_180;
        }
        if (string.equalsIgnoreCase("270")) {
            return USchematicRotation.ROTATION_270;
        }
        return USchematicRotation.ROTATION_0;
    }
}

