/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.discord;

import info.u_team.u_team_core.intern.UCoreConstants;
import info.u_team.u_team_core.intern.discord.DiscordRichPresenceListener;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.IPCClient;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.DiscordBuild;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.RichPresence;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import java.time.OffsetDateTime;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.common.Loader;

public class DiscordRichPresence {
    private static IPCClient client = new IPCClient(427196986064764928L);
    private static State current = null;

    public static void start() {
        try {
            client.connect(new DiscordBuild[0]);
        }
        catch (NoDiscordClientException ex) {
            UCoreConstants.LOGGER.info("No discord client is present.");
        }
        DiscordRichPresence.setIdling();
    }

    public static void setIdling() {
        DiscordRichPresence.setState(State.MENU);
    }

    public static void setDimension(WorldProvider provider) {
        switch (provider.func_177502_q()) {
            case -1: {
                DiscordRichPresence.setState(State.NETHER);
                break;
            }
            case 0: {
                DiscordRichPresence.setState(State.OVERWORLD);
                break;
            }
            case 1: {
                DiscordRichPresence.setState(State.END);
                break;
            }
            default: {
                DiscordRichPresence.setState(State.DIM, provider.func_80007_l());
            }
        }
    }

    public static void setState(State state) {
        DiscordRichPresence.setState(state, "");
    }

    public static void setState(State state, String replace) {
        if (state == current && state != State.DIM && current != State.DIM) {
            return;
        }
        current = state;
        try {
            RichPresence.Builder builder = new RichPresence.Builder();
            builder.setDetails("Minecraft 1.8 with " + Loader.instance().getModList().size() + " Mods");
            builder.setState(state.getMessage(replace));
            builder.setStartTimestamp(OffsetDateTime.now());
            builder.setLargeImage(state.getImageKey(), state.getImageName(replace));
            if (state == State.MENU) {
                builder.setSmallImage("uteamcore", "U Team Core");
            }
            client.sendRichPresence(builder.build());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                client.close();
            }
        });
        client.setListener(new DiscordRichPresenceListener());
    }

    public static enum State {
        MENU("Idling in menu", "Minecraft", "minecraft"),
        OVERWORLD("Dimension: Overworld", "Overworld", "world_overworld"),
        NETHER("Dimension: Nether", "Nether", "world_nether"),
        END("Dimension: The End", "The End", "world_the_end"),
        DIM("Dimension: %s", "%s", "world_dim");

        private String message;
        private String imagename;
        private String imagekey;

        private State(String message, String imagename, String imagekey) {
            this.message = message;
            this.imagename = imagename;
            this.imagekey = imagekey;
        }

        public String getMessage(String replace) {
            return this.message.replace("%s", replace);
        }

        public String getImageName(String replace) {
            return this.imagename.replace("%s", replace);
        }

        public String getImageKey() {
            return this.imagekey;
        }
    }
}

