/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.discord;

import info.u_team.u_team_core.intern.UCoreConstants;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.IPCClient;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.IPCListener;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.DiscordBuild;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import info.u_team.u_team_core.repack.org.json.JSONObject;
import java.util.Timer;
import java.util.TimerTask;

public class DiscordRichPresenceListener
implements IPCListener {
    private Timer timer = new Timer();
    private int reconnect;

    @Override
    public void onClose(IPCClient client, JSONObject json) {
        UCoreConstants.LOGGER.info("Discord connection was closed.");
    }

    @Override
    public void onDisconnect(IPCClient client, Throwable t) {
        UCoreConstants.LOGGER.info("Discord connection has been lost because of " + t.getMessage() + ".");
        this.addReconnectionTry(client);
    }

    @Override
    public void onReady(IPCClient client) {
        this.reconnect = 0;
    }

    private void addReconnectionTry(final IPCClient client) {
        if (this.reconnect > 10) {
            return;
        }
        ++this.reconnect;
        UCoreConstants.LOGGER.info("Trying to connect to discord again in 60 seconds.");
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    client.connect(new DiscordBuild[0]);
                    UCoreConstants.LOGGER.info("Sucessfully reconnected to discord.");
                }
                catch (NoDiscordClientException ex) {
                    UCoreConstants.LOGGER.info("Discord connection could not be recovered. Connection attempt " + DiscordRichPresenceListener.this.reconnect + ". Retry in 60 seconds.");
                    DiscordRichPresenceListener.this.addReconnectionTry(client);
                }
            }
        }, 60000L);
    }
}

