/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.item.armor;

import info.u_team.u_team_core.creativetab.UCreativeTab;
import info.u_team.u_team_core.sub.USub;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UItemArmor
extends ItemArmor {
    private String name;
    private String modid = USub.getID();
    private String typename;
    private String texturepath;

    public UItemArmor(String name, ItemArmor.ArmorMaterial material, int type, String typename) {
        this(name, null, material, type, typename);
    }

    public UItemArmor(String name, UCreativeTab tab, ItemArmor.ArmorMaterial material, int type, String typename) {
        super(material, -1, type);
        this.name = name;
        this.typename = typename;
        this.func_77655_b(USub.getID() + ":" + name + "_" + typename);
        this.texturepath = USub.getID() + ":textures/models/armor/" + name;
        if (tab != null) {
            this.func_77637_a(tab);
        }
        this.register();
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (slot == 0 || slot == 1 || slot == 3) {
            return this.texturepath + "_1.png";
        }
        if (slot == 2) {
            return this.texturepath + "_2.png";
        }
        return null;
    }

    public void setTexturepath(String texturepath) {
        this.texturepath = texturepath;
    }

    private final void register() {
        GameRegistry.registerItem((Item)this, (String)(this.name + "_" + this.typename));
    }

    public ResourceLocation getRegistryName() {
        return new ResourceLocation(this.modid, this.name + "_" + this.typename);
    }
}

