/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.render;

import info.u_team.u_team_core.intern.UCoreConstants;
import info.u_team.u_team_core.render.BufferEntry;
import info.u_team.u_team_core.render.DrawFormat;
import info.u_team.u_team_core.render.GLSize;
import info.u_team.u_team_core.render.GuiResourceLocation;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class GLTG {
    private static GLTG INSTANCE;
    private BufferEntry entry = BufferEntry.getBufferEntry();
    private Logger log = UCoreConstants.LOGGER;

    private GLTG() {
    }

    public GLSize setTexture(GuiResourceLocation location) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a((ResourceLocation)location);
        return new GLSize(GL11.glGetTexLevelParameterf((int)3553, (int)0, (int)4096), GL11.glGetTexLevelParameterf((int)3553, (int)0, (int)4097));
    }

    public void drawManual(@Nonnull float[][] vertex, float[][] color, float[][] tex, float[][] normal) {
        DrawFormat form;
        if (this.entry == null) {
            this.log.error("BufferEntry in GLTG drawManual is null");
            return;
        }
        if (vertex == null) {
            this.log.error("Vertex array in GLTG drawManual is null");
            return;
        }
        if (color == null) {
            if (tex == null) {
                this.log.error("Invalide DrawFormat tex must not be null if color is");
                return;
            }
            form = normal == null ? DrawFormat.POS_TEX : DrawFormat.POS_TEX_NORMAL;
        } else {
            form = tex == null ? DrawFormat.POS_COLOR : (normal == null ? DrawFormat.POS_TEX_COLOR : DrawFormat.POS_TEX_COLOR_NORMAL);
        }
        this.entry.start(form);
        int i = -1;
        for (float[] vert : vertex) {
            ++i;
            try {
                this.entry.vertex(vert[0], vert[1], vert[2]);
                if (color != null && (form == DrawFormat.POS_COLOR || form == DrawFormat.POS_TEX_COLOR || form == DrawFormat.POS_TEX_COLOR_NORMAL)) {
                    this.entry.color(color[i][0], color[i][1], color[i][2], color[i][3]);
                }
                if (tex != null && (form == DrawFormat.POS_TEX || form == DrawFormat.POS_TEX_COLOR || form == DrawFormat.POS_TEX_NORMAL || form == DrawFormat.POS_TEX_COLOR_NORMAL)) {
                    this.entry.tex(tex[i][0], tex[i][1]);
                }
                if (normal != null && (form == DrawFormat.POS_TEX_NORMAL || form == DrawFormat.POS_TEX_COLOR_NORMAL)) {
                    this.entry.tex(tex[i][0], tex[i][1]);
                }
                this.entry.end();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.log.error("Error in draw of Pylogen \n Maybe wrong verticies :/", (Throwable)e);
            }
        }
        this.entry.endDraw();
    }

    public static float[] vertex(float ... data) {
        return data;
    }

    public static float[][] data(float[] ... data) {
        return data;
    }

    public static GLTG getGLTG() {
        if (INSTANCE != null) {
            INSTANCE = new GLTG();
        }
        return INSTANCE;
    }
}

