/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.schematic;

import info.u_team.u_team_core.intern.UCoreConstants;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class USchematicEntry {
    private ResourceLocation registryname;
    private int meta;
    private NBTTagCompound nbt;

    public USchematicEntry(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        this.registryname = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        this.meta = block.func_176201_c(state);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity != null) {
            this.nbt = new NBTTagCompound();
            tileentity.func_145841_b(this.nbt);
            this.nbt.func_82580_o("x");
            this.nbt.func_82580_o("y");
            this.nbt.func_82580_o("z");
        }
    }

    public USchematicEntry(NBTTagCompound tag) {
        this.registryname = new ResourceLocation(tag.func_74779_i("name"));
        this.meta = tag.func_74762_e("meta");
        this.nbt = tag.func_74775_l("nbt");
    }

    public void setBlock(World world, BlockPos pos) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)this.registryname);
        if (block == null) {
            UCoreConstants.LOGGER.warn("Block registryname " + this.registryname + " in schematic was not found in minecraft!? Mods missing?");
            block = Blocks.field_150350_a;
        }
        IBlockState state = block.func_176203_a(this.meta);
        world.func_175656_a(pos, state);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity != null && this.nbt != null) {
            this.nbt.func_74768_a("x", pos.func_177958_n());
            this.nbt.func_74768_a("y", pos.func_177956_o());
            this.nbt.func_74768_a("z", pos.func_177952_p());
            tileentity.func_145839_a(this.nbt);
        }
    }

    public NBTTagCompound getTag() {
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74778_a("name", this.registryname.toString());
        entry.func_74768_a("meta", this.meta);
        if (this.nbt != null) {
            entry.func_74782_a("nbt", (NBTBase)this.nbt);
        }
        return entry;
    }
}

