/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.sub.metadata;

import com.google.common.collect.ImmutableMap;
import info.u_team.u_team_core.intern.UCoreConstants;
import info.u_team.u_team_core.util.io.FileUtil;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModMetadata;

public class MetadataFetcher {
    private ModMetadata modmeta;

    public MetadataFetcher(String modid) {
        ImmutableMap map = ImmutableMap.builder().put((Object)"name", (Object)modid).put((Object)"version", (Object)"1.0").build();
        this.modmeta = MetadataCollection.from((InputStream)FileUtil.getInputStreamFromResource("/" + modid + ".json"), (String)modid).getMetadataForId(modid, (Map)map);
        if (this.modmeta.name == null || this.modmeta.name.isEmpty()) {
            this.modmeta.name = map.get("name").toString();
        }
        if (this.modmeta.version == null || this.modmeta.version.isEmpty()) {
            this.modmeta.version = map.get("version").toString();
        }
        this.modmeta.autogenerated = false;
    }

    public MetadataFetcher setName(String name) {
        if (name != null) {
            this.modmeta.name = name;
        }
        return this;
    }

    public MetadataFetcher setVersion(String version) {
        if (version != null) {
            this.modmeta.version = version;
        }
        return this;
    }

    public ModMetadata getModmeta() {
        return this.modmeta;
    }

    public void applyMetadata(ModMetadata modmetatoapply) {
        try {
            Class<ModMetadata> modmetadata = ModMetadata.class;
            for (Field field : modmetadata.getDeclaredFields()) {
                field.set(modmetatoapply, field.get(this.modmeta));
            }
        }
        catch (Exception ex) {
            UCoreConstants.LOGGER.error("Couldn't apply metadata.", (Throwable)ex);
        }
    }
}

