/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.registry;

import info.u_team.u_team_core.util.stack.BlockUtil;
import info.u_team.u_team_core.util.stack.ItemUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientRegistry {
    public static void registerEntityRenderingHandler(Class<? extends Entity> clazz, Render renderer) {
        RenderingRegistry.registerEntityRenderingHandler(clazz, (Render)renderer);
    }

    public static void registerKeybinding(KeyBinding key) {
        net.minecraftforge.fml.client.registry.ClientRegistry.registerKeyBinding((KeyBinding)key);
    }

    public static void registerModel(Item item) {
        ClientRegistry.registerModel(item, 0);
    }

    public static void registerModel(Block block) {
        ClientRegistry.registerModel(block, 0);
    }

    public static void registerModel(Item item, int meta) {
        ClientRegistry.registerModel(item, meta, new ModelResourceLocation(ItemUtil.getRegistryName(item), "inventory"));
    }

    public static void registerModel(Block block, int meta) {
        ClientRegistry.registerModel(block, meta, new ModelResourceLocation(BlockUtil.getRegistryName(block), "inventory"));
    }

    public static void registerModel(Item item, int meta, ModelResourceLocation location) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)location);
    }

    public static void registerModel(Block block, int meta, ModelResourceLocation location) {
        ClientRegistry.registerModel(Item.func_150898_a((Block)block), meta, location);
    }

    public static void registerModelVariants(Item item, String ... names) {
        ModelBakery.addVariantName((Item)item, (String[])names);
    }

    public static <T extends TileEntity> void registerSpecialTileEntityRenderer(Class<T> clazz, TileEntitySpecialRenderer renderer) {
        net.minecraftforge.fml.client.registry.ClientRegistry.bindTileEntitySpecialRenderer(clazz, (TileEntitySpecialRenderer)renderer);
    }
}

