/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client;

import com.mrcrayfish.obfuscate.client.event.ModelPlayerEvent;
import com.mrcrayfish.obfuscate.client.event.RenderItemEvent;
import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.block.BlockFluidPipe;
import com.mrcrayfish.vehicle.block.BlockFluidPump;
import com.mrcrayfish.vehicle.block.BlockFuelDrum;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.VehicleRenderRegistry;
import com.mrcrayfish.vehicle.common.entity.SyncedPlayerData;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.item.ItemSprayCan;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageCycleSeats;
import com.mrcrayfish.vehicle.network.message.MessageHitchTrailer;
import com.mrcrayfish.vehicle.proxy.ClientProxy;
import com.mrcrayfish.vehicle.tileentity.TileEntityFluidPipe;
import com.mrcrayfish.vehicle.util.RenderUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

public class ClientEvents {
    private int lastSlot = -1;
    private int originalPerspective = -1;
    private double fuelingHandOffset;
    private int tickCounter;
    private boolean fueling;
    private double offsetPrev;
    private double offsetPrevPrev;
    private boolean shouldRenderNozzle;

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        if (VehicleConfig.CLIENT.display.autoPerspective && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && event.getEntityMounting().equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            if (event.isMounting()) {
                Entity entity = event.getEntityBeingMounted();
                if (entity instanceof EntityVehicle) {
                    this.originalPerspective = Minecraft.func_71410_x().field_71474_y.field_74320_O;
                    Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
                }
            } else if (this.originalPerspective != -1) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = this.originalPerspective;
                this.originalPerspective = -1;
            }
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Entity entity;
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (VehicleConfig.CLIENT.display.autoPerspective && (entity = Minecraft.func_71410_x().field_71439_g.func_184187_bx()) instanceof EntityVehicle && Minecraft.func_71410_x().field_71474_y.field_151457_aa.func_151470_d()) {
            this.originalPerspective = -1;
        }
        if (ClientProxy.KEY_CYCLE_SEATS.func_151468_f() && Minecraft.func_71410_x().field_71439_g.func_184187_bx() instanceof EntityVehicle) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageCycleSeats());
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (VehicleConfig.CLIENT.display.enabledSpeedometer && event.phase == TickEvent.Phase.END) {
            Entity entity;
            EntityPlayerSP player;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71415_G && (player = mc.field_71439_g) != null && (entity = player.func_184187_bx()) instanceof EntityPoweredVehicle) {
                EntityPoweredVehicle vehicle = (EntityPoweredVehicle)entity;
                String speed = new DecimalFormat("0.0").format(vehicle.getKilometersPreHour());
                mc.field_71466_p.func_175063_a(TextFormatting.BOLD + "BPS: " + TextFormatting.YELLOW + speed, 10.0f, 10.0f, Color.WHITE.getRGB());
                if (vehicle.requiresFuel()) {
                    DecimalFormat format = new DecimalFormat("0.0");
                    String fuel = format.format(vehicle.getCurrentFuel()) + "/" + format.format(vehicle.getFuelCapacity());
                    mc.field_71466_p.func_175063_a(TextFormatting.BOLD + "Fuel: " + TextFormatting.YELLOW + fuel, 10.0f, 25.0f, Color.WHITE.getRGB());
                }
            }
        }
    }

    @SubscribeEvent
    public void onFovUpdate(FOVUpdateEvent event) {
        Entity ridingEntity = Minecraft.func_71410_x().field_71439_g.func_184187_bx();
        if (ridingEntity instanceof EntityVehicle) {
            event.setNewfov(1.0f);
        }
    }

    @SubscribeEvent
    public void onPreRender(ModelPlayerEvent.Render.Pre event) {
        EntityVehicle vehicle;
        AbstractRenderVehicle<?> render;
        EntityPlayer player = event.getEntityPlayer();
        Entity ridingEntity = player.func_184187_bx();
        if (ridingEntity instanceof EntityVehicle && (render = VehicleRenderRegistry.getRender(((Object)((Object)(vehicle = (EntityVehicle)ridingEntity))).getClass())) != null) {
            render.applyPlayerRender(vehicle, player, event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void onSetupAngles(ModelPlayerEvent.SetupAngles.Post event) {
        EntityVehicle vehicle;
        AbstractRenderVehicle<?> render;
        EntityPlayer player = event.getEntityPlayer();
        if (player.equals((Object)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            return;
        }
        Entity ridingEntity = player.func_184187_bx();
        ModelPlayer model = event.getModelPlayer();
        if (SyncedPlayerData.getGasPumpPos(player).isPresent()) {
            boolean rightHanded;
            boolean bl = rightHanded = player.func_184591_cq() == EnumHandSide.RIGHT;
            if (rightHanded) {
                model.field_178723_h.field_78795_f = (float)Math.toRadians(-20.0);
                model.field_178723_h.field_78796_g = (float)Math.toRadians(0.0);
                model.field_178723_h.field_78808_h = (float)Math.toRadians(0.0);
            } else {
                model.field_178724_i.field_78795_f = (float)Math.toRadians(-20.0);
                model.field_178724_i.field_78796_g = (float)Math.toRadians(0.0);
                model.field_178724_i.field_78808_h = (float)Math.toRadians(0.0);
            }
            return;
        }
        if (!player.func_184218_aH()) {
            ItemStack leftItem;
            boolean rightHanded = player.func_184591_cq() == EnumHandSide.RIGHT;
            ItemStack rightItem = rightHanded ? player.func_184614_ca() : player.func_184592_cb();
            ItemStack itemStack = leftItem = rightHanded ? player.func_184592_cb() : player.func_184614_ca();
            if (!rightItem.func_190926_b() && rightItem.func_77973_b() instanceof ItemSprayCan) {
                ClientEvents.copyModelAngles(model.field_78116_c, model.field_178723_h);
                model.field_178723_h.field_78795_f = (float)((double)model.field_178723_h.field_78795_f + Math.toRadians(-80.0));
            }
            if (!leftItem.func_190926_b() && leftItem.func_77973_b() instanceof ItemSprayCan) {
                ModelBiped.func_178685_a((ModelRenderer)model.field_78116_c, (ModelRenderer)model.field_178724_i);
                model.field_178724_i.field_78795_f = (float)((double)model.field_178724_i.field_78795_f + Math.toRadians(-80.0));
            }
        }
        if (ridingEntity != null && ridingEntity instanceof EntityVehicle && (render = VehicleRenderRegistry.getRender(((Object)((Object)(vehicle = (EntityVehicle)ridingEntity))).getClass())) != null) {
            render.applyPlayerModel(vehicle, player, model, event.getPartialTicks());
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void copyModelAngles(ModelRenderer source, ModelRenderer dest) {
        dest.field_78795_f = source.field_78795_f;
        dest.field_78796_g = source.field_78796_g;
        dest.field_78808_h = source.field_78808_h;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.phase == TickEvent.Phase.END && player != null) {
            int slot = player.field_71071_by.field_70461_c;
            if (this.lastSlot != slot) {
                this.lastSlot = slot;
                if (!player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemSprayCan) {
                    float pitch = 0.85f + 0.15f * ItemSprayCan.getRemainingSprays(player.field_71071_by.func_70448_g());
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_194007_a((SoundEvent)ModSounds.SPRAY_CAN_SHAKE, (float)pitch, (float)0.75f));
                }
            }
            if (VehicleConfig.CLIENT.debug.reloadVehiclePropertiesEachTick) {
                VehicleProperties.register();
            }
            if (player.func_184187_bx() == null) {
                this.originalPerspective = -1;
            }
            ++this.tickCounter;
            EntityRaytracer.RayTraceResultRotated result = EntityRaytracer.getContinuousInteraction();
            if (result != null && result.equalsContinuousInteraction(EntityRaytracer.FUNCTION_FUELING)) {
                if (!this.fueling) {
                    this.tickCounter = 0;
                    this.fueling = true;
                }
            } else {
                this.fueling = false;
            }
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderSpecificHandEvent event) {
        EntityPlayerSP player;
        if (event.getHand() == EnumHand.OFF_HAND && this.fuelingHandOffset > -1.0) {
            GlStateManager.func_179114_b((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)(-0.35 - this.fuelingHandOffset), (double)0.2);
        }
        if (!event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() instanceof ItemSprayCan && event.getItemStack().func_77960_j() == 0) {
            ItemStack stack = event.getItemStack().func_77946_l();
            stack.func_77964_b(1);
            Minecraft.func_71410_x().func_175597_ag().func_187457_a((AbstractClientPlayer)Minecraft.func_71410_x().field_71439_g, event.getPartialTicks(), event.getInterpolatedPitch(), event.getHand(), event.getSwingProgress(), stack, event.getEquipProgress());
            event.setCanceled(true);
        }
        this.fuelingHandOffset = -1.0;
        EntityRaytracer.RayTraceResultRotated result = EntityRaytracer.getContinuousInteraction();
        if (result != null && result.equalsContinuousInteraction(EntityRaytracer.FUNCTION_FUELING) && event.getHand() == EntityRaytracer.getContinuousInteractionObject()) {
            double offset = Math.sin((double)((float)this.tickCounter + Minecraft.func_71410_x().func_184121_ak()) * 0.4) * 0.01;
            if (this.offsetPrev > this.offsetPrevPrev && this.offsetPrev > offset) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(ModSounds.LIQUID_GLUG, 0.3f, 1.0f);
            }
            this.offsetPrevPrev = this.offsetPrev;
            this.offsetPrev = offset;
            GlStateManager.func_179137_b((double)0.0, (double)(0.35 + offset), (double)-0.2);
            GlStateManager.func_179114_b((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (event.getHand() == EnumHand.MAIN_HAND) {
                this.fuelingHandOffset = offset;
            }
        }
        if (SyncedPlayerData.getGasPumpPos((EntityPlayer)(player = Minecraft.func_71410_x().field_71439_g)).isPresent()) {
            if (event.getSwingProgress() > 0.0f) {
                this.shouldRenderNozzle = true;
            }
            if (event.getHand() == EnumHand.MAIN_HAND && this.shouldRenderNozzle) {
                if (event.getSwingProgress() > 0.0f && (double)event.getSwingProgress() <= 0.25) {
                    return;
                }
                GlStateManager.func_179094_E();
                boolean mainHand = event.getHand() == EnumHand.MAIN_HAND;
                EnumHandSide handSide = mainHand ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
                float f = -0.6f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)event.getSwingProgress()) * (float)Math.PI));
                float f1 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)event.getSwingProgress()) * ((float)Math.PI * 2)));
                float f2 = -0.2f * MathHelper.func_76126_a((float)(event.getSwingProgress() * (float)Math.PI));
                int handOffset = handSide == EnumHandSide.RIGHT ? 1 : -1;
                GlStateManager.func_179109_b((float)((float)handOffset * f), (float)f1, (float)f2);
                GlStateManager.func_179109_b((float)((float)handOffset * 0.65f), (float)-0.26999998f, (float)-0.72f);
                GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                RenderUtil.renderItemModel(new ItemStack(ModItems.MODELS), SpecialModels.NOZZLE.getModel(), ItemCameraTransforms.TransformType.NONE);
                GlStateManager.func_179121_F();
                event.setCanceled(true);
            }
        } else {
            this.shouldRenderNozzle = false;
        }
    }

    @SubscribeEvent
    public void onRenderThirdPerson(RenderItemEvent.Held.Pre event) {
        EntityLivingBase entity = event.getEntity();
        if (entity instanceof EntityPlayer && SyncedPlayerData.getGasPumpPos((EntityPlayer)entity).isPresent()) {
            event.setCanceled(true);
            return;
        }
        if (!event.getItem().func_190926_b() && event.getItem().func_77973_b() instanceof ItemSprayCan && event.getItem().func_77960_j() == 0) {
            ItemStack stack = event.getItem().func_77946_l();
            stack.func_77964_b(1);
            Minecraft.func_71410_x().func_175597_ag().func_187462_a(event.getEntity(), stack, event.getTransformType(), event.getHandSide() == EnumHandSide.LEFT);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onModelRenderPost(ModelPlayerEvent.Render.Post event) {
        EntityPlayer entity = event.getEntityPlayer();
        if (SyncedPlayerData.getGasPumpPos(entity).isPresent()) {
            GlStateManager.func_179094_E();
            if (event.getModelPlayer().field_78091_s) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.75f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            }
            GlStateManager.func_179094_E();
            if (entity.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            event.getModelPlayer().func_187073_a(0.0625f, entity.func_184591_cq());
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            boolean leftHanded = entity.func_184591_cq() == EnumHandSide.LEFT;
            GlStateManager.func_179109_b((float)((float)(leftHanded ? -1 : 1) / 16.0f), (float)0.125f, (float)-0.625f);
            GlStateManager.func_179137_b((double)0.0, (double)-0.5625, (double)0.359375);
            RenderUtil.renderItemModel(new ItemStack(ModItems.MODELS), SpecialModels.NOZZLE.getModel(), ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void renderCustomBlockHighlights(DrawBlockHighlightEvent event) {
        RayTraceResult target = event.getTarget();
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        World world = player.field_70170_p;
        BlockPos pos = target.func_178782_a();
        if (!world.func_175723_af().func_177746_a(pos)) {
            return;
        }
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockFuelDrum) {
            this.boxRenderGlStart();
            AxisAlignedBB box = state.func_185918_c(world, pos).func_186662_g((double)0.002f).func_72317_d(-dx, -dy, -dz);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            float alpha = 0.4f;
            double minX = box.field_72340_a;
            double minY = box.field_72338_b;
            double minZ = box.field_72339_c;
            double maxX = box.field_72336_d;
            double maxY = box.field_72337_e;
            double maxZ = box.field_72334_f;
            double offset = 0.2419999996200204;
            buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(minX += offset, minY, minZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(maxX -= offset, minY, minZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(minX, maxY, minZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(minX, minY, minZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            maxX += offset;
            buffer.func_181662_b(minX -= offset, minY, minZ += offset).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(minX, maxY, minZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(minX + offset, maxY, minZ - offset).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(minX, maxY, minZ).func_181669_b(0, 0, 0, 0).func_181675_d();
            buffer.func_181662_b(minX, maxY, maxZ -= offset).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(minX, minY, maxZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(minX, minY, minZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(minX, minY, maxZ).func_181669_b(0, 0, 0, 0).func_181675_d();
            minZ -= offset;
            buffer.func_181662_b(minX += offset, minY, maxZ += offset).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(minX - offset, maxY, maxZ - offset).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(minX, maxY, maxZ).func_181669_b(0, 0, 0, 0).func_181675_d();
            buffer.func_181662_b(maxX -= offset, maxY, maxZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(minX, minY, maxZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(maxX, minY, maxZ).func_181669_b(0, 0, 0, 0).func_181675_d();
            minX -= offset;
            buffer.func_181662_b(maxX += offset, minY, maxZ -= offset).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(maxX - offset, maxY, maxZ + offset).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(maxX, maxY, maxZ).func_181669_b(0, 0, 0, 0).func_181675_d();
            buffer.func_181662_b(maxX, maxY, minZ += offset).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(maxX, minY, minZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(maxX, minY, minZ).func_181669_b(0, 0, 0, 0).func_181675_d();
            maxZ += offset;
            minX += offset;
            buffer.func_181662_b(maxX -= offset, minY, minZ -= offset).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            buffer.func_181662_b(maxX, maxY, minZ).func_181669_b(0, 0, 0, 0).func_181675_d();
            buffer.func_181662_b(maxX + offset, maxY, minZ + offset).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            tessellator.func_78381_a();
            this.boxRenderGlEnd();
            event.setCanceled(true);
        } else if (state.func_177230_c() instanceof BlockFluidPipe) {
            RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
            for (EnumHand hand : EnumHand.values()) {
                AxisAlignedBB boxHit;
                if (player.func_184586_b(hand).func_77973_b() != ModItems.WRENCH) continue;
                TileEntityFluidPipe pipe = BlockFluidPipe.getTileEntity((IBlockAccess)world, pos);
                Vec3d hitVec = objectMouseOver.field_72307_f.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                Pair<AxisAlignedBB, EnumFacing> hit = ((BlockFluidPipe)state.func_177230_c()).getWrenchableBox(world, pos, state, player, hand, objectMouseOver.field_178784_b, hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, pipe);
                if (hit != null) {
                    this.boxRenderGlStart();
                    RenderGlobal.func_189697_a((AxisAlignedBB)((AxisAlignedBB)hit.getLeft()).func_186662_g((double)0.002f).func_72317_d(-dx, -dy, -dz), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    this.boxRenderGlEnd();
                } else if (state.func_177230_c() instanceof BlockFluidPump && (boxHit = ((BlockFluidPump)state.func_177230_c()).getHousingBox(world, pos, state, player, hand, hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, pipe)) != null) {
                    this.boxRenderGlStart();
                    RenderGlobal.func_189697_a((AxisAlignedBB)boxHit.func_186662_g((double)0.002f).func_72317_d(-dx, -dy, -dz), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    this.boxRenderGlEnd();
                }
                event.setCanceled(true);
                break;
            }
        }
    }

    private void boxRenderGlStart() {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
    }

    private void boxRenderGlEnd() {
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    @SubscribeEvent
    public void setLiquidFogDensity(EntityViewRenderEvent.FogDensity event) {
        boolean isSap;
        Block block = event.getState().func_177230_c();
        boolean bl = isSap = block == ModBlocks.ENDER_SAP;
        if (isSap || block == ModBlocks.FUELIUM || block == ModBlocks.BLAZE_JUICE) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            event.setDensity(isSap ? 1.0f : 0.5f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onJump(InputEvent.KeyInputEvent event) {
        if (Keyboard.getEventKeyState() && Keyboard.getEventKey() == Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151463_i()) {
            EntityVehicle vehicle;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (Minecraft.func_71410_x().field_71462_r == null && player.func_184187_bx() instanceof EntityVehicle && (vehicle = (EntityVehicle)player.func_184187_bx()).canTowTrailer()) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageHitchTrailer(vehicle.getTrailer() == null));
            }
        }
    }
}

