/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.RenderVehicleWrapper;
import com.mrcrayfish.vehicle.client.render.Wheel;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.EntityLandVehicle;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.util.math.Vec3d;

public class RenderLandVehicleWrapper<T extends EntityLandVehicle, R extends AbstractRenderVehicle<T>>
extends RenderVehicleWrapper<T, R> {
    public RenderLandVehicleWrapper(R renderVehicle) {
        super(renderVehicle);
    }

    @Override
    public void render(T entity, float partialTicks) {
        if (((EntityLandVehicle)((Object)entity)).field_70128_L) {
            return;
        }
        GlStateManager.func_179094_E();
        VehicleProperties properties = ((EntityVehicle)((Object)entity)).getProperties();
        PartPosition bodyPosition = properties.getBodyPosition();
        GlStateManager.func_179114_b((float)((float)bodyPosition.getRotX()), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)bodyPosition.getRotY()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)bodyPosition.getRotZ()), (float)0.0f, (float)0.0f, (float)1.0f);
        float additionalYaw = ((EntityLandVehicle)((Object)entity)).prevAdditionalYaw + (((EntityLandVehicle)((Object)entity)).additionalYaw - ((EntityLandVehicle)((Object)entity)).prevAdditionalYaw) * partialTicks;
        GlStateManager.func_179114_b((float)additionalYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)bodyPosition.getX(), (double)bodyPosition.getY(), (double)bodyPosition.getZ());
        if (((EntityVehicle)((Object)entity)).canTowTrailer()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Vec3d towBarOffset = properties.getTowBarPosition();
            GlStateManager.func_179137_b((double)(towBarOffset.field_72450_a * 0.0625), (double)(towBarOffset.field_72448_b * 0.0625 + 0.5), (double)(-towBarOffset.field_72449_c * 0.0625));
            RenderUtil.renderModel(this.renderVehicle.getTowBarModel().getModel(), ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
        GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
        GlStateManager.func_179139_a((double)bodyPosition.getScale(), (double)bodyPosition.getScale(), (double)bodyPosition.getScale());
        GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
        GlStateManager.func_179109_b((float)0.0f, (float)(properties.getAxleOffset() * 0.0625f), (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(properties.getWheelOffset() * 0.0625f), (float)0.0f);
        this.renderVehicle.render(entity, partialTicks);
        if (((EntityPoweredVehicle)((Object)entity)).hasWheels()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
            GlStateManager.func_179109_b((float)0.0f, (float)(-properties.getAxleOffset() * 0.0625f), (float)0.0f);
            properties.getWheels().forEach(wheel -> this.renderWheel((EntityLandVehicle)((Object)entity), (Wheel)wheel, partialTicks));
            GlStateManager.func_179121_F();
        }
        if (((EntityPoweredVehicle)((Object)entity)).shouldRenderEngine() && ((EntityPoweredVehicle)((Object)entity)).hasEngine()) {
            this.renderEngine((EntityPoweredVehicle)((Object)entity), properties.getEnginePosition());
        }
        this.renderFuelPort((EntityPoweredVehicle)((Object)entity), properties.getFuelPortPosition());
        this.renderKeyPort((EntityPoweredVehicle)((Object)entity));
        GlStateManager.func_179121_F();
    }

    protected void renderWheel(EntityLandVehicle vehicle, Wheel wheel, float partialTicks) {
        if (!wheel.shouldRender()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)wheel.getOffsetX() * 0.0625 * (double)wheel.getSide().offset), (double)((double)wheel.getOffsetY() * 0.0625), (double)((double)wheel.getOffsetZ() * 0.0625));
        GlStateManager.func_179094_E();
        if (wheel.getPosition() == Wheel.Position.FRONT) {
            float wheelAngle = vehicle.prevRenderWheelAngle + (vehicle.renderWheelAngle - vehicle.prevRenderWheelAngle) * partialTicks;
            GlStateManager.func_179114_b((float)wheelAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (vehicle.isMoving()) {
            GlStateManager.func_179114_b((float)(-wheel.getWheelRotation(vehicle, partialTicks)), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179137_b((double)((double)(wheel.getWidth() * wheel.getScaleX() / 2.0f) * 0.0625 * (double)wheel.getSide().offset), (double)0.0, (double)0.0);
        GlStateManager.func_179152_a((float)wheel.getScaleX(), (float)wheel.getScaleY(), (float)wheel.getScaleZ());
        if (wheel.getSide() == Wheel.Side.RIGHT) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        RenderUtil.renderColoredModel(RenderUtil.getWheelModel(vehicle), ItemCameraTransforms.TransformType.NONE, vehicle.getWheelColor());
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }
}

