/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class QuadHelper {
    private VertexFormat format;
    private TextureAtlasSprite sprite;
    private EnumFacing facing = EnumFacing.EAST;

    public QuadHelper(VertexFormat format, TextureAtlasSprite sprite) {
        this.format = format;
        this.sprite = sprite;
    }

    public List<BakedQuad> createCuboid(Vec3d v1, Vec3d v2) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float width = (float)(v2.field_72450_a - v1.field_72450_a) * 16.0f;
        float height = (float)(v2.field_72448_b - v1.field_72448_b) * 16.0f;
        float depth = (float)(v2.field_72449_c - v1.field_72449_c) * 16.0f;
        quads.add(this.createQuad(new Vertex(v1.field_72450_a, v1.field_72448_b, v2.field_72449_c, 0.0f, 0.0f), new Vertex(v1.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, height), new Vertex(v1.field_72450_a, v2.field_72448_b, v1.field_72449_c, depth, height), new Vertex(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, depth, 0.0f), EnumFacing.WEST));
        quads.add(this.createQuad(new Vertex(v2.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f), new Vertex(v2.field_72450_a, v2.field_72448_b, v1.field_72449_c, 0.0f, height), new Vertex(v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, depth, height), new Vertex(v2.field_72450_a, v1.field_72448_b, v2.field_72449_c, depth, 0.0f), EnumFacing.EAST));
        quads.add(this.createQuad(new Vertex(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f), new Vertex(v1.field_72450_a, v2.field_72448_b, v1.field_72449_c, 0.0f, height), new Vertex(v2.field_72450_a, v2.field_72448_b, v1.field_72449_c, width, height), new Vertex(v2.field_72450_a, v1.field_72448_b, v1.field_72449_c, width, 0.0f), EnumFacing.NORTH));
        quads.add(this.createQuad(new Vertex(v2.field_72450_a, v1.field_72448_b, v2.field_72449_c, 0.0f, 0.0f), new Vertex(v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, height), new Vertex(v1.field_72450_a, v2.field_72448_b, v2.field_72449_c, width, height), new Vertex(v1.field_72450_a, v1.field_72448_b, v2.field_72449_c, width, 0.0f), EnumFacing.SOUTH));
        quads.add(this.createQuad(new Vertex(v1.field_72450_a, v1.field_72448_b, v2.field_72449_c, 0.0f, 0.0f), new Vertex(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, depth), new Vertex(v2.field_72450_a, v1.field_72448_b, v1.field_72449_c, width, depth), new Vertex(v2.field_72450_a, v1.field_72448_b, v2.field_72449_c, width, 0.0f), EnumFacing.DOWN));
        quads.add(this.createQuad(new Vertex(v1.field_72450_a, v2.field_72448_b, v1.field_72449_c, 0.0f, 0.0f), new Vertex(v1.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, depth), new Vertex(v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, width, depth), new Vertex(v2.field_72450_a, v2.field_72448_b, v1.field_72449_c, width, 0.0f), EnumFacing.UP));
        return quads;
    }

    public List<BakedQuad> createAngledCuboid(Vec3d v1, Vec3d v2, double heightOffset) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float width = (float)(v2.field_72450_a - v1.field_72450_a) * 16.0f;
        float height = (float)(v2.field_72448_b - v1.field_72448_b) * 16.0f;
        float depth = (float)(v2.field_72449_c - v1.field_72449_c) * 16.0f;
        quads.add(this.createQuad(new Vertex(v1.field_72450_a, v1.field_72448_b, v2.field_72449_c, 0.0f, 0.0f), new Vertex(v1.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, height), new Vertex(v1.field_72450_a, v2.field_72448_b, v1.field_72449_c, depth, height), new Vertex(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, depth, 0.0f), EnumFacing.WEST));
        quads.add(this.createQuad(new Vertex(v2.field_72450_a, v1.field_72448_b + heightOffset, v1.field_72449_c, 0.0f, 0.0f), new Vertex(v2.field_72450_a, v2.field_72448_b + heightOffset, v1.field_72449_c, 0.0f, height), new Vertex(v2.field_72450_a, v2.field_72448_b + heightOffset, v2.field_72449_c, depth, height), new Vertex(v2.field_72450_a, v1.field_72448_b + heightOffset, v2.field_72449_c, depth, 0.0f), EnumFacing.EAST));
        quads.add(this.createQuad(new Vertex(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f), new Vertex(v1.field_72450_a, v2.field_72448_b, v1.field_72449_c, 0.0f, height), new Vertex(v2.field_72450_a, v2.field_72448_b + heightOffset, v1.field_72449_c, width, height), new Vertex(v2.field_72450_a, v1.field_72448_b + heightOffset, v1.field_72449_c, width, 0.0f), EnumFacing.NORTH));
        quads.add(this.createQuad(new Vertex(v2.field_72450_a, v1.field_72448_b + heightOffset, v2.field_72449_c, 0.0f, 0.0f), new Vertex(v2.field_72450_a, v2.field_72448_b + heightOffset, v2.field_72449_c, 0.0f, height), new Vertex(v1.field_72450_a, v2.field_72448_b, v2.field_72449_c, width, height), new Vertex(v1.field_72450_a, v1.field_72448_b, v2.field_72449_c, width, 0.0f), EnumFacing.SOUTH));
        quads.add(this.createQuad(new Vertex(v1.field_72450_a, v1.field_72448_b, v2.field_72449_c, 0.0f, 0.0f), new Vertex(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, depth), new Vertex(v2.field_72450_a, v1.field_72448_b + heightOffset, v1.field_72449_c, width, depth), new Vertex(v2.field_72450_a, v1.field_72448_b + heightOffset, v2.field_72449_c, width, 0.0f), EnumFacing.DOWN));
        quads.add(this.createQuad(new Vertex(v1.field_72450_a, v2.field_72448_b, v1.field_72449_c, 0.0f, 0.0f), new Vertex(v1.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, depth), new Vertex(v2.field_72450_a, v2.field_72448_b + heightOffset, v2.field_72449_c, width, depth), new Vertex(v2.field_72450_a, v2.field_72448_b + heightOffset, v1.field_72449_c, width, 0.0f), EnumFacing.UP));
        return quads;
    }

    public BakedQuad createQuad(Vertex v1, Vertex v2, Vertex v3, Vertex v4, EnumFacing face) {
        v1 = QuadHelper.rotate(v1, this.facing);
        v2 = QuadHelper.rotate(v2, this.facing);
        v3 = QuadHelper.rotate(v3, this.facing);
        v4 = QuadHelper.rotate(v4, this.facing);
        face = this.rotateFacing(face);
        Vec3d normal = v1.getVec3d().func_178788_d(v2.getVec3d()).func_72431_c(v3.getVec3d().func_178788_d(v2.getVec3d()));
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(this.sprite);
        builder.setQuadOrientation(face);
        this.putVertex(builder, face, normal, v1.x, v1.y, v1.z, v1.u, v1.v);
        this.putVertex(builder, face, normal, v2.x, v2.y, v2.z, v2.u, v2.v);
        this.putVertex(builder, face, normal, v3.x, v3.y, v3.z, v3.u, v3.v);
        this.putVertex(builder, face, normal, v4.x, v4.y, v4.z, v4.u, v4.v);
        return builder.build();
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, EnumFacing side, Vec3d normal, double x, double y, double z, float u, float v) {
        block6: for (int i = 0; i < this.format.func_177345_h(); ++i) {
            switch (this.format.func_177348_c(i).func_177375_c()) {
                case POSITION: {
                    builder.put(i, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(i, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(i).func_177369_e() == 0) {
                        u = this.sprite.func_94214_a((double)u);
                        v = this.sprite.func_94207_b((double)v);
                        builder.put(i, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(i, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(i, new float[0]);
                }
            }
        }
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public void setFacing(EnumFacing facing) {
        if (facing == null) {
            return;
        }
        this.facing = facing;
    }

    public static Vertex rotate(Vertex v, EnumFacing facing) {
        switch (facing) {
            case WEST: {
                v.x = 1.0 - v.x;
                v.z = 1.0 - v.z;
                break;
            }
            case NORTH: {
                double temp_1 = v.x = 1.0 - v.x;
                v.x = v.z;
                v.z = temp_1;
                break;
            }
            case SOUTH: {
                double temp_2 = v.z = 1.0 - v.z;
                v.z = v.x;
                v.x = temp_2;
                break;
            }
        }
        return v;
    }

    public EnumFacing rotateFacing(EnumFacing side) {
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            return side;
        }
        switch (this.facing) {
            case NORTH: {
                return side.func_176735_f();
            }
            case WEST: {
                return side.func_176734_d();
            }
            case SOUTH: {
                return side.func_176746_e();
            }
        }
        return side;
    }

    public static class Vertex {
        public double x;
        public double y;
        public double z;
        public float u;
        public float v;

        public Vertex(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vertex(double x, double y, double z, float u, float v) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
        }

        public Vec3d getVec3d() {
            return new Vec3d(this.x, this.y, this.z);
        }
    }
}

