/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.block.BlockVehicleCrate;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.Wheel;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.common.container.ContainerVehicle;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.common.entity.SyncedPlayerData;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.EntityJack;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.WheelType;
import com.mrcrayfish.vehicle.entity.vehicle.EntityBumperCar;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.item.ItemEngine;
import com.mrcrayfish.vehicle.item.ItemJerryCan;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAccelerating;
import com.mrcrayfish.vehicle.network.message.MessageHorn;
import com.mrcrayfish.vehicle.network.message.MessagePower;
import com.mrcrayfish.vehicle.network.message.MessageTurnAngle;
import com.mrcrayfish.vehicle.network.message.MessageTurnDirection;
import com.mrcrayfish.vehicle.network.message.MessageVehicleWindow;
import com.mrcrayfish.vehicle.tileentity.TileEntityGasPump;
import com.mrcrayfish.vehicle.tileentity.TileEntityGasPumpTank;
import com.mrcrayfish.vehicle.util.CommonUtils;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityPoweredVehicle
extends EntityVehicle
implements IInventoryChangedListener {
    protected static final DataParameter<Float> CURRENT_SPEED = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> MAX_SPEED = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> ACCELERATION_SPEED = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> POWER = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> TURN_DIRECTION = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> TARGET_TURN_ANGLE = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> TURN_SENSITIVITY = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> MAX_TURN_ANGLE = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> ACCELERATION_DIRECTION = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> HAS_ENGINE = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> ENGINE_TIER = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> HORN = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> REQUIRES_FUEL = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> CURRENT_FUEL = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> FUEL_CAPACITY = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> NEEDS_KEY = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<ItemStack> KEY_STACK = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187196_f);
    protected static final DataParameter<Boolean> HAS_WHEELS = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> WHEEL_TYPE = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> WHEEL_COLOR = EntityDataManager.func_187226_a(EntityPoweredVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    public float prevCurrentSpeed;
    public float currentSpeed;
    public float speedMultiplier;
    public boolean boosting;
    public int boostTimer;
    public boolean launching;
    public int launchingTimer;
    public boolean disableFallDamage;
    public float fuelConsumption = 0.25f;
    protected double[] wheelPositions;
    protected boolean wheelsOnGround = true;
    public float turnAngle;
    public float prevTurnAngle;
    public float deltaYaw;
    public float wheelAngle;
    public float prevWheelAngle;
    @SideOnly(value=Side.CLIENT)
    public float targetWheelAngle;
    @SideOnly(value=Side.CLIENT)
    public float renderWheelAngle;
    @SideOnly(value=Side.CLIENT)
    public float prevRenderWheelAngle;
    public float vehicleMotionX;
    public float vehicleMotionY;
    public float vehicleMotionZ;
    private UUID owner;
    private InventoryBasic vehicleInventory;
    private FuelPort fuelPort = FuelPort.LID;
    private boolean fueling;

    protected EntityPoweredVehicle(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70138_W = 1.0f;
    }

    public EntityPoweredVehicle(World worldIn, double posX, double posY, double posZ) {
        this(worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CURRENT_SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(MAX_SPEED, (Object)Float.valueOf(10.0f));
        this.field_70180_af.func_187214_a(ACCELERATION_SPEED, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(POWER, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(TURN_DIRECTION, (Object)TurnDirection.FORWARD.ordinal());
        this.field_70180_af.func_187214_a(TARGET_TURN_ANGLE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TURN_SENSITIVITY, (Object)6);
        this.field_70180_af.func_187214_a(MAX_TURN_ANGLE, (Object)45);
        this.field_70180_af.func_187214_a(ACCELERATION_DIRECTION, (Object)AccelerationDirection.NONE.ordinal());
        this.field_70180_af.func_187214_a(HAS_ENGINE, (Object)false);
        this.field_70180_af.func_187214_a(ENGINE_TIER, (Object)0);
        this.field_70180_af.func_187214_a(HORN, (Object)false);
        this.field_70180_af.func_187214_a(REQUIRES_FUEL, (Object)VehicleConfig.SERVER.fuelEnabled);
        this.field_70180_af.func_187214_a(CURRENT_FUEL, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FUEL_CAPACITY, (Object)Float.valueOf(15000.0f));
        this.field_70180_af.func_187214_a(NEEDS_KEY, (Object)false);
        this.field_70180_af.func_187214_a(KEY_STACK, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(HAS_WHEELS, (Object)true);
        this.field_70180_af.func_187214_a(WHEEL_TYPE, (Object)WheelType.STANDARD.ordinal());
        this.field_70180_af.func_187214_a(WHEEL_COLOR, (Object)-1);
        List<Wheel> wheels = this.getProperties().getWheels();
        if (wheels != null && wheels.size() > 0) {
            this.wheelPositions = new double[wheels.size() * 3];
        }
    }

    public abstract SoundEvent getMovingSound();

    public abstract SoundEvent getRidingSound();

    public SoundEvent getHornSound() {
        return ModSounds.HORN_MONO;
    }

    public SoundEvent getHornRidingSound() {
        return ModSounds.HORN_STEREO;
    }

    public void playFuelPortOpenSound() {
        if (!this.fueling) {
            this.fuelPort.playOpenSound();
            this.fueling = true;
        }
    }

    public void playFuelPortCloseSound() {
        if (this.fueling) {
            this.fuelPort.playCloseSound();
            this.fueling = false;
        }
    }

    public float getMinEnginePitch() {
        return 0.5f;
    }

    public float getMaxEnginePitch() {
        return 1.2f;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void setFuelPort(FuelPort fuelPort) {
        this.fuelPort = fuelPort;
    }

    public void fuelVehicle(EntityPlayer player, EnumHand hand) {
        if (SyncedPlayerData.getGasPumpPos(player).isPresent()) {
            TileEntityGasPumpTank gasPumpTank;
            FluidStack stack;
            BlockPos pos = (BlockPos)SyncedPlayerData.getGasPumpPos(player).get();
            TileEntity tileEntity = this.field_70170_p.func_175625_s(pos);
            if (tileEntity instanceof TileEntityGasPump && (tileEntity = this.field_70170_p.func_175625_s(pos.func_177977_b())) instanceof TileEntityGasPumpTank && (stack = (gasPumpTank = (TileEntityGasPumpTank)tileEntity).getFluidTank().drain(200, true)) != null) {
                stack.amount = this.addFuel(stack.amount);
                if (stack.amount > 0) {
                    gasPumpTank.getFluidTank().fill(stack, true);
                }
            }
            return;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemJerryCan) {
            ItemJerryCan jerryCan = (ItemJerryCan)stack.func_77973_b();
            int rate = jerryCan.getFillRate(stack);
            int drained = jerryCan.drain(stack, rate);
            int remaining = this.addFuel(drained);
            jerryCan.fill(stack, remaining);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.field_70170_p.field_72995_K) return super.func_184230_a(player, hand);
        if (this.owner == null) {
            this.owner = player.func_110124_au();
        }
        if (stack.func_77973_b() == ModItems.KEY) {
            if (!this.owner.equals(player.func_110124_au())) {
                CommonUtils.sendInfoMessage(player, "vehicle.status.invalid_owner");
                return false;
            }
            if (this.isLockable()) {
                NBTTagCompound tag = CommonUtils.getItemTagCompound(stack);
                if (tag.func_186855_b("vehicleId") && !this.func_110124_au().equals(tag.func_186857_a("vehicleId"))) return super.func_184230_a(player, hand);
                tag.func_186854_a("vehicleId", this.func_110124_au());
                if (!this.isKeyNeeded()) {
                    this.setKeyNeeded(true);
                    CommonUtils.sendInfoMessage(player, "vehicle.status.key_added");
                    return true;
                } else {
                    CommonUtils.sendInfoMessage(player, "vehicle.status.key_created");
                }
                return true;
            }
            CommonUtils.sendInfoMessage(player, "vehicle.status.not_lockable");
            return false;
        }
        if (stack.func_77973_b() != ModItems.WRENCH || !(this.func_184187_bx() instanceof EntityJack)) return super.func_184230_a(player, hand);
        if (player.func_110124_au().equals(this.owner)) {
            this.openInventory(player);
            return true;
        } else {
            CommonUtils.sendInfoMessage(player, "vehicle.status.invalid_owner");
        }
        return true;
    }

    @Override
    public void onUpdateVehicle() {
        Entity controllingPassenger;
        this.prevCurrentSpeed = this.currentSpeed;
        this.prevTurnAngle = this.turnAngle;
        this.prevWheelAngle = this.wheelAngle;
        if (this.field_70170_p.field_72995_K) {
            this.onClientUpdate();
        }
        if ((controllingPassenger = this.func_184179_bs()) != null) {
            this.createParticles();
        }
        this.updateGroundState();
        this.updateSpeed();
        this.updateTurning();
        this.updateVehicle();
        this.setSpeed(this.currentSpeed);
        VehicleProperties properties = this.getProperties();
        if (properties.getFrontAxelVec() == null || properties.getRearAxelVec() == null) {
            this.field_70177_z -= this.deltaYaw;
        }
        this.updateVehicleMotion();
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        double deltaRot = this.field_70126_B - this.field_70177_z;
        if (deltaRot < -180.0) {
            this.field_70126_B += 360.0f;
        } else if (deltaRot >= 180.0) {
            this.field_70126_B -= 360.0f;
        }
        this.updateWheelPositions();
        this.func_70091_d(MoverType.SELF, this.field_70159_w + (double)this.vehicleMotionX, this.field_70181_x + (double)this.vehicleMotionY, this.field_70179_y + (double)this.vehicleMotionZ);
        if (this.field_70122_E) {
            this.field_70159_w *= 0.65;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.65;
        } else {
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
        }
        if (this.boostTimer > 0) {
            --this.boostTimer;
        } else {
            this.boosting = false;
            this.speedMultiplier = (float)((double)this.speedMultiplier * 0.85);
        }
        if (this.launchingTimer > 0) {
            this.disableFallDamage = true;
            --this.launchingTimer;
        } else {
            this.launching = false;
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), entity -> entity instanceof EntityBumperCar);
        if (!list.isEmpty()) {
            for (Entity entity2 : list) {
                this.func_70108_f(entity2);
            }
        }
        if (this.requiresFuel() && controllingPassenger instanceof EntityPlayer && !((EntityPlayer)controllingPassenger).func_184812_l_() && this.isEnginePowered()) {
            float currentSpeed = Math.abs(Math.min(this.getSpeed(), this.getMaxSpeed()));
            float normalSpeed = Math.max(0.05f, currentSpeed / this.getMaxSpeed());
            float currentFuel = this.getCurrentFuel();
            if ((currentFuel = (float)((double)currentFuel - (double)(this.fuelConsumption * normalSpeed) * VehicleConfig.SERVER.fuelConsumptionFactor)) < 0.0f) {
                currentFuel = 0.0f;
            }
            this.setCurrentFuel(currentFuel);
        }
    }

    public void updateVehicle() {
    }

    public abstract void updateVehicleMotion();

    public abstract EngineType getEngineType();

    protected void updateSpeed() {
        float wheelModifier = this.getWheelModifier();
        this.currentSpeed = this.getSpeed();
        EngineTier engineTier = this.getEngineTier();
        AccelerationDirection acceleration = this.getAcceleration();
        if (this.func_184179_bs() != null) {
            if (this.canDrive()) {
                if (acceleration == AccelerationDirection.FORWARD) {
                    if (this.wheelsOnGround || this.canAccelerateInAir()) {
                        float maxSpeed = this.getActualMaxSpeed() * wheelModifier * this.getPower();
                        if (this.currentSpeed < maxSpeed) {
                            this.currentSpeed += this.getModifiedAccelerationSpeed() * engineTier.getAccelerationMultiplier();
                            if (this.currentSpeed > maxSpeed) {
                                this.currentSpeed = maxSpeed;
                            }
                        }
                        if (this.currentSpeed > maxSpeed) {
                            this.currentSpeed *= 0.975f;
                        }
                        return;
                    }
                } else if (acceleration == AccelerationDirection.REVERSE && (this.wheelsOnGround || this.canAccelerateInAir())) {
                    float maxSpeed = -(4.0f + engineTier.getAdditionalMaxSpeed() / 2.0f) * wheelModifier * this.getPower();
                    if (this.currentSpeed > maxSpeed) {
                        this.currentSpeed -= this.getModifiedAccelerationSpeed() * engineTier.getAccelerationMultiplier();
                        if (this.currentSpeed < maxSpeed) {
                            this.currentSpeed = maxSpeed;
                        }
                    }
                    if (this.currentSpeed < maxSpeed) {
                        this.currentSpeed *= 0.975f;
                    }
                    return;
                }
            }
            this.currentSpeed = this.wheelsOnGround || this.canAccelerateInAir() ? (float)((double)this.currentSpeed * 0.9) : (float)((double)this.currentSpeed * 0.98);
        } else {
            this.currentSpeed = this.wheelsOnGround ? (float)((double)this.currentSpeed * 0.85) : (float)((double)this.currentSpeed * 0.98);
        }
    }

    protected void updateTurning() {
        this.turnAngle = this.getTargetTurnAngle();
        this.wheelAngle = this.turnAngle * Math.max(0.25f, 1.0f - Math.abs(this.currentSpeed / 30.0f));
        this.deltaYaw = this.wheelAngle * (this.currentSpeed / 30.0f) / 2.0f;
        if (this.field_70170_p.field_72995_K) {
            this.renderWheelAngle = this.wheelAngle;
        }
    }

    public void createParticles() {
        VehicleProperties properties;
        if (this.getAcceleration() == AccelerationDirection.FORWARD && (properties = this.getProperties()).getWheels() != null) {
            List<Wheel> wheels = properties.getWheels();
            for (int i = 0; i < wheels.size(); ++i) {
                int z;
                int y;
                Wheel wheel = wheels.get(i);
                if (!wheel.shouldSpawnParticles()) continue;
                double wheelX = this.wheelPositions[i * 3];
                double wheelY = this.wheelPositions[i * 3 + 1];
                double wheelZ = this.wheelPositions[i * 3 + 2];
                int x = MathHelper.func_76128_c((double)(this.field_70165_t + wheelX));
                BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.field_70163_u + wheelY - 0.2)), z = MathHelper.func_76128_c((double)(this.field_70161_v + wheelZ)));
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                if (state.func_185904_a() == Material.field_151579_a || !state.func_185904_a().func_76229_l()) continue;
                Vec3d dirVec = this.func_174806_f(this.field_70125_A, this.getModifiedRotationYaw() + 180.0f);
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + wheelX, this.field_70163_u + wheelY, this.field_70161_v + wheelZ, dirVec.field_72450_a, dirVec.field_72448_b, dirVec.field_72449_c, new int[]{Block.func_176210_f((IBlockState)state)});
            }
        }
        if (this.shouldShowEngineSmoke() && this.canDrive() && this.field_70173_aa % 2 == 0) {
            Vec3d smokePosition = this.getEngineSmokePosition().func_178785_b(-this.getModifiedRotationYaw() * ((float)Math.PI / 180));
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + smokePosition.field_72450_a, this.field_70163_u + smokePosition.field_72448_b, this.field_70161_v + smokePosition.field_72449_c, -this.field_70159_w, 0.0, -this.field_70179_y, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientUpdate() {
        this.prevRenderWheelAngle = this.renderWheelAngle;
        EntityLivingBase entity = (EntityLivingBase)this.func_184179_bs();
        if (entity != null && entity.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            float power = VehicleMod.proxy.getPower(this);
            if (power != this.getPower()) {
                this.setPower(power);
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessagePower(power));
            }
            AccelerationDirection acceleration = VehicleMod.proxy.getAccelerationDirection(entity);
            if (this.getAcceleration() != acceleration) {
                this.setAcceleration(acceleration);
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageAccelerating(acceleration));
            }
            boolean horn = VehicleMod.proxy.isHonking();
            this.setHorn(horn);
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageHorn(horn));
            TurnDirection direction = VehicleMod.proxy.getTurnDirection(entity);
            if (this.getTurnDirection() != direction) {
                this.setTurnDirection(direction);
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageTurnDirection(direction));
            }
            float targetTurnAngle = VehicleMod.proxy.getTargetTurnAngle(this, false);
            this.setTargetTurnAngle(targetTurnAngle);
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageTurnAngle(targetTurnAngle));
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("owner", 10)) {
            this.owner = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("owner"));
        }
        if (compound.func_150297_b("hasEngine", 1)) {
            this.setEngine(compound.func_74767_n("hasEngine"));
        }
        if (compound.func_150297_b("engineType", 3)) {
            this.setEngine(true);
            this.setEngineTier(EngineTier.getType(compound.func_74762_e("engineTier")));
        }
        if (compound.func_150297_b("engineTier", 3)) {
            this.setEngineTier(EngineTier.getType(compound.func_74762_e("engineTier")));
        }
        if (compound.func_150297_b("hasWheels", 1)) {
            this.setWheels(compound.func_74767_n("hasWheels"));
        }
        if (compound.func_150297_b("wheelType", 3)) {
            this.setWheelType(WheelType.getType(compound.func_74762_e("wheelType")));
        }
        if (compound.func_150297_b("wheelColor", 3)) {
            this.setWheelColor(compound.func_74762_e("wheelColor"));
        }
        if (compound.func_150297_b("maxSpeed", 5)) {
            this.setMaxSpeed(compound.func_74760_g("maxSpeed"));
        }
        if (compound.func_150297_b("accelerationSpeed", 5)) {
            this.setAccelerationSpeed(compound.func_74760_g("accelerationSpeed"));
        }
        if (compound.func_150297_b("turnSensitivity", 3)) {
            this.setTurnSensitivity(compound.func_74762_e("turnSensitivity"));
        }
        if (compound.func_150297_b("maxTurnAngle", 3)) {
            this.setMaxTurnAngle(compound.func_74762_e("maxTurnAngle"));
        }
        if (compound.func_150297_b("stepHeight", 5)) {
            this.field_70138_W = compound.func_74760_g("stepHeight");
        }
        if (compound.func_150297_b("requiresFuel", 1)) {
            this.setRequiresFuel(compound.func_74767_n("requiresFuel"));
        }
        if (compound.func_150297_b("currentFuel", 5)) {
            this.setCurrentFuel(compound.func_74760_g("currentFuel"));
        }
        if (compound.func_150297_b("fuelCapacity", 3)) {
            this.setFuelCapacity(compound.func_74762_e("fuelCapacity"));
        }
        if (compound.func_150297_b("keyNeeded", 1)) {
            this.setKeyNeeded(compound.func_74767_n("keyNeeded"));
        }
        this.setKeyStack(CommonUtils.readItemStackFromTag(compound, "keyStack"));
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.owner != null) {
            compound.func_74782_a("owner", (NBTBase)NBTUtil.func_186862_a((UUID)this.owner));
        }
        compound.func_74757_a("hasEngine", this.hasEngine());
        compound.func_74768_a("engineTier", this.getEngineTier().ordinal());
        compound.func_74757_a("hasWheels", this.hasWheels());
        compound.func_74768_a("wheelType", this.getWheelType().ordinal());
        compound.func_74768_a("wheelColor", this.getWheelColor());
        compound.func_74776_a("maxSpeed", this.getMaxSpeed());
        compound.func_74776_a("accelerationSpeed", this.getAccelerationSpeed());
        compound.func_74768_a("turnSensitivity", this.getTurnSensitivity());
        compound.func_74768_a("maxTurnAngle", this.getMaxTurnAngle());
        compound.func_74776_a("stepHeight", this.field_70138_W);
        compound.func_74757_a("requiresFuel", this.requiresFuel());
        compound.func_74776_a("currentFuel", this.getCurrentFuel());
        compound.func_74776_a("fuelCapacity", this.getFuelCapacity());
        compound.func_74757_a("keyNeeded", this.isKeyNeeded());
        CommonUtils.writeItemStackToTag(compound, "keyStack", this.getKeyStack());
    }

    @Nullable
    public Entity func_184179_bs() {
        if (this.func_184188_bt().isEmpty()) {
            return null;
        }
        VehicleProperties properties = this.getProperties();
        for (Entity passenger : this.func_184188_bt()) {
            int seatIndex = this.getSeatTracker().getSeatIndex(passenger.func_110124_au());
            if (seatIndex == -1 || !properties.getSeats().get(seatIndex).isDriverSeat()) continue;
            return passenger;
        }
        return null;
    }

    @Override
    public void updatePassengerPosition(Entity passenger) {
        int seatIndex;
        if (this.func_184196_w(passenger) && (seatIndex = this.getSeatTracker().getSeatIndex(passenger.func_110124_au())) != -1) {
            VehicleProperties properties = this.getProperties();
            if (seatIndex >= 0 && seatIndex < properties.getSeats().size()) {
                Seat seat = properties.getSeats().get(seatIndex);
                Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale());
                seatVec = new Vec3d(-seatVec.field_72450_a, seatVec.field_72448_b, seatVec.field_72449_c);
                seatVec = seatVec.func_186678_a(0.0625).func_178785_b(-(this.getModifiedRotationYaw() + 180.0f) * ((float)Math.PI / 180));
                passenger.func_70107_b(this.field_70165_t - seatVec.field_72450_a, this.field_70163_u + seatVec.field_72448_b + passenger.func_70033_W(), this.field_70161_v - seatVec.field_72449_c);
                passenger.field_70177_z -= this.deltaYaw;
                passenger.func_70034_d(passenger.field_70177_z);
                this.applyYawToEntity(passenger);
            }
        }
    }

    public boolean isMoving() {
        return this.currentSpeed != 0.0f;
    }

    public void setMaxSpeed(float maxSpeed) {
        this.field_70180_af.func_187227_b(MAX_SPEED, (Object)Float.valueOf(maxSpeed));
    }

    public float getMaxSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_SPEED)).floatValue();
    }

    public float getActualMaxSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_SPEED)).floatValue() + this.getEngineTier().getAdditionalMaxSpeed();
    }

    public void setSpeed(float speed) {
        this.field_70180_af.func_187227_b(CURRENT_SPEED, (Object)Float.valueOf(speed));
    }

    public float getSpeed() {
        return this.currentSpeed;
    }

    public float getNormalSpeed() {
        return this.currentSpeed / this.getMaxSpeed();
    }

    public float getActualSpeed() {
        return (this.currentSpeed + this.currentSpeed * this.speedMultiplier) / this.getActualMaxSpeed();
    }

    public void setAccelerationSpeed(float speed) {
        this.field_70180_af.func_187227_b(ACCELERATION_SPEED, (Object)Float.valueOf(speed));
    }

    public float getAccelerationSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(ACCELERATION_SPEED)).floatValue();
    }

    protected float getModifiedAccelerationSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(ACCELERATION_SPEED)).floatValue();
    }

    public double getKilometersPreHour() {
        return Math.sqrt(Math.pow(this.field_70165_t - this.field_70169_q, 2.0) + Math.pow(this.field_70163_u - this.field_70167_r, 2.0) + Math.pow(this.field_70161_v - this.field_70166_s, 2.0)) * 20.0;
    }

    public void setTurnDirection(TurnDirection turnDirection) {
        this.field_70180_af.func_187227_b(TURN_DIRECTION, (Object)turnDirection.ordinal());
    }

    public TurnDirection getTurnDirection() {
        return TurnDirection.values()[(Integer)this.field_70180_af.func_187225_a(TURN_DIRECTION)];
    }

    public void setTargetTurnAngle(float targetTurnAngle) {
        this.field_70180_af.func_187227_b(TARGET_TURN_ANGLE, (Object)Float.valueOf(targetTurnAngle));
    }

    public float getTargetTurnAngle() {
        return ((Float)this.field_70180_af.func_187225_a(TARGET_TURN_ANGLE)).floatValue();
    }

    public void setAcceleration(AccelerationDirection direction) {
        this.field_70180_af.func_187227_b(ACCELERATION_DIRECTION, (Object)direction.ordinal());
    }

    public AccelerationDirection getAcceleration() {
        return AccelerationDirection.values()[(Integer)this.field_70180_af.func_187225_a(ACCELERATION_DIRECTION)];
    }

    public void setPower(float power) {
        this.field_70180_af.func_187227_b(POWER, (Object)Float.valueOf(power));
    }

    public float getPower() {
        return ((Float)this.field_70180_af.func_187225_a(POWER)).floatValue();
    }

    public void setTurnSensitivity(int sensitivity) {
        this.field_70180_af.func_187227_b(TURN_SENSITIVITY, (Object)sensitivity);
    }

    public int getTurnSensitivity() {
        return (Integer)this.field_70180_af.func_187225_a(TURN_SENSITIVITY);
    }

    public void setMaxTurnAngle(int turnAngle) {
        this.field_70180_af.func_187227_b(MAX_TURN_ANGLE, (Object)turnAngle);
    }

    public int getMaxTurnAngle() {
        return (Integer)this.field_70180_af.func_187225_a(MAX_TURN_ANGLE);
    }

    public boolean hasEngine() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_ENGINE);
    }

    public void setEngine(boolean hasEngine) {
        this.field_70180_af.func_187227_b(HAS_ENGINE, (Object)hasEngine);
    }

    public void setEngineTier(EngineTier engineTier) {
        this.field_70180_af.func_187227_b(ENGINE_TIER, (Object)engineTier.ordinal());
    }

    public EngineTier getEngineTier() {
        return EngineTier.getType((Integer)this.field_70180_af.func_187225_a(ENGINE_TIER));
    }

    public ItemStack getEngineStack() {
        if (this.hasEngine()) {
            switch (this.getEngineType()) {
                case SMALL_MOTOR: {
                    return new ItemStack(ModItems.SMALL_ENGINE, 1, this.getEngineTier().ordinal());
                }
                case LARGE_MOTOR: {
                    return new ItemStack(ModItems.LARGE_ENGINE, 1, this.getEngineTier().ordinal());
                }
                case ELECTRIC_MOTOR: {
                    return new ItemStack(ModItems.ELECTRIC_ENGINE, 1, this.getEngineTier().ordinal());
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderEngine() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderFuelPort() {
        return true;
    }

    public Vec3d getEngineSmokePosition() {
        return new Vec3d(0.0, 0.0, 0.0);
    }

    public boolean shouldShowEngineSmoke() {
        return false;
    }

    public void setHorn(boolean activated) {
        this.field_70180_af.func_187227_b(HORN, (Object)activated);
    }

    public boolean getHorn() {
        return (Boolean)this.field_70180_af.func_187225_a(HORN);
    }

    public void setBoosting(boolean boosting) {
        this.boosting = boosting;
        this.boostTimer = 10;
    }

    public boolean isBoosting() {
        return this.boosting;
    }

    public void setLaunching(int hold) {
        this.launching = true;
        this.launchingTimer = hold;
        this.disableFallDamage = true;
    }

    public boolean isLaunching() {
        return this.launching;
    }

    public boolean requiresFuel() {
        return VehicleConfig.SERVER.fuelEnabled && (Boolean)this.field_70180_af.func_187225_a(REQUIRES_FUEL) != false;
    }

    public void setRequiresFuel(boolean requiresFuel) {
        this.field_70180_af.func_187227_b(REQUIRES_FUEL, (Object)(VehicleConfig.SERVER.fuelEnabled && requiresFuel ? 1 : 0));
    }

    public boolean isFueled() {
        return !this.requiresFuel() || this.isControllingPassengerCreative() || this.getCurrentFuel() > 0.0f;
    }

    public void setCurrentFuel(float fuel) {
        this.field_70180_af.func_187227_b(CURRENT_FUEL, (Object)Float.valueOf(fuel));
    }

    public float getCurrentFuel() {
        return ((Float)this.field_70180_af.func_187225_a(CURRENT_FUEL)).floatValue();
    }

    public void setFuelCapacity(float capacity) {
        this.field_70180_af.func_187227_b(FUEL_CAPACITY, (Object)Float.valueOf(capacity));
    }

    public float getFuelCapacity() {
        return ((Float)this.field_70180_af.func_187225_a(FUEL_CAPACITY)).floatValue();
    }

    public void setFuelConsumption(float consumption) {
        this.fuelConsumption = consumption;
    }

    public float getFuelConsumption() {
        return this.fuelConsumption;
    }

    public int addFuel(int fuel) {
        if (!this.requiresFuel()) {
            return fuel;
        }
        float currentFuel = this.getCurrentFuel();
        int remaining = Math.max(0, Math.round((currentFuel += (float)fuel) - this.getFuelCapacity()));
        currentFuel = Math.min(currentFuel, this.getFuelCapacity());
        this.setCurrentFuel(currentFuel);
        return remaining;
    }

    public void setKeyNeeded(boolean needsKey) {
        this.field_70180_af.func_187227_b(NEEDS_KEY, (Object)needsKey);
    }

    public boolean isKeyNeeded() {
        return (Boolean)this.field_70180_af.func_187225_a(NEEDS_KEY);
    }

    public void setKeyStack(ItemStack stack) {
        this.field_70180_af.func_187227_b(KEY_STACK, (Object)stack);
    }

    public ItemStack getKeyStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(KEY_STACK);
    }

    public void ejectKey() {
        if (!this.getKeyStack().func_190926_b()) {
            Vec3d keyHole = this.getPartPositionAbsoluteVec(this.getProperties().getKeyPortPosition(), 1.0f);
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, keyHole.field_72450_a, keyHole.field_72448_b, keyHole.field_72449_c, this.getKeyStack()));
            this.setKeyStack(ItemStack.field_190927_a);
        }
    }

    public boolean isLockable() {
        return true;
    }

    public boolean isEnginePowered() {
        return !(this.getEngineType() != EngineType.NONE && !this.hasEngine() || !this.isControllingPassengerCreative() && !this.isFueled() || this.getDestroyedStage() >= 9 || this.isKeyNeeded() && this.getKeyStack().func_190926_b());
    }

    public boolean canDrive() {
        return (!this.canChangeWheels() || this.hasWheels()) && this.isEnginePowered();
    }

    public boolean isOwner(EntityPlayer player) {
        return this.owner == null || player.func_110124_au().equals(this.owner);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public boolean hasWheels() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_WHEELS);
    }

    public void setWheels(boolean hasWheels) {
        this.field_70180_af.func_187227_b(HAS_WHEELS, (Object)hasWheels);
    }

    public void setWheelType(WheelType wheelType) {
        this.field_70180_af.func_187227_b(WHEEL_TYPE, (Object)wheelType.ordinal());
    }

    public WheelType getWheelType() {
        return WheelType.values()[(Integer)this.field_70180_af.func_187225_a(WHEEL_TYPE)];
    }

    public ItemStack getWheelStack() {
        if (this.hasWheels()) {
            ItemStack stack = new ItemStack(ModItems.WHEEL, 1, this.getWheelType().ordinal());
            if (this.getWheelColor() != -1) {
                CommonUtils.getItemTagCompound(stack).func_74768_a("color", this.getWheelColor());
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void setWheelColor(int color) {
        this.field_70180_af.func_187227_b(WHEEL_COLOR, (Object)color);
    }

    public int getWheelColor() {
        return (Integer)this.field_70180_af.func_187225_a(WHEEL_COLOR);
    }

    @Override
    public void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (passenger instanceof EntityPlayer && this.field_70170_p.field_72995_K) {
            VehicleMod.proxy.playVehicleSound((EntityPlayer)passenger, this);
        }
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.disableFallDamage) {
            super.func_180430_e(distance, damageMultiplier);
        }
        if (this.launchingTimer <= 0 && distance > 3.0f) {
            this.disableFallDamage = false;
        }
    }

    public boolean isControllingPassengerCreative() {
        Entity entity = this.func_184179_bs();
        if (entity instanceof EntityPlayer) {
            return ((EntityPlayer)entity).func_184812_l_();
        }
        return false;
    }

    private void openInventory(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
            entityPlayerMP.func_71117_bO();
            entityPlayerMP.field_71070_bA = new ContainerVehicle((IInventory)this.getVehicleInventory(), this, (EntityPlayer)entityPlayerMP);
            entityPlayerMP.field_71070_bA.field_75152_c = entityPlayerMP.field_71139_cq;
            entityPlayerMP.field_71070_bA.func_75132_a((IContainerListener)entityPlayerMP);
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageVehicleWindow(player.field_71070_bA.field_75152_c, this.func_145782_y()), entityPlayerMP);
        }
    }

    public InventoryBasic getVehicleInventory() {
        if (this.vehicleInventory == null) {
            this.initVehicleInventory();
        }
        return this.vehicleInventory;
    }

    protected void initVehicleInventory() {
        this.vehicleInventory = new InventoryBasic(this.func_70005_c_(), false, 2);
        ItemStack engine = this.getEngineStack();
        if (this.getEngineType() != EngineType.NONE & !engine.func_190926_b()) {
            this.vehicleInventory.func_70299_a(0, engine);
        }
        ItemStack wheel = this.getWheelStack();
        if (this.canChangeWheels() && !wheel.func_190926_b()) {
            this.vehicleInventory.func_70299_a(1, wheel);
        }
        this.vehicleInventory.func_110134_a((IInventoryChangedListener)this);
    }

    private void updateSlots() {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack engine = this.vehicleInventory.func_70301_a(0);
            if (engine.func_77973_b() instanceof ItemEngine) {
                ItemEngine item = (ItemEngine)engine.func_77973_b();
                if (item.getEngineType() == this.getEngineType()) {
                    this.setEngine(true);
                    this.setEngineTier(EngineTier.getType(engine.func_77960_j()));
                } else {
                    this.setEngine(false);
                }
            } else if (this.getEngineType() != EngineType.NONE) {
                this.setEngine(false);
            }
            ItemStack wheel = this.vehicleInventory.func_70301_a(1);
            if (this.canChangeWheels()) {
                if (wheel.func_77973_b() == ModItems.WHEEL) {
                    if (!this.hasWheels()) {
                        this.field_70170_p.func_184133_a(null, this.func_180425_c(), ModSounds.AIR_WRENCH_GUN, SoundCategory.BLOCKS, 1.0f, 1.1f);
                        this.setWheels(true);
                        this.setWheelType(WheelType.values()[wheel.func_77960_j()]);
                        NBTTagCompound tagCompound = CommonUtils.getItemTagCompound(wheel);
                        if (tagCompound.func_150297_b("color", 3)) {
                            this.setWheelColor(tagCompound.func_74762_e("color"));
                        } else {
                            this.setWheelColor(-1);
                        }
                    }
                } else {
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.AIR_WRENCH_GUN, SoundCategory.BLOCKS, 1.0f, 0.8f);
                    this.setWheels(false);
                    this.setWheelColor(-1);
                }
            }
        }
    }

    public void func_76316_a(IInventory inventory) {
        this.updateSlots();
    }

    @Override
    protected void onVehicleDestroyed(EntityLivingBase entity) {
        boolean isCreativeMode;
        super.onVehicleDestroyed(entity);
        boolean bl = isCreativeMode = entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d;
        if (!isCreativeMode && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            ItemStack key;
            ItemStack engine = this.getEngineStack();
            if (this.getEngineType() != EngineType.NONE && !engine.func_190926_b()) {
                InventoryUtil.spawnItemStack(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, engine);
            }
            if (!(key = this.getKeyStack().func_77946_l()).func_190926_b()) {
                CommonUtils.getItemTagCompound(key).func_82580_o("vehicleId");
                InventoryUtil.spawnItemStack(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, key);
            }
            ItemStack wheel = this.getWheelStack();
            if (this.canChangeWheels() && !wheel.func_190926_b()) {
                InventoryUtil.spawnItemStack(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, wheel);
            }
        }
    }

    public boolean canChangeWheels() {
        return true;
    }

    private void updateWheelPositions() {
        VehicleProperties properties = this.getProperties();
        if (properties.getWheels() != null) {
            List<Wheel> wheels = properties.getWheels();
            for (int i = 0; i < wheels.size(); ++i) {
                Wheel wheel = wheels.get(i);
                PartPosition bodyPosition = properties.getBodyPosition();
                double wheelX = bodyPosition.getX();
                double wheelY = bodyPosition.getY();
                double wheelZ = bodyPosition.getZ();
                double scale = bodyPosition.getScale();
                wheelY += (double)(properties.getWheelOffset() * 0.0625f) * scale;
                wheelX += (double)wheel.getOffsetX() * 0.0625 * (double)wheel.getSide().getOffset() * scale;
                wheelY += (double)wheel.getOffsetY() * 0.0625 * scale;
                Vec3d wheelVec = new Vec3d(wheelX += (double)(wheel.getWidth() * wheel.getScaleX() / 2.0f) * 0.0625 * (double)wheel.getSide().getOffset() * scale, wheelY -= 0.15625 * (double)wheel.getScaleY(), wheelZ += (double)wheel.getOffsetZ() * 0.0625 * scale).func_178785_b(-this.getModifiedRotationYaw() * ((float)Math.PI / 180));
                this.wheelPositions[i * 3] = wheelVec.field_72450_a;
                this.wheelPositions[i * 3 + 1] = wheelVec.field_72448_b;
                this.wheelPositions[i * 3 + 2] = wheelVec.field_72449_c;
            }
        }
    }

    public float getWheelModifier() {
        float wheelModifier = 0.0f;
        VehicleProperties properties = this.getProperties();
        List<Wheel> wheels = properties.getWheels();
        if (this.hasWheels() && wheels != null) {
            int wheelCount = 0;
            WheelType type = this.getWheelType();
            for (int i = 0; i < wheels.size(); ++i) {
                int z;
                int y;
                double wheelX = this.wheelPositions[i * 3];
                double wheelY = this.wheelPositions[i * 3 + 1];
                double wheelZ = this.wheelPositions[i * 3 + 2];
                int x = MathHelper.func_76128_c((double)(this.field_70165_t + wheelX));
                BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.field_70163_u + wheelY - 0.2)), z = MathHelper.func_76128_c((double)(this.field_70161_v + wheelZ)));
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                if (state.func_185904_a() == Material.field_151579_a) continue;
                wheelModifier = state.func_185904_a() == Material.field_151597_y || state.func_185904_a() == Material.field_151596_z || state.func_177230_c() == Blocks.field_150349_c && ((Boolean)state.func_177229_b((IProperty)BlockGrass.field_176498_a)).booleanValue() ? (wheelModifier += 1.0f - type.snowMultiplier) : (!state.func_185904_a().func_76229_l() ? (wheelModifier += 1.0f - type.roadMultiplier) : (wheelModifier += 1.0f - type.dirtMultiplier));
                ++wheelCount;
            }
            if (wheelCount > 0) {
                wheelModifier /= (float)wheelCount;
            }
        }
        return 1.0f - wheelModifier;
    }

    protected void updateGroundState() {
        if (this.hasWheels()) {
            VehicleProperties properties = this.getProperties();
            List<Wheel> wheels = properties.getWheels();
            if (this.hasWheels() && wheels != null) {
                for (int i = 0; i < wheels.size(); ++i) {
                    int z;
                    int y;
                    double wheelX = this.wheelPositions[i * 3];
                    double wheelY = this.wheelPositions[i * 3 + 1];
                    double wheelZ = this.wheelPositions[i * 3 + 2];
                    int x = MathHelper.func_76128_c((double)(this.field_70165_t + wheelX));
                    BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.field_70163_u + wheelY - 0.2)), z = MathHelper.func_76128_c((double)(this.field_70161_v + wheelZ)));
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    if (state.func_185890_d((IBlockAccess)this.field_70170_p, pos) == Block.field_185506_k) continue;
                    this.wheelsOnGround = true;
                    return;
                }
            }
            this.wheelsOnGround = false;
        }
    }

    protected boolean canAccelerateInAir() {
        return false;
    }

    @Override
    public ItemStack getPickedResult(RayTraceResult target) {
        ResourceLocation entityId;
        EngineTier engineTier = null;
        if (this.hasEngine()) {
            engineTier = this.getEngineTier();
        }
        int wheelColor = -1;
        WheelType wheelType = null;
        if (this.hasWheels()) {
            wheelType = this.getWheelType();
            wheelColor = this.getWheelColor();
        }
        if ((entityId = EntityList.func_191301_a((Entity)this)) != null) {
            return BlockVehicleCrate.create(entityId, this.getColor(), engineTier, wheelType, wheelColor);
        }
        return ItemStack.field_190927_a;
    }

    public FuelPort getFuelPort() {
        return this.fuelPort;
    }

    public static enum FuelPort {
        LID(SpecialModels.FUEL_PORT_CLOSED, SpecialModels.FUEL_PORT_BODY, SpecialModels.FUEL_PORT_LID, ModSounds.FUEL_PORT_OPEN, 0.25f, 0.6f, ModSounds.FUEL_PORT_CLOSE, 0.12f, 0.6f),
        CAP(SpecialModels.FUEL_PORT_2_CLOSED, SpecialModels.FUEL_PORT_2_PIPE, null, ModSounds.FUEL_PORT_2_OPEN, 0.4f, 0.6f, ModSounds.FUEL_PORT_2_CLOSE, 0.3f, 0.6f);

        private SpecialModels closed;
        private SpecialModels body;
        private SpecialModels lid;
        private SoundEvent soundOpen;
        private SoundEvent soundClose;
        private float volumeOpen;
        private float volumeClose;
        private float pitchOpen;
        private float pitchClose;

        private FuelPort(SpecialModels closed, SpecialModels body, SpecialModels lid, SoundEvent soundOpen, float volumeOpen, float pitchOpen, SoundEvent soundClose, float volumeClose, float pitchClose) {
            this.closed = closed;
            this.body = body;
            this.lid = lid;
            this.soundOpen = soundOpen;
            this.volumeOpen = volumeOpen;
            this.pitchOpen = pitchOpen;
            this.soundClose = soundClose;
            this.volumeClose = volumeClose;
            this.pitchClose = pitchClose;
        }

        public SpecialModels getClosed() {
            return this.closed;
        }

        public SpecialModels getBody() {
            return this.body;
        }

        public SpecialModels getLid() {
            return this.lid;
        }

        public void playOpenSound() {
            Minecraft.func_71410_x().field_71439_g.func_184185_a(this.soundOpen, this.volumeOpen, this.pitchOpen);
        }

        public void playCloseSound() {
            Minecraft.func_71410_x().field_71439_g.func_184185_a(this.soundClose, this.volumeClose, this.pitchClose);
        }
    }

    public static enum AccelerationDirection {
        FORWARD,
        NONE,
        REVERSE;


        public static AccelerationDirection fromEntity(EntityLivingBase entity) {
            if (entity.field_191988_bg > 0.0f) {
                return FORWARD;
            }
            if (entity.field_191988_bg < 0.0f) {
                return REVERSE;
            }
            return NONE;
        }
    }

    public static enum TurnDirection {
        LEFT(1),
        FORWARD(0),
        RIGHT(-1);

        final int dir;

        private TurnDirection(int dir) {
            this.dir = dir;
        }

        public int getDir() {
            return this.dir;
        }
    }
}

