/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.entity.EntityLandVehicle;
import com.mrcrayfish.vehicle.entity.EntityTrailer;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageHitchTrailer
implements IMessage,
IMessageHandler<MessageHitchTrailer, IMessage> {
    private boolean hitch;

    public MessageHitchTrailer() {
    }

    public MessageHitchTrailer(boolean hitch) {
        this.hitch = hitch;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.hitch);
    }

    public void fromBytes(ByteBuf buf) {
        this.hitch = buf.readBoolean();
    }

    public IMessage onMessage(MessageHitchTrailer message, MessageContext ctx) {
        FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
            EntityVehicle vehicle;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player.func_184187_bx() instanceof EntityVehicle && (vehicle = (EntityVehicle)player.func_184187_bx()).canTowTrailer()) {
                if (!message.hitch) {
                    if (vehicle.getTrailer() != null) {
                        vehicle.setTrailer(null);
                        player.field_70170_p.func_184133_a(null, vehicle.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                } else {
                    VehicleProperties properties = vehicle.getProperties();
                    Vec3d vehicleVec = vehicle.func_174791_d();
                    Vec3d towBarVec = properties.getTowBarPosition();
                    towBarVec = new Vec3d(towBarVec.field_72450_a * 0.0625, towBarVec.field_72448_b * 0.0625, towBarVec.field_72449_c * 0.0625 + properties.getBodyPosition().getZ());
                    if (vehicle instanceof EntityLandVehicle) {
                        EntityLandVehicle landVehicle = (EntityLandVehicle)vehicle;
                        vehicleVec = vehicleVec.func_178787_e(towBarVec.func_178785_b((float)Math.toRadians(-vehicle.field_70177_z + landVehicle.additionalYaw)));
                    } else {
                        vehicleVec = vehicleVec.func_178787_e(towBarVec.func_178785_b((float)Math.toRadians(-vehicle.field_70177_z)));
                    }
                    AxisAlignedBB towBarBox = new AxisAlignedBB(vehicleVec.field_72450_a, vehicleVec.field_72448_b, vehicleVec.field_72449_c, vehicleVec.field_72450_a, vehicleVec.field_72448_b, vehicleVec.field_72449_c).func_186662_g(0.25);
                    List trailers = player.field_70170_p.func_175647_a(EntityTrailer.class, vehicle.func_174813_aQ().func_186662_g(5.0), input -> input.getPullingEntity() == null);
                    for (EntityTrailer trailer : trailers) {
                        if (trailer.getPullingEntity() != null) continue;
                        Vec3d trailerVec = trailer.func_174791_d();
                        Vec3d hitchVec = new Vec3d(0.0, 0.0, -trailer.getHitchOffset() / 16.0);
                        trailerVec = trailerVec.func_178787_e(hitchVec.func_178785_b((float)Math.toRadians(-trailer.field_70177_z)));
                        AxisAlignedBB hitchBox = new AxisAlignedBB(trailerVec.field_72450_a, trailerVec.field_72448_b, trailerVec.field_72449_c, trailerVec.field_72450_a, trailerVec.field_72448_b, trailerVec.field_72449_c).func_186662_g(0.25);
                        if (!towBarBox.func_72326_a(hitchBox)) continue;
                        vehicle.setTrailer(trailer);
                        player.field_70170_p.func_184133_a(null, vehicle.func_180425_c(), SoundEvents.field_187692_g, SoundCategory.PLAYERS, 1.0f, 1.5f);
                        return;
                    }
                }
            }
        });
        return null;
    }
}

