/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.proxy;

import com.google.common.base.Optional;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.client.ClientEvents;
import com.mrcrayfish.vehicle.client.ControllerEvents;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.client.HeldVehicleEvents;
import com.mrcrayfish.vehicle.client.audio.MovingSoundHorn;
import com.mrcrayfish.vehicle.client.audio.MovingSoundHornRiding;
import com.mrcrayfish.vehicle.client.audio.MovingSoundVehicle;
import com.mrcrayfish.vehicle.client.audio.MovingSoundVehicleRiding;
import com.mrcrayfish.vehicle.client.gui.GuiEditVehicle;
import com.mrcrayfish.vehicle.client.gui.GuiStorage;
import com.mrcrayfish.vehicle.client.model.CustomLoader;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.RenderBoatWrapper;
import com.mrcrayfish.vehicle.client.render.RenderEntityVehicle;
import com.mrcrayfish.vehicle.client.render.RenderHelicopterWrapper;
import com.mrcrayfish.vehicle.client.render.RenderLandVehicleWrapper;
import com.mrcrayfish.vehicle.client.render.RenderMotorcycleWrapper;
import com.mrcrayfish.vehicle.client.render.RenderPlaneWrapper;
import com.mrcrayfish.vehicle.client.render.RenderVehicleWrapper;
import com.mrcrayfish.vehicle.client.render.VehicleRenderRegistry;
import com.mrcrayfish.vehicle.client.render.tileentity.FluidExtractorRenderer;
import com.mrcrayfish.vehicle.client.render.tileentity.FuelDrumRenderer;
import com.mrcrayfish.vehicle.client.render.tileentity.GasPumpRenderer;
import com.mrcrayfish.vehicle.client.render.tileentity.GasPumpTankRenderer;
import com.mrcrayfish.vehicle.client.render.tileentity.JackRenderer;
import com.mrcrayfish.vehicle.client.render.tileentity.VehicleCrateRenderer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderATV;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderAluminumBoat;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderBath;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderBumperCar;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderCouch;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderCouchHelicopter;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderDuneBuggy;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderFertilizerTrailer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderFluidTrailer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderGoKart;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderGolfCart;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderJetSki;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderLawnMower;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderMiniBike;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderMiniBus;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderMoped;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderOffRoader;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderSeederTrailer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderShoppingCart;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderSmartCar;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderSpeedBoat;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderSportsPlane;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderStorageTrailer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderTractor;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderVehicleTrailer;
import com.mrcrayfish.vehicle.common.entity.HeldVehicleDataHandler;
import com.mrcrayfish.vehicle.common.entity.SyncedPlayerData;
import com.mrcrayfish.vehicle.common.inventory.IStorage;
import com.mrcrayfish.vehicle.entity.EntityHelicopter;
import com.mrcrayfish.vehicle.entity.EntityPlane;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.trailer.EntityFertilizerTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityFluidTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntitySeederTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityStorageTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityVehicleTrailer;
import com.mrcrayfish.vehicle.entity.vehicle.EntityATV;
import com.mrcrayfish.vehicle.entity.vehicle.EntityAluminumBoat;
import com.mrcrayfish.vehicle.entity.vehicle.EntityBath;
import com.mrcrayfish.vehicle.entity.vehicle.EntityBumperCar;
import com.mrcrayfish.vehicle.entity.vehicle.EntityCouch;
import com.mrcrayfish.vehicle.entity.vehicle.EntityDuneBuggy;
import com.mrcrayfish.vehicle.entity.vehicle.EntityGoKart;
import com.mrcrayfish.vehicle.entity.vehicle.EntityGolfCart;
import com.mrcrayfish.vehicle.entity.vehicle.EntityJetSki;
import com.mrcrayfish.vehicle.entity.vehicle.EntityLawnMower;
import com.mrcrayfish.vehicle.entity.vehicle.EntityMiniBike;
import com.mrcrayfish.vehicle.entity.vehicle.EntityMiniBus;
import com.mrcrayfish.vehicle.entity.vehicle.EntityMoped;
import com.mrcrayfish.vehicle.entity.vehicle.EntityOffRoader;
import com.mrcrayfish.vehicle.entity.vehicle.EntityShoppingCart;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySmartCar;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySofacopter;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySpeedBoat;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySportsPlane;
import com.mrcrayfish.vehicle.entity.vehicle.EntityTractor;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.init.RegistrationHandler;
import com.mrcrayfish.vehicle.item.ItemKey;
import com.mrcrayfish.vehicle.item.ItemPart;
import com.mrcrayfish.vehicle.item.ItemSprayCan;
import com.mrcrayfish.vehicle.proxy.Proxy;
import com.mrcrayfish.vehicle.tileentity.TileEntityFluidExtractor;
import com.mrcrayfish.vehicle.tileentity.TileEntityFuelDrum;
import com.mrcrayfish.vehicle.tileentity.TileEntityGasPump;
import com.mrcrayfish.vehicle.tileentity.TileEntityGasPumpTank;
import com.mrcrayfish.vehicle.tileentity.TileEntityJack;
import com.mrcrayfish.vehicle.tileentity.TileEntityVehicleCrate;
import com.mrcrayfish.vehicle.util.FluidUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
implements Proxy {
    public static final KeyBinding KEY_HORN = new KeyBinding("key.vehicle.horn", 35, "key.categories.vehicle");
    public static final KeyBinding KEY_CYCLE_SEATS = new KeyBinding("key.vehicle.cycle_seats", 46, "key.categories.vehicle");
    public static boolean controllableLoaded = false;
    private static final WeakHashMap<UUID, Map<SoundType, ITickableSound>> SOUND_TRACKER = new WeakHashMap();

    @Override
    public void preInit() {
        this.registerVehicleRender(EntityATV.class, new RenderLandVehicleWrapper(new RenderATV()));
        this.registerVehicleRender(EntityDuneBuggy.class, new RenderLandVehicleWrapper(new RenderDuneBuggy()));
        this.registerVehicleRender(EntityGoKart.class, new RenderLandVehicleWrapper(new RenderGoKart()));
        this.registerVehicleRender(EntityShoppingCart.class, new RenderLandVehicleWrapper(new RenderShoppingCart()));
        this.registerVehicleRender(EntityMiniBike.class, new RenderMotorcycleWrapper(new RenderMiniBike()));
        this.registerVehicleRender(EntityBumperCar.class, new RenderLandVehicleWrapper(new RenderBumperCar()));
        this.registerVehicleRender(EntityJetSki.class, new RenderBoatWrapper(new RenderJetSki()));
        this.registerVehicleRender(EntitySpeedBoat.class, new RenderBoatWrapper(new RenderSpeedBoat()));
        this.registerVehicleRender(EntityAluminumBoat.class, new RenderBoatWrapper(new RenderAluminumBoat()));
        this.registerVehicleRender(EntitySmartCar.class, new RenderLandVehicleWrapper(new RenderSmartCar()));
        this.registerVehicleRender(EntityLawnMower.class, new RenderLandVehicleWrapper(new RenderLawnMower()));
        this.registerVehicleRender(EntityMoped.class, new RenderMotorcycleWrapper(new RenderMoped()));
        this.registerVehicleRender(EntitySportsPlane.class, new RenderPlaneWrapper(new RenderSportsPlane()));
        this.registerVehicleRender(EntityGolfCart.class, new RenderLandVehicleWrapper(new RenderGolfCart()));
        this.registerVehicleRender(EntityOffRoader.class, new RenderLandVehicleWrapper(new RenderOffRoader()));
        this.registerVehicleRender(EntityTractor.class, new RenderLandVehicleWrapper(new RenderTractor()));
        this.registerVehicleRender(EntityMiniBus.class, new RenderLandVehicleWrapper(new RenderMiniBus()));
        if (Loader.isModLoaded((String)"cfm")) {
            this.registerVehicleRender(EntityCouch.class, new RenderLandVehicleWrapper(new RenderCouch()));
            this.registerVehicleRender(EntityBath.class, new RenderPlaneWrapper(new RenderBath()));
            this.registerVehicleRender(EntitySofacopter.class, new RenderHelicopterWrapper(new RenderCouchHelicopter()));
        }
        this.registerVehicleRender(EntityVehicleTrailer.class, new RenderVehicleWrapper(new RenderVehicleTrailer()));
        this.registerVehicleRender(EntityStorageTrailer.class, new RenderVehicleWrapper(new RenderStorageTrailer()));
        this.registerVehicleRender(EntitySeederTrailer.class, new RenderVehicleWrapper(new RenderSeederTrailer()));
        this.registerVehicleRender(EntityFertilizerTrailer.class, new RenderVehicleWrapper(new RenderFertilizerTrailer()));
        this.registerVehicleRender(EntityFluidTrailer.class, new RenderVehicleWrapper(new RenderFluidTrailer()));
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        MinecraftForge.EVENT_BUS.register((Object)new HeldVehicleEvents());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFluidExtractor.class, (TileEntitySpecialRenderer)new FluidExtractorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFuelDrum.class, (TileEntitySpecialRenderer)new FuelDrumRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityVehicleCrate.class, (TileEntitySpecialRenderer)new VehicleCrateRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityJack.class, (TileEntitySpecialRenderer)new JackRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGasPump.class, (TileEntitySpecialRenderer)new GasPumpRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGasPumpTank.class, (TileEntitySpecialRenderer)new GasPumpTankRenderer());
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_HORN);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_CYCLE_SEATS);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new CustomLoader());
    }

    private <T extends EntityVehicle, R extends AbstractRenderVehicle<T>> void registerVehicleRender(Class<T> clazz, RenderVehicleWrapper<T, R> wrapper) {
        RenderingRegistry.registerEntityRenderingHandler(clazz, manager -> new RenderEntityVehicle(manager, wrapper));
        VehicleRenderRegistry.registerRenderWrapper(clazz, wrapper);
    }

    @Override
    public void init() {
        IItemColor color = (stack, index) -> {
            if (index == 0 && stack.func_77942_o() && stack.func_77978_p().func_150297_b("color", 3)) {
                return stack.func_77978_p().func_74762_e("color");
            }
            return -1;
        };
        RegistrationHandler.Items.getItems().forEach(item -> {
            if (item instanceof ItemSprayCan || item instanceof ItemKey || item instanceof ItemPart && ((ItemPart)((Object)item)).isColored() || item == ModItems.MODELS) {
                Minecraft.func_71410_x().getItemColors().func_186730_a(color, new Item[]{item});
            }
        });
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(resourceManager -> {
            FluidUtils.clearCacheFluidColor();
            EntityRaytracer.clearDataForReregistration();
        });
    }

    @Override
    public void postInit() {
        if (Loader.isModLoaded((String)"controllable")) {
            controllableLoaded = true;
            MinecraftForge.EVENT_BUS.register((Object)new ControllerEvents());
        }
    }

    @Override
    public void playVehicleSound(EntityPlayer player, EntityPoweredVehicle vehicle) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            Object sound;
            Map soundMap = SOUND_TRACKER.computeIfAbsent(vehicle.func_110124_au(), uuid -> new HashMap());
            if (vehicle.getRidingSound() != null && player.equals((Object)Minecraft.func_71410_x().field_71439_g) && ((sound = (ITickableSound)soundMap.get((Object)SoundType.ENGINE_RIDING)) == null || sound.func_147667_k() || !Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)sound))) {
                sound = new MovingSoundVehicleRiding(player, vehicle);
                soundMap.put(SoundType.ENGINE_RIDING, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            }
            if (!(vehicle.getMovingSound() == null || player.equals((Object)Minecraft.func_71410_x().field_71439_g) || (sound = (ITickableSound)soundMap.get((Object)SoundType.ENGINE)) != null && !sound.func_147667_k() && Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)sound))) {
                sound = new MovingSoundVehicle(vehicle);
                soundMap.put(SoundType.ENGINE, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSoundVehicle(vehicle));
            }
            if (!(vehicle.getHornSound() == null || player.equals((Object)Minecraft.func_71410_x().field_71439_g) || (sound = (ITickableSound)soundMap.get((Object)SoundType.HORN)) != null && !sound.func_147667_k() && Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)sound))) {
                sound = new MovingSoundHorn(vehicle);
                soundMap.put(SoundType.HORN, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            }
            if (vehicle.getHornRidingSound() != null && player.equals((Object)Minecraft.func_71410_x().field_71439_g) && ((sound = (ITickableSound)soundMap.get((Object)SoundType.HORN_RIDING)) == null || sound.func_147667_k() || !Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)sound))) {
                sound = new MovingSoundHornRiding(player, vehicle);
                soundMap.put(SoundType.HORN_RIDING, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            }
        });
    }

    @Override
    public void playSound(SoundEvent soundEvent, BlockPos pos, float volume, float pitch) {
        PositionedSoundRecord sound = new PositionedSoundRecord(soundEvent, SoundCategory.BLOCKS, volume, pitch, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
        Minecraft.func_71410_x().func_152344_a(() -> ClientProxy.lambda$playSound$6((ISound)sound));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
    }

    @Override
    public void openVehicleEditWindow(int entityId, int windowId) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        World world = player.func_130014_f_();
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof EntityPoweredVehicle) {
            EntityPoweredVehicle poweredVehicle = (EntityPoweredVehicle)entity;
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiEditVehicle((IInventory)poweredVehicle.getVehicleInventory(), poweredVehicle, (EntityPlayer)player));
            player.field_71070_bA.field_75152_c = windowId;
        }
    }

    @Override
    public void syncStorageInventory(int entityId, NBTTagCompound tagCompound) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof IStorage) {
            IStorage wrapper = (IStorage)entity;
            wrapper.getInventory().readFromNBT(tagCompound);
        }
    }

    @Override
    public void openStorageWindow(int entityId, int windowId) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        World world = player.func_130014_f_();
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof IStorage) {
            IStorage wrapper = (IStorage)entity;
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiStorage((IInventory)player.field_71071_by, wrapper.getInventory()));
            player.field_71070_bA.field_75152_c = windowId;
        }
    }

    @Override
    public EntityPoweredVehicle.AccelerationDirection getAccelerationDirection(EntityLivingBase entity) {
        if (controllableLoaded) {
            if (Minecraft.func_71410_x().field_71462_r != null) {
                return EntityPoweredVehicle.AccelerationDirection.NONE;
            }
            Controller controller = Controllable.getController();
            if (controller != null) {
                if (VehicleConfig.CLIENT.controller.useTriggers) {
                    if (controller.getRTriggerValue() != 0.0f && controller.getLTriggerValue() == 0.0f) {
                        return EntityPoweredVehicle.AccelerationDirection.FORWARD;
                    }
                    if (controller.getLTriggerValue() != 0.0f && controller.getRTriggerValue() == 0.0f) {
                        return EntityPoweredVehicle.AccelerationDirection.REVERSE;
                    }
                } else {
                    if (controller.isButtonPressed(0)) {
                        return EntityPoweredVehicle.AccelerationDirection.FORWARD;
                    }
                    if (controller.isButtonPressed(1)) {
                        return EntityPoweredVehicle.AccelerationDirection.REVERSE;
                    }
                }
            }
        }
        return EntityPoweredVehicle.AccelerationDirection.fromEntity(entity);
    }

    @Override
    public EntityPoweredVehicle.TurnDirection getTurnDirection(EntityLivingBase entity) {
        if (controllableLoaded) {
            if (Minecraft.func_71410_x().field_71462_r != null) {
                return EntityPoweredVehicle.TurnDirection.FORWARD;
            }
            Controller controller = Controllable.getController();
            if (controller != null) {
                if (controller.getLThumbStickXValue() > 0.0f) {
                    return EntityPoweredVehicle.TurnDirection.RIGHT;
                }
                if (controller.getLThumbStickXValue() < 0.0f) {
                    return EntityPoweredVehicle.TurnDirection.LEFT;
                }
                if (controller.isButtonPressed(16)) {
                    return EntityPoweredVehicle.TurnDirection.RIGHT;
                }
                if (controller.isButtonPressed(15)) {
                    return EntityPoweredVehicle.TurnDirection.LEFT;
                }
            }
        }
        if (entity.field_70702_br < 0.0f) {
            return EntityPoweredVehicle.TurnDirection.RIGHT;
        }
        if (entity.field_70702_br > 0.0f) {
            return EntityPoweredVehicle.TurnDirection.LEFT;
        }
        return EntityPoweredVehicle.TurnDirection.FORWARD;
    }

    @Override
    public float getTargetTurnAngle(EntityPoweredVehicle vehicle, boolean drifting) {
        EntityPoweredVehicle.TurnDirection direction = vehicle.getTurnDirection();
        if (vehicle.func_184179_bs() != null) {
            if (controllableLoaded) {
                float turnNormal;
                if (Minecraft.func_71410_x().field_71462_r != null) {
                    return 0.0f;
                }
                Controller controller = Controllable.getController();
                if (controller != null && (turnNormal = controller.getLThumbStickXValue()) != 0.0f) {
                    float newTurnAngle = vehicle.turnAngle + ((float)vehicle.getMaxTurnAngle() * -turnNormal - vehicle.turnAngle) * 0.15f;
                    if (Math.abs(newTurnAngle) > (float)vehicle.getMaxTurnAngle()) {
                        return vehicle.getMaxTurnAngle() * direction.getDir();
                    }
                    return newTurnAngle;
                }
            }
            if (direction != EntityPoweredVehicle.TurnDirection.FORWARD) {
                float newTurnAngle;
                float amount = direction.getDir() * vehicle.getTurnSensitivity();
                if (drifting) {
                    amount *= 0.45f;
                }
                if (Math.abs(newTurnAngle = vehicle.turnAngle + amount) > (float)vehicle.getMaxTurnAngle()) {
                    return vehicle.getMaxTurnAngle() * direction.getDir();
                }
                return newTurnAngle;
            }
        }
        if (drifting) {
            return vehicle.turnAngle * 0.95f;
        }
        return vehicle.turnAngle * 0.75f;
    }

    @Override
    public boolean isDrifting() {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null && controller.isButtonPressed(10)) {
            return true;
        }
        return Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
    }

    @Override
    public boolean isHonking() {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null && controller.isButtonPressed(8)) {
            return true;
        }
        return KEY_HORN.func_151470_d();
    }

    @Override
    public EntityPlane.FlapDirection getFlapDirection() {
        Controller controller;
        boolean flapUp = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        boolean flapDown = Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d();
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            flapUp |= controller.isButtonPressed(10);
            flapDown |= controller.isButtonPressed(9);
        }
        return EntityPlane.FlapDirection.fromInput(flapUp, flapDown);
    }

    @Override
    public EntityHelicopter.AltitudeChange getAltitudeChange() {
        Controller controller;
        boolean flapUp = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        boolean flapDown = Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d();
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            flapUp |= controller.isButtonPressed(10);
            flapDown |= controller.isButtonPressed(9);
        }
        return EntityHelicopter.AltitudeChange.fromInput(flapUp, flapDown);
    }

    @Override
    public float getTravelDirection(EntityHelicopter vehicle) {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            float xAxis = controller.getLThumbStickXValue();
            float yAxis = controller.getLThumbStickYValue();
            if (xAxis != 0.0f || yAxis != 0.0f) {
                float angle = (float)Math.toDegrees(Math.atan2(-xAxis, yAxis)) + 180.0f;
                return vehicle.field_70177_z + angle;
            }
        }
        EntityPoweredVehicle.AccelerationDirection accelerationDirection = vehicle.getAcceleration();
        EntityPoweredVehicle.TurnDirection turnDirection = vehicle.getTurnDirection();
        if (vehicle.func_184179_bs() != null) {
            if (accelerationDirection == EntityPoweredVehicle.AccelerationDirection.FORWARD) {
                return vehicle.field_70177_z + (float)turnDirection.getDir() * -45.0f;
            }
            if (accelerationDirection == EntityPoweredVehicle.AccelerationDirection.REVERSE) {
                return vehicle.field_70177_z + 180.0f + (float)turnDirection.getDir() * 45.0f;
            }
            return vehicle.field_70177_z + (float)turnDirection.getDir() * -90.0f;
        }
        return vehicle.field_70177_z;
    }

    @Override
    public float getTravelSpeed(EntityHelicopter helicopter) {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            float xAxis = controller.getLThumbStickXValue();
            float yAxis = controller.getLThumbStickYValue();
            if (xAxis != 0.0f || yAxis != 0.0f) {
                return (float)Math.min(1.0, Math.sqrt(Math.pow(xAxis, 2.0) + Math.pow(yAxis, 2.0)));
            }
        }
        return helicopter.getAcceleration() != EntityPoweredVehicle.AccelerationDirection.NONE || helicopter.getTurnDirection() != EntityPoweredVehicle.TurnDirection.FORWARD ? 1.0f : 0.0f;
    }

    @Override
    public float getPower(EntityPoweredVehicle vehicle) {
        Controller controller;
        if (controllableLoaded && VehicleConfig.CLIENT.controller.useTriggers && (controller = Controllable.getController()) != null) {
            EntityPoweredVehicle.AccelerationDirection accelerationDirection = vehicle.getAcceleration();
            if (accelerationDirection == EntityPoweredVehicle.AccelerationDirection.FORWARD) {
                return controller.getRTriggerValue();
            }
            if (accelerationDirection == EntityPoweredVehicle.AccelerationDirection.REVERSE) {
                return controller.getLTriggerValue();
            }
        }
        return 1.0f;
    }

    @Override
    public void syncEntityFluid(int entityId, FluidStack stack) {
        IFluidHandler handler;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity entity = world.func_73045_a(entityId);
        if (entity != null && entity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (handler = (IFluidHandler)entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) instanceof FluidTank) {
            FluidTank tank = (FluidTank)handler;
            tank.setFluid(stack);
        }
    }

    @Override
    public void syncPlayerSeat(int entityId, int seatIndex, UUID uuid) {
        Entity entity;
        EntityPlayerSP clientPlayer = Minecraft.func_71410_x().field_71439_g;
        if (clientPlayer != null && (entity = clientPlayer.field_70170_p.func_73045_a(entityId)) instanceof EntityVehicle) {
            EntityVehicle vehicle = (EntityVehicle)entity;
            vehicle.getSeatTracker().setSeatIndex(seatIndex, uuid);
        }
    }

    @Override
    public void syncHeldVehicle(int entityId, NBTTagCompound tagCompound) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof EntityPlayer) {
            HeldVehicleDataHandler.setHeldVehicle((EntityPlayer)entity, tagCompound);
        }
    }

    @Override
    public void syncPlayerData(int entityId, int trailer, Optional<BlockPos> gasPumpPos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            SyncedPlayerData.setTrailer(player, trailer);
            SyncedPlayerData.setGasPumpPos(player, gasPumpPos);
        }
    }

    @Override
    public void syncTrailer(int entityId, int trailer) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            SyncedPlayerData.setTrailer(player, trailer);
        }
    }

    @Override
    public void syncGasPumpPos(int entityId, Optional<BlockPos> gasPumpPos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            SyncedPlayerData.setGasPumpPos(player, gasPumpPos);
        }
    }

    private static /* synthetic */ void lambda$playSound$6(ISound sound) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a(sound);
    }

    private static enum SoundType {
        ENGINE,
        ENGINE_RIDING,
        HORN,
        HORN_RIDING;

    }
}

