/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.mrcrayfish.vehicle.block.BlockObject;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.item.WrenchItem;
import com.mrcrayfish.vehicle.tileentity.FluidPipeTileEntity;
import com.mrcrayfish.vehicle.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BlockFluidPipe
extends BlockObject {
    public static final DirectionProperty DIRECTION = DirectionProperty.func_196962_a((String)"facing", (Direction[])Direction.values());
    public static final BooleanProperty[] CONNECTED_PIPES = (BooleanProperty[])Util.func_199748_a(() -> {
        BooleanProperty[] directions = new BooleanProperty[Direction.values().length];
        for (Direction facing : Direction.values()) {
            directions[facing.func_176745_a()] = BooleanProperty.func_177716_a((String)("pipe_" + facing.func_176610_l()));
        }
        return directions;
    });
    protected static final VoxelShape CENTER = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    protected static final VoxelShape[] PIPES = new VoxelShape[]{Block.func_208617_a((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)5.0, (double)10.5), Block.func_208617_a((double)5.5, (double)11.0, (double)5.5, (double)10.5, (double)16.0, (double)10.5), Block.func_208617_a((double)5.5, (double)5.5, (double)0.0, (double)10.5, (double)10.5, (double)5.0), Block.func_208617_a((double)5.5, (double)5.5, (double)11.0, (double)10.5, (double)10.5, (double)16.0), Block.func_208617_a((double)0.0, (double)5.5, (double)5.5, (double)5.0, (double)10.5, (double)10.5), Block.func_208617_a((double)11.0, (double)5.5, (double)5.5, (double)16.0, (double)10.5, (double)10.5), CENTER};

    public BlockFluidPipe() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(0.5f));
        BlockState defaultState = (BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)DIRECTION, (Comparable)Direction.NORTH);
        for (Direction facing : Direction.values()) {
            defaultState = (BlockState)defaultState.func_206870_a((IProperty)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(false));
        }
        this.func_180632_j(defaultState);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader reader, List<ITextComponent> list, ITooltipFlag advanced) {
        if (Screen.hasShiftDown()) {
            String info = I18n.func_135052_a((String)(this.func_149739_a() + ".info"), (Object[])new Object[0]);
            list.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(info, 150).stream().map(StringTextComponent::new).collect(Collectors.toList()));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0])));
        }
    }

    protected Direction getCollisionFacing(BlockState state) {
        return (Direction)state.func_177229_b((IProperty)DIRECTION);
    }

    @Nullable
    public static FluidPipeTileEntity getPipeTileEntity(IBlockReader world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity instanceof FluidPipeTileEntity ? (FluidPipeTileEntity)tileEntity : null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getPipeShape(state, worldIn, pos);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getPipeShape(state, worldIn, pos);
    }

    protected VoxelShape getPipeShape(BlockState state, IBlockReader worldIn, BlockPos pos) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        boolean[] disabledConnections = FluidPipeTileEntity.getDisabledConnections(BlockFluidPipe.getPipeTileEntity(worldIn, pos));
        for (int i = 0; i < Direction.values().length; ++i) {
            if (!((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[i])).booleanValue() || disabledConnections[i]) continue;
            shapes.add(PIPES[i]);
        }
        shapes.addAll(Arrays.asList(PIPES).subList(Direction.values().length, PIPES.length));
        shapes.add(PIPES[this.getCollisionFacing(state).func_176745_a()]);
        return VoxelShapeHelper.combineAll(shapes);
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        FluidPipeTileEntity pipe = BlockFluidPipe.getPipeTileEntity((IBlockReader)world, pos);
        Pair<AxisAlignedBB, Direction> hit = this.getBox(world, pos, state, player, hand, result.func_216354_b(), result.func_216347_e(), pipe);
        if (pipe != null && hit != null) {
            Direction face;
            pipe.setConnectionDisabled(face, !pipe.isConnectionDisabled(face = (Direction)hit.getRight()));
            BlockState newState = (BlockState)state.func_206870_a((IProperty)CONNECTED_PIPES[face.func_176745_a()], (Comparable)Boolean.valueOf(!pipe.isConnectionDisabled(face)));
            world.func_175656_a(pos, newState);
            world.func_184138_a(pos, state, newState, 0);
            world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187605_cG, SoundCategory.BLOCKS, 1.0f, 2.0f);
            return true;
        }
        return true;
    }

    @Nullable
    protected Pair<AxisAlignedBB, Direction> getBox(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, Direction facing, Vec3d hitVec, @Nullable FluidPipeTileEntity pipe) {
        hitVec = hitVec.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        if (pipe == null || !(player.func_184586_b(hand).func_77973_b() instanceof WrenchItem)) {
            return null;
        }
        for (int i = 0; i < Direction.values().length + 1; ++i) {
            boolean isCenter;
            boolean bl = isCenter = i == Direction.values().length;
            if (!isCenter && !((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[i])).booleanValue() || !PIPES[i].func_197752_a().func_186662_g(0.001).func_72318_a(hitVec)) continue;
            if (!isCenter) {
                facing = Direction.func_82600_a((int)i);
            } else if (!((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[facing.func_176745_a()])).booleanValue()) {
                BlockPos adjacentPos = pos.func_177972_a(facing);
                BlockState adjacentState = world.func_180495_p(adjacentPos);
                TileEntity tileEntity = world.func_175625_s(adjacentPos);
                Block adjacentBlock = adjacentState.func_177230_c();
                if (this == ModBlocks.FLUID_PUMP.get() && adjacentBlock == ModBlocks.FLUID_PUMP.get() || this == ModBlocks.FLUID_PIPE.get() && adjacentBlock == ModBlocks.FLUID_PIPE.get() && this.getCollisionFacing(adjacentState) != facing.func_176734_d() || tileEntity == null || !tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()).isPresent()) {
                    return null;
                }
            }
            if (world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() == Blocks.field_150442_at || this.getCollisionFacing(state) == facing) continue;
            return new ImmutablePair((Object)PIPES[i].func_197752_a().func_186670_a(pos), (Object)facing);
        }
        return null;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighbourState, IWorld world, BlockPos pos, BlockPos neighbourPos) {
        return this.getPipeState(state, world, pos, (Direction)state.func_177229_b((IProperty)DIRECTION));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = (BlockState)super.func_196258_a(context).func_206870_a((IProperty)DIRECTION, (Comparable)context.func_196000_l().func_176734_d());
        return this.getPipeState(state, (IWorld)context.func_195991_k(), context.func_195995_a(), context.func_196000_l().func_176734_d());
    }

    protected BlockState getPipeState(BlockState state, IWorld world, BlockPos pos, Direction originalFacing) {
        boolean[] disabledConnections = FluidPipeTileEntity.getDisabledConnections(BlockFluidPipe.getPipeTileEntity((IBlockReader)world, pos));
        for (Direction facing : Direction.values()) {
            boolean enabled;
            if (facing == originalFacing) continue;
            state = (BlockState)state.func_206870_a((IProperty)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(false));
            BlockPos adjacentPos = pos.func_177972_a(facing);
            BlockState adjacentState = world.func_180495_p(adjacentPos);
            boolean bl = enabled = !disabledConnections[facing.func_176745_a()];
            if (adjacentState.func_177230_c() == ModBlocks.FLUID_PIPE.get()) {
                Direction adjacentFacing = (Direction)adjacentState.func_177229_b((IProperty)DIRECTION);
                if (!adjacentPos.func_177972_a(adjacentFacing).equals((Object)pos)) continue;
                state = (BlockState)state.func_206870_a((IProperty)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(enabled));
                continue;
            }
            if (adjacentState.func_177230_c() != ModBlocks.FLUID_PUMP.get()) continue;
            state = (BlockState)state.func_206870_a((IProperty)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(enabled));
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{DIRECTION});
        builder.func_206894_a((IProperty[])CONNECTED_PIPES);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FluidPipeTileEntity();
    }
}

