/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.client.ISpecialModel;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractRenderVehicle<T extends VehicleEntity> {
    protected static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[]{new ResourceLocation("textures/block/destroy_stage_0.png"), new ResourceLocation("textures/block/destroy_stage_1.png"), new ResourceLocation("textures/block/destroy_stage_2.png"), new ResourceLocation("textures/block/destroy_stage_3.png"), new ResourceLocation("textures/block/destroy_stage_4.png"), new ResourceLocation("textures/block/destroy_stage_5.png"), new ResourceLocation("textures/block/destroy_stage_6.png"), new ResourceLocation("textures/block/destroy_stage_7.png"), new ResourceLocation("textures/block/destroy_stage_8.png"), new ResourceLocation("textures/block/destroy_stage_9.png")};

    public ISpecialModel getKeyHoleModel() {
        return SpecialModels.KEY_HOLE;
    }

    public ISpecialModel getTowBarModel() {
        return SpecialModels.TOW_BAR;
    }

    public abstract void render(T var1, float var2);

    public void applyPlayerModel(T entity, PlayerEntity player, PlayerModel<AbstractClientPlayerEntity> model, float partialTicks) {
    }

    public void applyPlayerRender(T entity, PlayerEntity player, float partialTicks) {
    }

    protected boolean shouldRenderFuelLid() {
        return true;
    }

    protected void renderDamagedPart(VehicleEntity vehicle, ItemStack part) {
        this.renderDamagedPart(vehicle, RenderUtil.getModel(part));
    }

    protected void renderDamagedPart(VehicleEntity vehicle, IBakedModel model) {
        this.renderDamagedPart(vehicle, model, false);
        this.renderDamagedPart(vehicle, model, true);
    }

    private void renderDamagedPart(VehicleEntity vehicle, IBakedModel model, boolean renderDamage) {
        if (renderDamage) {
            int stage = vehicle.getDestroyedStage();
            if (stage <= 0) {
                return;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(DESTROY_STAGES[stage - 1]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.scalef((float)64.0f, (float)32.0f, (float)32.0f);
            GlStateManager.matrixMode((int)5888);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.polygonOffset((float)-1.0f, (float)-10.0f);
            GlStateManager.enablePolygonOffset();
            GlStateManager.enableRescaleNormal();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.pushMatrix();
            GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.NONE, (boolean)false);
            if (!model.func_188618_c()) {
                RenderUtil.renderModel(model, ItemStack.field_190927_a, vehicle.getColor());
            }
            GlStateManager.popMatrix();
            GlStateManager.polygonOffset((float)0.0f, (float)0.0f);
            GlStateManager.disablePolygonOffset();
            GlStateManager.disableRescaleNormal();
            GlStateManager.disableBlend();
            GlStateManager.depthFunc((int)515);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        } else {
            RenderUtil.renderColoredModel(model, ItemCameraTransforms.TransformType.NONE, false, vehicle.getColor());
        }
    }
}

