/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.util.RenderUtil;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;

public class RenderVehicleWrapper<T extends VehicleEntity, R extends AbstractRenderVehicle<T>> {
    protected final R renderVehicle;

    public RenderVehicleWrapper(R renderVehicle) {
        this.renderVehicle = renderVehicle;
    }

    public R getRenderVehicle() {
        return this.renderVehicle;
    }

    public void render(T entity, float partialTicks) {
        if (!entity.func_70089_S()) {
            return;
        }
        GlStateManager.pushMatrix();
        VehicleProperties properties = ((VehicleEntity)((Object)entity)).getProperties();
        PartPosition bodyPosition = properties.getBodyPosition();
        GlStateManager.rotated((double)bodyPosition.getRotX(), (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.rotated((double)bodyPosition.getRotY(), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)bodyPosition.getRotZ(), (double)0.0, (double)0.0, (double)1.0);
        if (((VehicleEntity)((Object)entity)).canTowTrailer()) {
            GlStateManager.pushMatrix();
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Vec3d towBarOffset = properties.getTowBarPosition();
            GlStateManager.translated((double)(towBarOffset.field_72450_a * 0.0625), (double)(towBarOffset.field_72448_b * 0.0625 + 0.5), (double)(-towBarOffset.field_72449_c * 0.0625));
            RenderUtil.renderColoredModel(SpecialModels.TOW_BAR.getModel(), ItemCameraTransforms.TransformType.NONE, false, -1);
            GlStateManager.popMatrix();
        }
        GlStateManager.translated((double)bodyPosition.getX(), (double)bodyPosition.getY(), (double)bodyPosition.getZ());
        GlStateManager.scaled((double)bodyPosition.getScale(), (double)bodyPosition.getScale(), (double)bodyPosition.getScale());
        GlStateManager.translated((double)0.0, (double)0.5, (double)0.0);
        GlStateManager.translated((double)0.0, (double)((double)properties.getAxleOffset() * 0.0625), (double)0.0);
        GlStateManager.translated((double)0.0, (double)((double)properties.getWheelOffset() * 0.0625), (double)0.0);
        ((AbstractRenderVehicle)this.renderVehicle).render(entity, partialTicks);
        GlStateManager.popMatrix();
    }

    public void applyPreRotations(T entity, float partialTicks) {
    }

    protected void renderPart(@Nullable PartPosition position, IBakedModel model, int color) {
        if (position == null) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(position.getX() * 0.0625), (double)(position.getY() * 0.0625), (double)(position.getZ() * 0.0625));
        GlStateManager.translated((double)0.0, (double)-0.5, (double)0.0);
        GlStateManager.scalef((float)((float)position.getScale()), (float)((float)position.getScale()), (float)((float)position.getScale()));
        GlStateManager.translated((double)0.0, (double)0.5, (double)0.0);
        GlStateManager.rotated((double)position.getRotX(), (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.rotated((double)position.getRotY(), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)position.getRotZ(), (double)0.0, (double)0.0, (double)1.0);
        RenderUtil.renderColoredModel(model, ItemCameraTransforms.TransformType.NONE, false, color);
        GlStateManager.popMatrix();
    }

    protected void renderKey(@Nullable PartPosition position, IBakedModel model, ItemStack stack) {
        if (position == null) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(position.getX() * 0.0625), (double)(position.getY() * 0.0625), (double)(position.getZ() * 0.0625));
        GlStateManager.translated((double)0.0, (double)-0.25, (double)0.0);
        GlStateManager.scalef((float)((float)position.getScale()), (float)((float)position.getScale()), (float)((float)position.getScale()));
        GlStateManager.rotated((double)position.getRotX(), (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.rotated((double)position.getRotY(), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)position.getRotZ(), (double)0.0, (double)0.0, (double)1.0);
        GlStateManager.translated((double)0.0, (double)0.0, (double)-0.05);
        RenderUtil.renderModel(model, ItemCameraTransforms.TransformType.NONE, false, stack);
        GlStateManager.popMatrix();
    }

    protected void renderEngine(PoweredVehicleEntity entity, @Nullable PartPosition position, IBakedModel model) {
        GlStateManager.pushMatrix();
        if (entity.isEnginePowered()) {
            GlStateManager.rotatef((float)(0.5f * (float)(entity.field_70173_aa % 2)), (float)1.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)(-0.5f * (float)(entity.field_70173_aa % 2)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.renderPart(position, model, -1);
        GlStateManager.popMatrix();
    }
}

