/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.tileentity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.block.BlockGasPump;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.util.HermiteInterpolator;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.tileentity.GasPumpTileEntity;
import com.mrcrayfish.vehicle.util.CollisionHelper;
import com.mrcrayfish.vehicle.util.RenderUtil;
import javax.vecmath.Matrix4d;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class GasPumpRenderer
extends TileEntityRenderer<GasPumpTileEntity> {
    public void render(GasPumpTileEntity gasPump, double x, double y, double z, float partialTicks, int destroyStage) {
        BlockPos blockPos = gasPump.func_174877_v();
        BlockState state = gasPump.func_145831_w().func_180495_p(blockPos);
        if (state.func_177230_c() != ModBlocks.GAS_PUMP.get()) {
            return;
        }
        boolean top = (Boolean)state.func_177229_b((IProperty)BlockGasPump.TOP);
        if (!top) {
            return;
        }
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockGasPump.DIRECTION);
        double[] pos = CollisionHelper.fixRotation(facing, 0.640625, 1.078125, 0.640625, 1.078125);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        if (gasPump.getFuelingEntity() != null) {
            String skinType;
            gasPump.setRecentlyUsed(true);
            PlayerEntity entity = gasPump.getFuelingEntity();
            double playerX = (double)blockPos.func_177958_n() - (entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks);
            double playerY = (double)blockPos.func_177956_o() - (entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks);
            double playerZ = (double)blockPos.func_177952_p() - (entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks);
            double side = entity.func_184591_cq() == HandSide.RIGHT ? 1.0 : -1.0;
            float renderYawOffset = entity.field_70760_ar + (entity.field_70761_aq - entity.field_70760_ar) * partialTicks;
            Vec3d lookVec = Vec3d.func_189986_a((float)-20.0f, (float)renderYawOffset);
            Vec3d hoseVec = new Vec3d(-0.35 * side, -0.025, -0.025);
            if (entity instanceof AbstractClientPlayerEntity && (skinType = ((AbstractClientPlayerEntity)entity).func_175154_l()).equals("slim")) {
                hoseVec = hoseVec.func_72441_c(0.03 * side, -0.03, 0.0);
            }
            hoseVec = hoseVec.func_178785_b(-renderYawOffset * ((float)Math.PI / 180));
            if (entity.equals((Object)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                lookVec = Vec3d.func_189986_a((float)0.0f, (float)entity.field_70177_z);
                hoseVec = new Vec3d(-0.25, 0.5, -0.25).func_178785_b(-entity.field_70177_z * ((float)Math.PI / 180));
            }
            HermiteInterpolator.Point destPoint = new HermiteInterpolator.Point(new Vec3d(-playerX + hoseVec.field_72450_a, -playerY + 0.8 + hoseVec.field_72448_b, -playerZ + hoseVec.field_72449_c), new Vec3d(lookVec.field_72450_a * 3.0, lookVec.field_72448_b * 3.0, lookVec.field_72449_c * 3.0));
            gasPump.setCachedSpline(new HermiteInterpolator(new HermiteInterpolator.Point(new Vec3d(pos[0], 0.6425, pos[1]), new Vec3d(0.0, -5.0, 0.0)), destPoint));
        } else if (gasPump.getCachedSpline() == null || gasPump.isRecentlyUsed()) {
            gasPump.setRecentlyUsed(false);
            double[] destPos = CollisionHelper.fixRotation(facing, 0.345, 1.06, 0.345, 1.06);
            HermiteInterpolator.Point destPoint = new HermiteInterpolator.Point(new Vec3d(destPos[0], 0.1, destPos[1]), new Vec3d(0.0, 3.0, 0.0));
            gasPump.setCachedSpline(new HermiteInterpolator(new HermiteInterpolator.Point(new Vec3d(pos[0], 0.6425, pos[1]), new Vec3d(0.0, -5.0, 0.0)), destPoint));
        }
        HermiteInterpolator spline = gasPump.getCachedSpline();
        if (spline != null) {
            float gray;
            float red = gray = 0.1f;
            float hoseDiameter = 0.07f;
            if (gasPump.getFuelingEntity() != null) {
                red = (float)(Math.sqrt(gasPump.getFuelingEntity().func_70092_e((double)gasPump.func_174877_v().func_177958_n() + 0.5, (double)gasPump.func_174877_v().func_177956_o() + 0.5, (double)gasPump.func_174877_v().func_177952_p() + 0.5)) / (Double)Config.SERVER.maxHoseDistance.get());
                red = red * red * red * red * red * red;
                red = Math.max(red, gray);
            }
            GlStateManager.lineWidth((float)((float)Minecraft.func_71410_x().field_195558_d.func_198109_k() / 1920.0f * 1.0f));
            GlStateManager.disableTexture();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            int segments = (Integer)Config.CLIENT.hoseSegments.get();
            for (int i = 0; i < spline.getSize() - 1; ++i) {
                for (int j = 0; j < segments; ++j) {
                    float percent = (float)j / (float)segments;
                    HermiteInterpolator.Result start = spline.get(i, percent);
                    HermiteInterpolator.Result end = spline.get(i, (float)(j + 1) / (float)segments);
                    Matrix4d startMatrix = new Matrix4d();
                    startMatrix.setIdentity();
                    EntityRaytracer.MatrixTransformation.createTranslation(start.getPoint().field_72450_a, start.getPoint().field_72448_b, start.getPoint().field_72449_c).transform(startMatrix);
                    if (i == 0 && j == 0) {
                        EntityRaytracer.MatrixTransformation.createRotation(Math.toDegrees(Math.atan2(end.getDir().field_72450_a, end.getDir().field_72449_c)), 0.0, 1.0, 0.0).transform(startMatrix);
                        EntityRaytracer.MatrixTransformation.createRotation(Math.toDegrees(Math.asin(-end.getDir().func_72432_b().field_72448_b)), 1.0, 0.0, 0.0).transform(startMatrix);
                    } else {
                        EntityRaytracer.MatrixTransformation.createRotation(Math.toDegrees(Math.atan2(start.getDir().field_72450_a, start.getDir().field_72449_c)), 0.0, 1.0, 0.0).transform(startMatrix);
                        EntityRaytracer.MatrixTransformation.createRotation(Math.toDegrees(Math.asin(-start.getDir().func_72432_b().field_72448_b)), 1.0, 0.0, 0.0).transform(startMatrix);
                    }
                    Matrix4d endMatrix = new Matrix4d();
                    endMatrix.setIdentity();
                    EntityRaytracer.MatrixTransformation.createTranslation(end.getPoint().field_72450_a, end.getPoint().field_72448_b, end.getPoint().field_72449_c).transform(endMatrix);
                    if (i == spline.getSize() - 2 && j == segments - 1) {
                        EntityRaytracer.MatrixTransformation.createRotation(Math.toDegrees(Math.atan2(start.getDir().field_72450_a, start.getDir().field_72449_c)), 0.0, 1.0, 0.0).transform(endMatrix);
                        EntityRaytracer.MatrixTransformation.createRotation(Math.toDegrees(Math.asin(-start.getDir().func_72432_b().field_72448_b)), 1.0, 0.0, 0.0).transform(endMatrix);
                    } else {
                        EntityRaytracer.MatrixTransformation.createRotation(Math.toDegrees(Math.atan2(end.getDir().field_72450_a, end.getDir().field_72449_c)), 0.0, 1.0, 0.0).transform(endMatrix);
                        EntityRaytracer.MatrixTransformation.createRotation(Math.toDegrees(Math.asin(-end.getDir().func_72432_b().field_72448_b)), 1.0, 0.0, 0.0).transform(endMatrix);
                    }
                    Matrix4d startTemp = new Matrix4d(startMatrix);
                    Matrix4d endTemp = new Matrix4d(endMatrix);
                    EntityRaytracer.MatrixTransformation.createTranslation(hoseDiameter / 2.0f, -hoseDiameter / 2.0f, 0.0).transform(startTemp);
                    buffer.func_181662_b(startTemp.m03, startTemp.m13, startTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(0.0, hoseDiameter, 0.0).transform(startTemp);
                    buffer.func_181662_b(startTemp.m03, startTemp.m13, startTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(hoseDiameter / 2.0f, hoseDiameter / 2.0f, 0.0).transform(endTemp);
                    buffer.func_181662_b(endTemp.m03, endTemp.m13, endTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(0.0, -hoseDiameter, 0.0).transform(endTemp);
                    buffer.func_181662_b(endTemp.m03, endTemp.m13, endTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    buffer.func_181662_b(endTemp.m03, endTemp.m13, endTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(-hoseDiameter, 0.0, 0.0).transform(endTemp);
                    buffer.func_181662_b(endTemp.m03, endTemp.m13, endTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(-hoseDiameter, -hoseDiameter, 0.0).transform(startTemp);
                    buffer.func_181662_b(startTemp.m03, startTemp.m13, startTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(hoseDiameter, 0.0, 0.0).transform(startTemp);
                    buffer.func_181662_b(startTemp.m03, startTemp.m13, startTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(-hoseDiameter, 0.0, 0.0).transform(startTemp);
                    buffer.func_181662_b(startTemp.m03, startTemp.m13, startTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(0.0, 0.0, 0.0).transform(endTemp);
                    buffer.func_181662_b(endTemp.m03, endTemp.m13, endTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(0.0, hoseDiameter, 0.0).transform(endTemp);
                    buffer.func_181662_b(endTemp.m03, endTemp.m13, endTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(0.0, hoseDiameter, 0.0).transform(startTemp);
                    buffer.func_181662_b(startTemp.m03, startTemp.m13, startTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(hoseDiameter, 0.0, 0.0).transform(startTemp);
                    buffer.func_181662_b(startTemp.m03, startTemp.m13, startTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(-hoseDiameter, 0.0, 0.0).transform(startTemp);
                    buffer.func_181662_b(startTemp.m03, startTemp.m13, startTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(0.0, 0.0, 0.0).transform(endTemp);
                    buffer.func_181662_b(endTemp.m03, endTemp.m13, endTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                    EntityRaytracer.MatrixTransformation.createTranslation(hoseDiameter, 0.0, 0.0).transform(endTemp);
                    buffer.func_181662_b(endTemp.m03, endTemp.m13, endTemp.m23).func_181666_a(red, gray, gray, 1.0f).func_181675_d();
                }
            }
            tessellator.func_78381_a();
            GlStateManager.enableTexture();
        }
        if (gasPump.getFuelingEntity() == null) {
            GlStateManager.pushMatrix();
            double[] destPos = CollisionHelper.fixRotation(facing, 0.29, 1.06, 0.29, 1.06);
            GlStateManager.translated((double)destPos[0], (double)0.5, (double)destPos[1]);
            GlStateManager.rotatef((float)((float)facing.func_176736_b() * -90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)0.8f, (float)0.8f, (float)0.8f);
            RenderUtil.renderColoredModel(SpecialModels.NOZZLE.getModel(), ItemCameraTransforms.TransformType.NONE, false, -1);
            GlStateManager.popMatrix();
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.5, (double)0.0, (double)0.5);
        GlStateManager.rotatef((float)((float)facing.func_176736_b() * -90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translated((double)-0.5, (double)0.0, (double)-0.5);
        GlStateManager.translated((double)0.5, (double)0.6875, (double)0.1875);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translated((double)0.0, (double)0.0, (double)0.01f);
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)0.015f, (float)-0.015f, (float)0.015f);
        FontRenderer fontRenderer = this.field_147501_a.field_147557_n;
        if (gasPump.getTank() != null) {
            int amount = (int)Math.ceil(100.0 * ((double)gasPump.getTank().getFluidAmount() / (double)gasPump.getTank().getCapacity()));
            String percent = String.format("%d%%", amount);
            int width = fontRenderer.func_78256_a(percent);
            fontRenderer.func_211126_b(percent, (float)(-width / 2), 10.0f, 0xFFFFFF);
        }
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)0.0625, (double)0.0);
        GlStateManager.scalef((float)0.01f, (float)-0.01f, (float)0.01f);
        fontRenderer = this.field_147501_a.field_147557_n;
        int width = fontRenderer.func_78256_a("Fuelium");
        fontRenderer.func_211126_b("Fuelium", (float)(-width / 2), 10.0f, 9761325);
        GlStateManager.popMatrix();
        GlStateManager.popMatrix();
        GlStateManager.popMatrix();
    }
}

