/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.tileentity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.tileentity.VehicleCrateTileEntity;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import org.apache.commons.lang3.tuple.Pair;

public class VehicleCrateRenderer
extends TileEntityRenderer<VehicleCrateTileEntity> {
    public void render(VehicleCrateTileEntity crate, double x, double y, double z, float partialTicks, int destroyStage) {
        BlockState state = crate.func_145831_w().func_180495_p(crate.func_174877_v());
        if (state.func_177230_c() != ModBlocks.VEHICLE_CRATE.get()) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockRotatedObject.DIRECTION);
        GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.rotatef((float)((float)facing.func_176736_b() * -90.0f + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translated((double)-0.5, (double)-0.5, (double)-0.5);
        this.field_147501_a.field_147553_e.func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.pushMatrix();
        if (crate.isOpened() && crate.getTimer() > 150) {
            double progress = Math.min(1.0, (double)Math.max(0.0f, (float)(crate.getTimer() - 150) + 5.0f * partialTicks) / 50.0);
            GlStateManager.translated((double)0.0, (double)(-0.25 * progress), (double)0.0);
        }
        for (int i = 0; i < 4; ++i) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)0.5, (double)0.0, (double)0.5);
            GlStateManager.rotatef((float)(90.0f * (float)i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translated((double)0.0, (double)0.0, (double)0.5);
            if (crate.isOpened()) {
                double progress = Math.min(1.0, (double)Math.max(0.0f, (float)(crate.getTimer() - i * 20) + 5.0f * partialTicks) / 90.0);
                double angle = progress * progress * 90.0;
                double rotation = 1.0 - Math.cos(Math.toRadians(angle));
                GlStateManager.rotated((double)(rotation * 90.0), (double)1.0, (double)0.0, (double)0.0);
            }
            GlStateManager.translated((double)0.0, (double)0.5, (double)0.0);
            GlStateManager.translated((double)0.0, (double)0.0, (double)-0.125);
            RenderUtil.renderColoredModel(SpecialModels.VEHICLE_CRATE.getModel(), ItemCameraTransforms.TransformType.NONE, false, -1);
            GlStateManager.popMatrix();
        }
        if (!crate.isOpened()) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)1.005f, (float)1.005f, (float)1.005f);
            GlStateManager.translated((double)0.0, (double)0.0, (double)0.37424999999999997);
            RenderUtil.renderColoredModel(SpecialModels.VEHICLE_CRATE.getModel(), ItemCameraTransforms.TransformType.NONE, false, -1);
            GlStateManager.popMatrix();
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scalef((float)1.001f, (float)1.001f, (float)1.001f);
        GlStateManager.translated((double)0.0, (double)0.0, (double)0.37424999999999997);
        RenderUtil.renderColoredModel(SpecialModels.VEHICLE_CRATE.getModel(), ItemCameraTransforms.TransformType.NONE, false, -1);
        GlStateManager.popMatrix();
        GlStateManager.popMatrix();
        if (crate.getEntity() != null && crate.isOpened()) {
            GlStateManager.translated((double)0.5, (double)0.0, (double)0.5);
            double progress = Math.min(1.0, (double)Math.max(0.0f, (float)(crate.getTimer() - 150) + 5.0f * partialTicks) / 100.0);
            Pair<Float, Float> scaleAndOffset = EntityRaytracer.getCrateScaleAndOffset(crate.getEntity().getClass());
            float scaleStart = ((Float)scaleAndOffset.getLeft()).floatValue();
            float scale = scaleStart + (1.0f - scaleStart) * (float)progress;
            GlStateManager.translated((double)0.0, (double)0.0, (double)((double)((Float)scaleAndOffset.getRight()).floatValue() * (1.0 - progress) * (double)scale));
            if (crate.getTimer() >= 150) {
                GlStateManager.translated((double)0.0, (double)(Math.sin(Math.PI * progress) * 5.0), (double)0.0);
                GlStateManager.rotated((double)(720.0 * progress), (double)0.0, (double)1.0, (double)0.0);
            }
            GlStateManager.translated((double)0.0, (double)(0.125 * (1.0 - progress)), (double)0.0);
            GlStateManager.scalef((float)scale, (float)scale, (float)scale);
            EntityRenderer renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(crate.getEntity());
            renderer.func_76986_a(crate.getEntity(), 0.0, 0.0, 0.0, 0.0f, 0.0f);
        }
        GlStateManager.popMatrix();
    }
}

