/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.vehicle.DuneBuggyEntity;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.player.PlayerEntity;

public class RenderDuneBuggy
extends AbstractRenderVehicle<DuneBuggyEntity> {
    @Override
    public void render(DuneBuggyEntity entity, float partialTicks) {
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.DUNE_BUGGY_BODY.getModel());
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        double wheelScale = 1.0;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)0.0, (double)0.1953125);
        GlStateManager.rotatef((float)-22.5f, (float)1.0f, (float)0.0f, (float)0.0f);
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 15.0f;
        GlStateManager.rotatef((float)turnRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)22.5f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translated((double)0.0, (double)0.0, (double)-0.2);
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.DUNE_BUGGY_HANDLES.getModel());
        if (entity.hasWheels()) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)0.0, (double)-0.355, (double)0.33);
            float frontWheelSpin = entity.prevFrontWheelRotation + (entity.frontWheelRotation - entity.prevFrontWheelRotation) * partialTicks;
            if (entity.isMoving()) {
                GlStateManager.rotatef((float)(-frontWheelSpin), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.scalef((float)((float)wheelScale), (float)((float)wheelScale), (float)((float)wheelScale));
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            IBakedModel wheelModel = RenderUtil.getWheelModel(entity);
            RenderUtil.renderColoredModel(wheelModel, ItemCameraTransforms.TransformType.NONE, false, entity.getWheelColor());
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
    }

    @Override
    public void applyPlayerModel(DuneBuggyEntity entity, PlayerEntity player, PlayerModel model, float partialTicks) {
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 8.0f;
        model.field_178723_h.field_78795_f = (float)Math.toRadians(-50.0f - turnRotation);
        model.field_178724_i.field_78795_f = (float)Math.toRadians(-50.0f + turnRotation);
        model.field_178721_j.field_78795_f = (float)Math.toRadians(-65.0);
        model.field_178721_j.field_78796_g = (float)Math.toRadians(30.0);
        model.field_178722_k.field_78795_f = (float)Math.toRadians(-65.0);
        model.field_178722_k.field_78796_g = (float)Math.toRadians(-30.0);
    }
}

