/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.client.ISpecialModel;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.vehicle.MiniBusEntity;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.player.PlayerEntity;

public class RenderMiniBus
extends AbstractRenderVehicle<MiniBusEntity> {
    @Override
    public ISpecialModel getTowBarModel() {
        return SpecialModels.BIG_TOW_BAR;
    }

    @Override
    public void render(MiniBusEntity entity, float partialTicks) {
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.MINI_BUS_BODY.getModel());
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)-0.2825, (double)0.225, (double)1.0625);
        GlStateManager.rotatef((float)-67.5f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translated((double)0.0, (double)-0.02, (double)0.0);
        GlStateManager.scalef((float)0.75f, (float)0.75f, (float)0.75f);
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 25.0f;
        GlStateManager.rotatef((float)turnRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderUtil.renderColoredModel(SpecialModels.GO_KART_STEERING_WHEEL.getModel(), ItemCameraTransforms.TransformType.NONE, false, -1);
        GlStateManager.popMatrix();
    }

    @Override
    public void applyPlayerModel(MiniBusEntity entity, PlayerEntity player, PlayerModel<AbstractClientPlayerEntity> model, float partialTicks) {
        if (entity.func_184179_bs() == player) {
            float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
            float wheelAngleNormal = wheelAngle / 45.0f;
            float turnRotation = wheelAngleNormal * 6.0f;
            model.field_178723_h.field_78795_f = (float)Math.toRadians(-65.0f - turnRotation);
            model.field_178723_h.field_78796_g = (float)Math.toRadians(-7.0);
            model.field_178724_i.field_78795_f = (float)Math.toRadians(-65.0f + turnRotation);
            model.field_178724_i.field_78796_g = (float)Math.toRadians(7.0);
        }
    }
}

