/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.vehicle.SportsPlaneEntity;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.Vec3d;

public class RenderSportsPlane
extends AbstractRenderVehicle<SportsPlaneEntity> {
    @Override
    public void render(SportsPlaneEntity entity, float partialTicks) {
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.SPORTS_PLANE.getModel());
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)-0.1875, (double)0.5);
        GlStateManager.translated((double)0.5, (double)0.0, (double)0.0);
        GlStateManager.translated((double)0.375, (double)0.0, (double)0.0);
        GlStateManager.rotatef((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.SPORTS_PLANE_WING.getModel());
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)-0.1875, (double)0.5);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translated((double)0.5, (double)0.0625, (double)0.0);
        GlStateManager.translated((double)0.375, (double)0.0, (double)0.0);
        GlStateManager.rotatef((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.SPORTS_PLANE_WING.getModel());
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)-0.5, (double)0.0);
        GlStateManager.scalef((float)0.85f, (float)0.85f, (float)0.85f);
        this.renderWheel(entity, 0.0f, -0.1875f, 1.5f, 0.0f, partialTicks);
        this.renderWheel(entity, 0.46875f, -0.1875f, 0.125f, 100.0f, partialTicks);
        this.renderWheel(entity, -0.46875f, -0.1875f, 0.125f, -100.0f, partialTicks);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        float propellerRotation = entity.prevPropellerRotation + (entity.propellerRotation - entity.prevPropellerRotation) * partialTicks;
        GlStateManager.translated((double)0.0, (double)-0.09375, (double)1.3875);
        GlStateManager.rotatef((float)propellerRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.SPORTS_PLANE_PROPELLER.getModel());
        GlStateManager.popMatrix();
    }

    private void renderWheel(SportsPlaneEntity vehicle, float offsetX, float offsetY, float offsetZ, float legRotation, float partialTicks) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)offsetX, (double)offsetY, (double)offsetZ);
        this.renderDamagedPart((VehicleEntity)vehicle, SpecialModels.SPORTS_PLANE_WHEEL_COVER.getModel());
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)-0.140625, (double)0.0);
        GlStateManager.pushMatrix();
        if (vehicle.isMoving()) {
            float wheelRotation = vehicle.prevWheelRotation + (vehicle.wheelRotation - vehicle.prevWheelRotation) * partialTicks;
            GlStateManager.rotatef((float)(-wheelRotation), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.scalef((float)0.8f, (float)0.8f, (float)0.8f);
        RenderUtil.renderColoredModel(RenderUtil.getModel(new ItemStack((IItemProvider)ModItems.STANDARD_WHEEL.get())), ItemCameraTransforms.TransformType.NONE, false, -1);
        GlStateManager.popMatrix();
        GlStateManager.popMatrix();
        GlStateManager.rotatef((float)legRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderDamagedPart((VehicleEntity)vehicle, SpecialModels.SPORTS_PLANE_LEG.getModel());
        GlStateManager.popMatrix();
    }

    @Override
    public void applyPlayerModel(SportsPlaneEntity entity, PlayerEntity player, PlayerModel model, float partialTicks) {
        model.field_178721_j.field_78795_f = (float)Math.toRadians(-85.0);
        model.field_178721_j.field_78796_g = (float)Math.toRadians(10.0);
        model.field_178722_k.field_78795_f = (float)Math.toRadians(-85.0);
        model.field_178722_k.field_78796_g = (float)Math.toRadians(-10.0);
    }

    @Override
    public void applyPlayerRender(SportsPlaneEntity entity, PlayerEntity player, float partialTicks) {
        int index = entity.getSeatTracker().getSeatIndex(player.func_110124_au());
        if (index != -1) {
            VehicleProperties properties = entity.getProperties();
            Seat seat = properties.getSeats().get(index);
            Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale()).func_186678_a(0.0625);
            double scale = 1.0666666666666667;
            double offsetX = seatVec.field_72450_a * scale;
            double offsetY = (seatVec.field_72448_b + player.func_70033_W() - 0.5) * scale + 1.5;
            double offsetZ = seatVec.field_72449_c * scale;
            GlStateManager.translated((double)offsetX, (double)offsetY, (double)offsetZ);
            float bodyPitch = entity.prevBodyRotationX + (entity.bodyRotationX - entity.prevBodyRotationX) * partialTicks;
            float bodyRoll = entity.prevBodyRotationZ + (entity.bodyRotationZ - entity.prevBodyRotationZ) * partialTicks;
            GlStateManager.rotatef((float)bodyRoll, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)(-bodyPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translated((double)(-offsetX), (double)(-offsetY), (double)(-offsetX));
        }
    }
}

