/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.crafting.FluidEntry;
import com.mrcrayfish.vehicle.inventory.container.FluidExtractorContainer;
import com.mrcrayfish.vehicle.tileentity.FluidExtractorTileEntity;
import com.mrcrayfish.vehicle.util.FluidUtils;
import com.mrcrayfish.vehicle.util.RenderUtil;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class FluidExtractorScreen
extends ContainerScreen<FluidExtractorContainer> {
    private static final ResourceLocation GUI = new ResourceLocation("vehicle:textures/gui/fluid_extractor.png");
    private PlayerInventory playerInventory;
    private FluidExtractorTileEntity fluidExtractorTileEntity;

    public FluidExtractorScreen(FluidExtractorContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.fluidExtractorTileEntity = container.getFluidExtractor();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        if (this.fluidExtractorTileEntity.getFluidStackTank() != null) {
            FluidStack stack = this.fluidExtractorTileEntity.getFluidStackTank();
            if (this.isMouseWithinRegion(startX + 127, startY + 14, 16, 59, mouseX, mouseY)) {
                if (stack.getAmount() > 0) {
                    this.renderTooltip(Arrays.asList(stack.getDisplayName().func_150254_d(), TextFormatting.GRAY.toString() + this.fluidExtractorTileEntity.getFluidLevel() + "/" + this.fluidExtractorTileEntity.getCapacity() + " mB"), mouseX, mouseY);
                } else {
                    this.renderTooltip(Collections.singletonList("No Fluid"), mouseX, mouseY);
                }
            }
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.fluidExtractorTileEntity.func_145748_c_().func_150254_d();
        this.minecraft.field_71466_p.func_211126_b(s, 8.0f, 6.0f, 0x404040);
        this.minecraft.field_71466_p.func_211126_b(this.playerInventory.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        this.minecraft.func_110434_K().func_110577_a(GUI);
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.fluidExtractorTileEntity.getRemainingFuel() >= 0) {
            int remainingFuel = (int)(14.0 * ((double)this.fluidExtractorTileEntity.getRemainingFuel() / (double)this.fluidExtractorTileEntity.getFuelMaxProgress()));
            this.blit(startX + 64, startY + 53 + 14 - remainingFuel, 176, 14 - remainingFuel, 14, remainingFuel + 1);
        }
        if (this.fluidExtractorTileEntity.canExtract()) {
            int left = startX + 93 + 1;
            int top = startY + 34;
            int right = left + 23 - 1;
            int bottom = top + 16;
            FluidEntry fluidExtract = this.fluidExtractorTileEntity.getCurrentRecipe().getResult();
            int fluidColor = -1;
            if (fluidExtract != null) {
                fluidColor = 0xFF000000 | FluidUtils.getAverageFluidColor(fluidExtract.getFluid());
            }
            RenderUtil.drawGradientRectHorizontal(left, top, right, bottom, -1, fluidColor);
            this.blit(startX + 93, startY + 34, 176, 14, 23, 16);
            double extractionPercentage = (double)this.fluidExtractorTileEntity.getExtractionProgress() / (double)((Integer)Config.SERVER.extractorExtractTime.get()).intValue();
            int extractionProgress = (int)(22.0 * extractionPercentage + 1.0);
            this.blit(startX + 93 + extractionProgress, startY + 34, 93 + extractionProgress, 34, 23 - extractionProgress, 17);
        }
        this.drawFluidTank(this.fluidExtractorTileEntity.getFluidStackTank(), startX + 127, startY + 14, (double)this.fluidExtractorTileEntity.getFluidLevel() / (double)this.fluidExtractorTileEntity.getCapacity(), 59);
    }

    private void drawFluidTank(FluidStack fluid, int x, int y, double level, int height) {
        FluidUtils.drawFluidTankInGUI(fluid, x, y, level, height);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI);
        this.blit(x, y, 176, 44, 16, 59);
    }

    private boolean isMouseWithinRegion(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }
}

