/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.client.screen.CheckBox;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.crafting.RecipeType;
import com.mrcrayfish.vehicle.crafting.VehicleRecipe;
import com.mrcrayfish.vehicle.crafting.VehicleRecipes;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.inventory.container.WorkstationContainer;
import com.mrcrayfish.vehicle.item.EngineItem;
import com.mrcrayfish.vehicle.item.WheelItem;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageCraftVehicle;
import com.mrcrayfish.vehicle.tileentity.WorkstationTileEntity;
import com.mrcrayfish.vehicle.util.CommonUtils;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class WorkstationScreen
extends ContainerScreen<WorkstationContainer> {
    private static final ResourceLocation GUI = new ResourceLocation("vehicle:textures/gui/workstation.png");
    private List<EntityType<?>> vehicleTypes;
    private List<MaterialItem> materials;
    private List<MaterialItem> filteredMaterials;
    private static int currentVehicle = 0;
    private static int prevCurrentVehicle = 0;
    private static boolean showRemaining = false;
    private VehicleEntity[] cachedVehicle;
    private PlayerInventory playerInventory;
    private WorkstationTileEntity workstation;
    private Button btnCraft;
    private CheckBox checkBoxMaterials;
    private boolean validEngine;
    private boolean transitioning;
    private int vehicleScale = 30;
    private int prevVehicleScale = 30;

    public WorkstationScreen(WorkstationContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.workstation = container.getTileEntity();
        this.field_146999_f = 289;
        this.field_147000_g = 202;
        this.materials = new ArrayList<MaterialItem>();
        this.vehicleTypes = this.getVehicleTypes(playerInventory.field_70458_d.field_70170_p);
        this.vehicleTypes.sort(Comparator.comparing(type -> type.getRegistryName().func_110623_a()));
        this.cachedVehicle = new VehicleEntity[this.vehicleTypes.size()];
    }

    private List<EntityType<?>> getVehicleTypes(World world) {
        return world.func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g() == RecipeType.CRAFTING).map(recipe -> (VehicleRecipe)recipe).map(VehicleRecipe::getVehicle).collect(Collectors.toList());
    }

    public void init() {
        super.init();
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        this.addButton((Widget)new Button(startX, startY, 15, 20, "<", button -> {
            if (currentVehicle - 1 < 0) {
                this.loadVehicle(this.vehicleTypes.size() - 1);
            } else {
                this.loadVehicle(currentVehicle - 1);
            }
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }));
        this.addButton((Widget)new Button(startX + 161, startY, 15, 20, ">", button -> {
            if (currentVehicle + 1 >= this.vehicleTypes.size()) {
                this.loadVehicle(0);
            } else {
                this.loadVehicle(currentVehicle + 1);
            }
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }));
        this.btnCraft = (Button)this.addButton((Widget)new Button(startX + 186, startY + 6, 97, 20, "Craft", button -> {
            ResourceLocation registryName = this.cachedVehicle[currentVehicle].func_200600_R().getRegistryName();
            if (registryName != null) {
                PacketHandler.instance.sendToServer((Object)new MessageCraftVehicle(registryName.toString(), this.workstation.func_174877_v()));
            }
        }));
        this.btnCraft.active = false;
        this.checkBoxMaterials = (CheckBox)this.addButton(new CheckBox(startX + 186, startY + 51, "Show Remaining"));
        this.checkBoxMaterials.setToggled(showRemaining);
        this.loadVehicle(currentVehicle);
    }

    public void tick() {
        super.tick();
        this.validEngine = true;
        for (MaterialItem materialItem : this.materials) {
            materialItem.update();
        }
        boolean canCraft = true;
        for (MaterialItem material : this.materials) {
            if (material.isEnabled()) continue;
            canCraft = false;
            break;
        }
        if (this.cachedVehicle[currentVehicle] instanceof PoweredVehicleEntity) {
            PoweredVehicleEntity poweredVehicleEntity = (PoweredVehicleEntity)this.cachedVehicle[currentVehicle];
            if (poweredVehicleEntity.getEngineType() != EngineType.NONE) {
                ItemStack engine = this.workstation.func_70301_a(1);
                if (!engine.func_190926_b() && engine.func_77973_b() instanceof EngineItem) {
                    EngineItem engineItem = (EngineItem)engine.func_77973_b();
                    EngineType engineType = engineItem.getEngineType();
                    if (poweredVehicleEntity.getEngineType() != engineType) {
                        canCraft = false;
                        this.validEngine = false;
                        poweredVehicleEntity.setEngine(false);
                    } else {
                        poweredVehicleEntity.setEngineTier(engineItem.getEngineTier());
                        poweredVehicleEntity.setEngine(true);
                        poweredVehicleEntity.func_184206_a(PoweredVehicleEntity.ENGINE_TIER);
                    }
                } else {
                    canCraft = false;
                    this.validEngine = false;
                    poweredVehicleEntity.setEngine(false);
                }
            }
            if (poweredVehicleEntity.canChangeWheels()) {
                ItemStack wheels = this.workstation.func_70301_a(2);
                if (!wheels.func_190926_b() && wheels.func_77973_b() instanceof WheelItem) {
                    CompoundNBT tagCompound;
                    if (wheels.func_77978_p() != null && (tagCompound = wheels.func_77978_p()).func_150297_b("Color", 3)) {
                        poweredVehicleEntity.setWheelColor(tagCompound.func_74762_e("Color"));
                    }
                    WheelItem wheelItem = (WheelItem)wheels.func_77973_b();
                    poweredVehicleEntity.setWheelType(wheelItem.getWheelType());
                    poweredVehicleEntity.setWheels(true);
                    poweredVehicleEntity.func_184206_a(PoweredVehicleEntity.WHEEL_COLOR);
                } else {
                    poweredVehicleEntity.setWheels(false);
                    canCraft = false;
                }
            }
        }
        this.btnCraft.active = canCraft;
        this.prevVehicleScale = this.vehicleScale;
        if (this.transitioning) {
            if (this.vehicleScale > 0) {
                this.vehicleScale = Math.max(0, this.vehicleScale - 6);
            } else {
                this.transitioning = false;
            }
        } else if (this.vehicleScale < 30) {
            this.vehicleScale = Math.min(30, this.vehicleScale + 6);
        }
        if (this.cachedVehicle[currentVehicle].canBeColored()) {
            if (!this.workstation.func_70301_a(0).func_190926_b()) {
                ItemStack itemStack = this.workstation.func_70301_a(0);
                if (itemStack.func_77973_b() instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)itemStack.func_77973_b();
                    this.cachedVehicle[currentVehicle].setColor(dyeItem.func_195962_g().getColorValue());
                } else {
                    this.cachedVehicle[currentVehicle].setColor(VehicleEntity.DYE_TO_COLOR[0]);
                }
            } else {
                this.cachedVehicle[currentVehicle].setColor(VehicleEntity.DYE_TO_COLOR[0]);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean result = super.mouseClicked(mouseX, mouseY, mouseButton);
        showRemaining = this.checkBoxMaterials.isToggled();
        return result;
    }

    private void loadVehicle(int index) {
        prevCurrentVehicle = currentVehicle;
        if (this.cachedVehicle[index] == null) {
            VehicleEntity vehicle = (VehicleEntity)this.vehicleTypes.get(index).func_200721_a((World)this.minecraft.field_71441_e);
            List entryList = vehicle.func_184212_Q().func_187231_c();
            if (entryList != null) {
                entryList.forEach(dataEntry -> vehicle.func_184206_a(dataEntry.func_187205_a()));
            }
            if (vehicle instanceof PoweredVehicleEntity) {
                ((PoweredVehicleEntity)vehicle).setEngine(false);
                ((PoweredVehicleEntity)vehicle).setWheels(false);
            }
            this.cachedVehicle[index] = vehicle;
        }
        this.materials.clear();
        VehicleRecipe recipe = VehicleRecipes.getRecipe(this.cachedVehicle[index].func_200600_R(), (World)this.minecraft.field_71441_e);
        if (recipe != null) {
            for (int i = 0; i < recipe.getMaterials().size(); ++i) {
                MaterialItem item = new MaterialItem(((ItemStack)recipe.getMaterials().get(i)).func_77946_l());
                item.update();
                this.materials.add(item);
            }
        }
        currentVehicle = index;
        if (((Boolean)Config.CLIENT.workstationAnimation.get()).booleanValue() && prevCurrentVehicle != currentVehicle) {
            this.transitioning = true;
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        for (int i = 0; i < this.filteredMaterials.size(); ++i) {
            MaterialItem materialItem;
            int itemX = startX + 186;
            int itemY = startY + i * 19 + 6 + 57;
            if (!CommonUtils.isMouseWithin(mouseX, mouseY, itemX, itemY, 80, 19) || (materialItem = this.filteredMaterials.get(i)).getStack().func_190926_b()) continue;
            this.renderTooltip(materialItem.getStack(), mouseX, mouseY);
        }
        VehicleEntity vehicle = this.cachedVehicle[currentVehicle];
        if (vehicle.canBeColored()) {
            this.drawSlotTooltip(Lists.newArrayList((Object[])new String[]{TextFormatting.AQUA + I18n.func_135052_a((String)"vehicle.tooltip.optional", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"vehicle.tooltip.paint_color", (Object[])new Object[0])}), startX, startY, 186, 29, mouseX, mouseY, 0);
        } else {
            this.drawSlotTooltip(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"vehicle.tooltip.paint_color", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"vehicle.tooltip.not_applicable", (Object[])new Object[0])}), startX, startY, 186, 29, mouseX, mouseY, 0);
        }
        if (vehicle instanceof PoweredVehicleEntity && ((PoweredVehicleEntity)vehicle).getEngineType() != EngineType.NONE) {
            String engineName = ((PoweredVehicleEntity)vehicle).getEngineType().getEngineName();
            this.drawSlotTooltip(Lists.newArrayList((Object[])new String[]{TextFormatting.RED + I18n.func_135052_a((String)"vehicle.tooltip.required", (Object[])new Object[0]), TextFormatting.GRAY + engineName}), startX, startY, 206, 29, mouseX, mouseY, 1);
        } else {
            this.drawSlotTooltip(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"vehicle.tooltip.engine", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"vehicle.tooltip.not_applicable", (Object[])new Object[0])}), startX, startY, 206, 29, mouseX, mouseY, 1);
        }
        if (vehicle instanceof PoweredVehicleEntity && ((PoweredVehicleEntity)vehicle).canChangeWheels()) {
            this.drawSlotTooltip(Lists.newArrayList((Object[])new String[]{TextFormatting.RED + I18n.func_135052_a((String)"vehicle.tooltip.required", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"vehicle.tooltip.wheels", (Object[])new Object[0])}), startX, startY, 226, 29, mouseX, mouseY, 2);
        } else {
            this.drawSlotTooltip(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"vehicle.tooltip.wheels", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"vehicle.tooltip.not_applicable", (Object[])new Object[0])}), startX, startY, 226, 29, mouseX, mouseY, 2);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        partialTicks = this.minecraft.func_184121_ak();
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        GlStateManager.enableBlend();
        this.minecraft.func_110434_K().func_110577_a(GUI);
        this.blit(startX, startY + 80, 0, 134, 176, 122);
        this.blit(startX + 180, startY, 176, 54, 6, 202);
        this.blit(startX + 186, startY, 182, 54, 57, 202);
        this.blit(startX + 186 + 57, startY, 220, 54, 23, 202);
        this.blit(startX + 186 + 57 + 23, startY, 220, 54, 3, 202);
        this.blit(startX + 186 + 57 + 23 + 3, startY, 236, 54, 20, 202);
        this.drawSlot(startX, startY, 186, 29, 80, 0, 0, false, this.cachedVehicle[currentVehicle].canBeColored());
        boolean needsEngine = this.cachedVehicle[currentVehicle] instanceof PoweredVehicleEntity && ((PoweredVehicleEntity)this.cachedVehicle[currentVehicle]).getEngineType() != EngineType.NONE;
        this.drawSlot(startX, startY, 206, 29, 80, 16, 1, !this.validEngine, needsEngine);
        boolean needsWheels = this.cachedVehicle[currentVehicle] instanceof PoweredVehicleEntity && ((PoweredVehicleEntity)this.cachedVehicle[currentVehicle]).canChangeWheels();
        this.drawSlot(startX, startY, 226, 29, 80, 32, 2, needsWheels && this.workstation.func_70301_a(2).func_190926_b(), needsWheels);
        this.drawCenteredString(this.font, this.cachedVehicle[currentVehicle].func_200200_C_().func_150254_d(), startX + 88, startY + 6, Color.WHITE.getRGB());
        this.filteredMaterials = this.getMaterials();
        for (int i = 0; i < this.filteredMaterials.size(); ++i) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(GUI);
            MaterialItem materialItem = this.filteredMaterials.get(i);
            ItemStack stack = materialItem.stack;
            if (stack.func_190926_b()) {
                RenderHelper.func_74518_a();
                this.blit(startX + 186, startY + i * 19 + 6 + 57, 0, 19, 80, 19);
                continue;
            }
            RenderHelper.func_74518_a();
            if (materialItem.isEnabled()) {
                this.blit(startX + 186, startY + i * 19 + 6 + 57, 0, 0, 80, 19);
            } else {
                this.blit(startX + 186, startY + i * 19 + 6 + 57, 0, 38, 80, 19);
            }
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String name = stack.func_200301_q().func_150261_e();
            if (this.font.func_78256_a(name) > 55) {
                name = this.font.func_78269_a(stack.func_200301_q().func_150261_e(), 50).trim() + "...";
            }
            this.font.func_211126_b(name, (float)(startX + 186 + 22), (float)(startY + i * 19 + 6 + 6 + 57), Color.WHITE.getRGB());
            RenderHelper.func_74520_c();
            Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, startX + 186 + 2, startY + i * 19 + 6 + 1 + 57);
            if (this.checkBoxMaterials.isToggled()) {
                int count = InventoryUtil.getItemStackAmount((PlayerEntity)this.minecraft.field_71439_g, stack);
                stack = stack.func_77946_l();
                stack.func_190920_e(stack.func_190916_E() - count);
            }
            Minecraft.func_71410_x().func_175599_af().func_180453_a(this.font, stack, startX + 186 + 2, startY + i * 19 + 6 + 1 + 57, null);
        }
        GlStateManager.pushMatrix();
        RenderHelper.func_74520_c();
        GlStateManager.translated((double)(startX + 88), (double)(startY + 90), (double)100.0);
        float scale = (float)this.prevVehicleScale + (float)(this.vehicleScale - this.prevVehicleScale) * partialTicks;
        GlStateManager.scalef((float)scale, (float)(-scale), (float)scale);
        GlStateManager.rotatef((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        int vehicleIndex = this.transitioning ? prevCurrentVehicle : currentVehicle;
        Class<?> clazz = ((Object)((Object)this.cachedVehicle[vehicleIndex])).getClass();
        VehicleProperties properties = VehicleProperties.getProperties(this.cachedVehicle[vehicleIndex].func_200600_R());
        PartPosition position = PartPosition.DEFAULT;
        if (properties != null) {
            position = properties.getDisplayPosition();
        }
        GlStateManager.scaled((double)position.getScale(), (double)position.getScale(), (double)position.getScale());
        GlStateManager.rotatef((float)((float)position.getRotX()), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)((float)position.getRotY()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)((float)position.getRotZ()), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translated((double)position.getX(), (double)position.getY(), (double)position.getZ());
        EntityRenderer render = Minecraft.func_71410_x().func_175598_ae().func_78715_a(clazz);
        render.func_76986_a((Entity)this.cachedVehicle[vehicleIndex], 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GlStateManager.popMatrix();
    }

    private void drawSlot(int startX, int startY, int x, int y, int iconX, int iconY, int slot, boolean required, boolean applicable) {
        int textureOffset = required ? 18 : 0;
        this.blit(startX + x, startY + y, 128 + textureOffset, 0, 18, 18);
        if (this.workstation.func_70301_a(slot).func_190926_b()) {
            if (applicable) {
                this.blit(startX + x + 1, startY + y + 1, iconX + (required ? 16 : 0), iconY, 16, 16);
            } else {
                this.blit(startX + x + 1, startY + y + 1, iconX + (required ? 16 : 0), 48, 16, 16);
            }
        }
    }

    private void drawSlotTooltip(List<String> text, int startX, int startY, int x, int y, int mouseX, int mouseY, int slot) {
        if (this.workstation.func_70301_a(slot).func_190926_b() && CommonUtils.isMouseWithin(mouseX, mouseY, startX + x, startY + y, 18, 18)) {
            this.renderTooltip(text, mouseX, mouseY, this.minecraft.field_71466_p);
        }
    }

    private List<MaterialItem> getMaterials() {
        NonNullList materials = NonNullList.func_191197_a((int)7, (Object)new MaterialItem(ItemStack.field_190927_a));
        List filteredMaterials = this.materials.stream().filter(materialItem -> this.checkBoxMaterials.isToggled() ? !materialItem.isEnabled() : !((MaterialItem)materialItem).stack.func_190926_b()).collect(Collectors.toList());
        for (int i = 0; i < filteredMaterials.size() && i < materials.size(); ++i) {
            materials.set(i, filteredMaterials.get(i));
        }
        return materials;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.playerInventory.func_145748_c_().func_150254_d(), 8.0f, 109.0f, 0x404040);
    }

    public static class MaterialItem {
        public static final MaterialItem EMPTY = new MaterialItem();
        private boolean enabled = false;
        private ItemStack stack = ItemStack.field_190927_a;

        public MaterialItem() {
        }

        public MaterialItem(ItemStack stack) {
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void update() {
            if (!this.stack.func_190926_b()) {
                this.enabled = InventoryUtil.hasItemStack((PlayerEntity)Minecraft.func_71410_x().field_71439_g, this.stack);
            }
        }

        public boolean isEnabled() {
            return this.stack.func_190926_b() || this.enabled;
        }
    }
}

