/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.common.entity;

import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageSyncPlayerData;
import com.mrcrayfish.vehicle.network.message.MessageSyncPlayerGasPumpPos;
import com.mrcrayfish.vehicle.network.message.MessageSyncPlayerTrailer;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="vehicle", value={Dist.DEDICATED_SERVER})
public class SyncedPlayerData {
    private static final WeakHashMap<PlayerEntity, Holder> PLAYER_DATA_MAP = new WeakHashMap();

    private static Holder getPlayerData(PlayerEntity player) {
        return PLAYER_DATA_MAP.computeIfAbsent(player, player1 -> new Holder());
    }

    public static int getTrailer(PlayerEntity player) {
        Holder holder = SyncedPlayerData.getPlayerData(player);
        if (holder != null) {
            return holder.getTrailer();
        }
        return -1;
    }

    public static void setTrailer(PlayerEntity player, int trailer) {
        Holder holder = SyncedPlayerData.getPlayerData(player);
        if (holder != null) {
            holder.setTrailer(trailer);
        }
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new MessageSyncPlayerTrailer(player.func_145782_y(), trailer));
        }
    }

    public static Optional<BlockPos> getGasPumpPos(PlayerEntity player) {
        Holder holder = SyncedPlayerData.getPlayerData(player);
        if (holder != null) {
            return holder.getGasPumpPos();
        }
        return Optional.empty();
    }

    public static void setGasPumpPos(PlayerEntity player, Optional<BlockPos> optional) {
        Holder holder = SyncedPlayerData.getPlayerData(player);
        if (holder != null) {
            holder.setGasPumpPos(optional);
        }
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new MessageSyncPlayerGasPumpPos(player.func_145782_y(), optional));
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        PlayerEntity player;
        Holder holder;
        if (event.getTarget() instanceof PlayerEntity && (holder = SyncedPlayerData.getPlayerData(player = (PlayerEntity)event.getTarget())) != null) {
            PacketHandler.instance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new MessageSyncPlayerData(player.func_145782_y(), holder));
        }
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        PlayerEntity player;
        Holder holder;
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity && !event.getWorld().field_72995_K && (holder = SyncedPlayerData.getPlayerData(player = (PlayerEntity)entity)) != null) {
            PacketHandler.instance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageSyncPlayerData(player.func_145782_y(), holder));
        }
    }

    public static class Holder {
        private int trailer = -1;
        private Optional<BlockPos> gasPumpPos = Optional.empty();

        public void setTrailer(int id) {
            this.trailer = id;
        }

        public int getTrailer() {
            return this.trailer;
        }

        public void setGasPumpPos(Optional<BlockPos> gasPumpPos) {
            this.gasPumpPos = gasPumpPos;
        }

        public Optional<BlockPos> getGasPumpPos() {
            return this.gasPumpPos;
        }
    }
}

