/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAltitude;
import com.mrcrayfish.vehicle.network.message.MessageTravelProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class HelicopterEntity
extends PoweredVehicleEntity {
    private static final DataParameter<Integer> ALTITUDE_CHANGE = EntityDataManager.func_187226_a(HelicopterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> LIFT = EntityDataManager.func_187226_a(HelicopterEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> TRAVEL_DIRECTION = EntityDataManager.func_187226_a(HelicopterEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> TRAVEL_SPEED = EntityDataManager.func_187226_a(HelicopterEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private float lift;
    private float bladeSpeed;
    public float bladeRotation;
    public float prevBladeRotation;
    public float prevBodyRotationX;
    public float prevBodyRotationY;
    public float prevBodyRotationZ;
    public float bodyRotationX;
    public float bodyRotationY;
    public float bodyRotationZ;
    public float dirX;
    public float dirZ;

    protected HelicopterEntity(EntityType<?> entityType, World worldIn) {
        super(entityType, worldIn);
        this.setMaxSpeed(18.0f);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ALTITUDE_CHANGE, (Object)AltitudeChange.NONE.ordinal());
        this.field_70180_af.func_187214_a(LIFT, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TRAVEL_DIRECTION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TRAVEL_SPEED, (Object)Float.valueOf(0.0f));
    }

    @Override
    public SoundEvent getMovingSound() {
        return null;
    }

    @Override
    public SoundEvent getRidingSound() {
        return null;
    }

    @Override
    public void updateVehicleMotion() {
        Entity entity = this.func_184179_bs();
        if (entity != null && this.isFlying()) {
            float deltaYaw;
            for (deltaYaw = entity.func_70079_am() % 360.0f - this.field_70177_z; deltaYaw < -180.0f; deltaYaw += 360.0f) {
            }
            while (deltaYaw >= 180.0f) {
                deltaYaw -= 360.0f;
            }
            this.field_70177_z += deltaYaw * 0.15f;
        }
        float travelDirection = this.getTravelDirection();
        if (this.getAcceleration() != PoweredVehicleEntity.AccelerationDirection.NONE || this.getTurnDirection() != PoweredVehicleEntity.TurnDirection.FORWARD) {
            float newDirX = MathHelper.func_76126_a((float)(travelDirection * ((float)Math.PI / 180))) / 20.0f;
            float newDirZ = MathHelper.func_76134_b((float)(travelDirection * ((float)Math.PI / 180))) / 20.0f;
            this.dirX += (newDirX - this.dirX) * 0.05f;
            this.dirZ += (newDirZ - this.dirZ) * 0.05f;
        }
        this.vehicleMotionX = -this.currentSpeed * this.dirX;
        this.vehicleMotionZ = this.currentSpeed * this.dirZ;
        Vec3d motion = this.func_213322_ci();
        double motionY = motion.func_82617_b();
        this.updateLift();
        if (this.isFueled()) {
            motionY = this.lift * this.getBladeSpeedNormal();
            motionY -= 0.05 + (1.0 - (double)this.getBladeSpeedNormal()) * 0.45;
        } else {
            motionY -= 0.08 - 0.08 * (double)this.getBladeSpeedNormal();
        }
        this.func_213293_j(motion.func_82615_a(), motionY, motion.func_82616_c());
    }

    @Override
    protected void updateSpeed() {
        this.currentSpeed = this.getSpeed();
        EngineTier engineTier = this.getEngineTier();
        PoweredVehicleEntity.AccelerationDirection acceleration = this.getAcceleration();
        PoweredVehicleEntity.TurnDirection turnDirection = this.getTurnDirection();
        if (this.func_184179_bs() != null) {
            if (!this.isFlying()) {
                this.currentSpeed = (float)((double)this.currentSpeed * 0.75);
                return;
            }
            if (this.canDrive()) {
                if (this.getTravelSpeed() != 0.0f) {
                    float maxSpeed = this.getActualMaxSpeed() * this.getTravelSpeed();
                    if (this.currentSpeed < maxSpeed) {
                        this.currentSpeed += this.getModifiedAccelerationSpeed() * engineTier.getAccelerationMultiplier();
                        if (this.currentSpeed > maxSpeed) {
                            this.currentSpeed = maxSpeed;
                        }
                    }
                    if (this.currentSpeed > maxSpeed) {
                        this.currentSpeed *= 0.975f;
                    }
                } else {
                    this.currentSpeed = (float)((double)this.currentSpeed * 0.95);
                }
            } else {
                this.currentSpeed = (float)((double)this.currentSpeed * 0.9);
            }
        } else {
            this.currentSpeed = (float)((double)this.currentSpeed * 0.5);
        }
    }

    @Override
    public void updateVehicle() {
        this.prevBladeRotation = this.bladeRotation;
        if (this.canDrive() && this.func_184179_bs() != null) {
            this.bladeSpeed += 0.5f;
            if (this.bladeSpeed > 60.0f) {
                this.bladeSpeed = 60.0f;
            }
        } else {
            this.bladeSpeed *= 0.98f;
        }
        this.bladeRotation += this.bladeSpeed;
    }

    protected void updateLift() {
        AltitudeChange altitudeChange = this.getAltitudeChange();
        this.lift = altitudeChange == AltitudeChange.POSITIVE ? (this.lift += 0.05f) : (altitudeChange == AltitudeChange.NEGATIVE ? (this.lift -= 0.05f) : (this.lift *= 0.85f));
        this.lift = MathHelper.func_76131_a((float)this.lift, (float)-0.5f, (float)0.25f);
        this.setLift(this.lift);
    }

    @Override
    public void onClientUpdate() {
        super.onClientUpdate();
        this.prevBodyRotationX = this.bodyRotationX;
        this.prevBodyRotationY = this.bodyRotationY;
        this.prevBodyRotationZ = this.bodyRotationZ;
        Entity entity = this.func_184179_bs();
        if (entity != null && entity.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            AltitudeChange altitudeChange = VehicleMod.PROXY.getAltitudeChange();
            if (this.getAltitudeChange() != altitudeChange) {
                this.setAltitudeChange(altitudeChange);
                PacketHandler.instance.sendToServer((Object)new MessageAltitude(altitudeChange));
            }
            float travelDirection = VehicleMod.PROXY.getTravelDirection(this);
            float travelSpeed = VehicleMod.PROXY.getTravelSpeed(this);
            this.setTravelDirection(travelDirection);
            this.setTravelSpeed(travelSpeed);
            PacketHandler.instance.sendToServer((Object)new MessageTravelProperties(travelSpeed, travelDirection));
        }
        if (this.isFlying()) {
            this.bodyRotationX = this.dirX * 20.0f * 35.0f * this.getActualSpeed();
            this.bodyRotationZ = this.dirZ * 20.0f * 35.0f * this.getActualSpeed();
        } else {
            this.bodyRotationX *= 0.5f;
            this.bodyRotationZ *= 0.5f;
        }
    }

    @Override
    public void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        passenger.field_70177_z = this.field_70177_z;
    }

    @Override
    protected void updateTurning() {
    }

    public double func_70042_X() {
        return 0.0;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void setAltitudeChange(AltitudeChange altitudeChange) {
        this.field_70180_af.func_187227_b(ALTITUDE_CHANGE, (Object)altitudeChange.ordinal());
    }

    public AltitudeChange getAltitudeChange() {
        return AltitudeChange.values()[(Integer)this.field_70180_af.func_187225_a(ALTITUDE_CHANGE)];
    }

    public float getLift() {
        return ((Float)this.field_70180_af.func_187225_a(LIFT)).floatValue();
    }

    public void setLift(float lift) {
        this.field_70180_af.func_187227_b(LIFT, (Object)Float.valueOf(lift));
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    public float getBladeSpeedNormal() {
        return this.bladeSpeed / 60.0f;
    }

    @Override
    public boolean canChangeWheels() {
        return false;
    }

    public float getTravelDirection() {
        return ((Float)this.field_70180_af.func_187225_a(TRAVEL_DIRECTION)).floatValue();
    }

    public void setTravelDirection(float travelDirection) {
        this.field_70180_af.func_187227_b(TRAVEL_DIRECTION, (Object)Float.valueOf(travelDirection));
    }

    public float getTravelSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(TRAVEL_SPEED)).floatValue();
    }

    public void setTravelSpeed(float travelSpeed) {
        this.field_70180_af.func_187227_b(TRAVEL_SPEED, (Object)Float.valueOf(travelSpeed));
    }

    public static enum AltitudeChange {
        POSITIVE,
        NEGATIVE,
        NONE;


        public static AltitudeChange fromInput(boolean up, boolean down) {
            return up && !down ? POSITIVE : (down && !up ? NEGATIVE : NONE);
        }
    }
}

