/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.entity.LandVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TrailerEntity
extends VehicleEntity {
    public static final DataParameter<Integer> PULLING_ENTITY = EntityDataManager.func_187226_a(TrailerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private Entity pullingEntity;
    public float wheelRotation;
    public float prevWheelRotation;

    public TrailerEntity(EntityType<?> entityType, World worldIn) {
        super(entityType, worldIn);
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PULLING_ENTITY, (Object)-1);
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public void onUpdateVehicle() {
        this.prevWheelRotation = this.wheelRotation;
        Vec3d motion = this.func_213322_ci();
        this.func_213293_j(motion.func_82615_a(), motion.func_82617_b() - 0.08, motion.func_82616_c());
        if (this.field_70170_p.field_72995_K) {
            int entityId = (Integer)this.field_70180_af.func_187225_a(PULLING_ENTITY);
            if (entityId != -1) {
                Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(PULLING_ENTITY)).intValue());
                if (entity instanceof PlayerEntity || entity instanceof VehicleEntity && ((VehicleEntity)entity).canTowTrailer()) {
                    this.pullingEntity = entity;
                } else if (this.pullingEntity != null) {
                    this.pullingEntity = null;
                }
            } else if (this.pullingEntity != null) {
                this.pullingEntity = null;
            }
        }
        if (this.pullingEntity != null && !this.field_70170_p.field_72995_K && (double)this.pullingEntity.func_70032_d((Entity)this) > (Double)Config.SERVER.trailerDetachThreshold.get()) {
            this.field_70170_p.func_184133_a(null, this.pullingEntity.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.pullingEntity = null;
            return;
        }
        if (this.pullingEntity != null) {
            if (!this.pullingEntity.func_70089_S() || this.pullingEntity instanceof VehicleEntity && ((VehicleEntity)this.pullingEntity).getTrailer() != this) {
                this.pullingEntity = null;
                return;
            }
            this.updatePullingMotion();
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (this.field_70122_E) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.65, 0.98, 0.65));
            } else {
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.98, 0.98, 0.98));
            }
        }
        this.func_145775_I();
        float speed = (float)(Math.sqrt(Math.pow(this.field_70165_t - this.field_70169_q, 2.0) + Math.pow(this.field_70163_u - this.field_70167_r, 2.0) + Math.pow(this.field_70161_v - this.field_70166_s, 2.0)) * 20.0);
        this.wheelRotation -= 90.0f * (speed / 10.0f);
    }

    private void updatePullingMotion() {
        Vec3d towBar = this.pullingEntity.func_174791_d();
        if (this.pullingEntity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)this.pullingEntity;
            Vec3d towBarVec = vehicle.getProperties().getTowBarPosition();
            towBarVec = new Vec3d(towBarVec.field_72450_a * 0.0625, towBarVec.field_72448_b * 0.0625, towBarVec.field_72449_c * 0.0625 + vehicle.getProperties().getBodyPosition().getZ());
            if (vehicle instanceof LandVehicleEntity) {
                LandVehicleEntity landVehicle = (LandVehicleEntity)vehicle;
                towBar = towBar.func_178787_e(towBarVec.func_178785_b((float)Math.toRadians(-vehicle.field_70177_z + landVehicle.additionalYaw)));
            } else {
                towBar = towBar.func_178787_e(towBarVec.func_178785_b((float)Math.toRadians(-vehicle.field_70177_z)));
            }
        }
        this.field_70177_z = (float)Math.toDegrees(Math.atan2(towBar.field_72449_c - this.field_70161_v, towBar.field_72450_a - this.field_70165_t) - Math.toRadians(90.0));
        double deltaRot = this.field_70126_B - this.field_70177_z;
        if (deltaRot < -180.0) {
            this.field_70126_B += 360.0f;
        } else if (deltaRot >= 180.0) {
            this.field_70126_B -= 360.0f;
        }
        Vec3d vec = new Vec3d(0.0, 0.0, this.getHitchOffset() * 0.0625).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(towBar);
        Vec3d motion = this.func_213322_ci();
        this.func_213293_j(vec.field_72450_a - this.field_70165_t, motion.func_82617_b(), vec.field_72449_c - this.field_70161_v);
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public double func_70042_X() {
        return 0.0;
    }

    public boolean setPullingEntity(Entity pullingEntity) {
        if (pullingEntity instanceof PlayerEntity || pullingEntity instanceof VehicleEntity && pullingEntity.func_184187_bx() == null && ((VehicleEntity)pullingEntity).canTowTrailer()) {
            this.pullingEntity = pullingEntity;
            this.field_70180_af.func_187227_b(PULLING_ENTITY, (Object)pullingEntity.func_145782_y());
            return true;
        }
        this.pullingEntity = null;
        this.field_70180_af.func_187227_b(PULLING_ENTITY, (Object)-1);
        return false;
    }

    @Nullable
    public Entity getPullingEntity() {
        return this.pullingEntity;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 1;
    }

    @Override
    public boolean canMountTrailer() {
        return false;
    }

    public abstract double getHitchOffset();

    @Override
    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }
}

