/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.common.entity.SyncedPlayerData;
import com.mrcrayfish.vehicle.entity.TrailerEntity;
import com.mrcrayfish.vehicle.network.message.IMessage;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageAttachTrailer
implements IMessage<MessageAttachTrailer> {
    private int trailerId;
    private int entityId;

    public MessageAttachTrailer() {
    }

    public MessageAttachTrailer(int trailerId, int entityId) {
        this.trailerId = trailerId;
        this.entityId = entityId;
    }

    @Override
    public void encode(MessageAttachTrailer message, PacketBuffer buffer) {
        buffer.writeInt(message.trailerId);
        buffer.writeInt(message.entityId);
    }

    @Override
    public MessageAttachTrailer decode(PacketBuffer buffer) {
        return new MessageAttachTrailer(buffer.readInt(), buffer.readInt());
    }

    @Override
    public void handle(MessageAttachTrailer message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            World world;
            Entity trailerEntity;
            ServerPlayerEntity player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (trailerEntity = (world = player.field_70170_p).func_73045_a(message.trailerId)) instanceof TrailerEntity) {
                TrailerEntity trailer = (TrailerEntity)trailerEntity;
                Entity entity = world.func_73045_a(message.entityId);
                if (entity instanceof PlayerEntity && entity.func_184187_bx() == null && !entity.func_70093_af()) {
                    trailer.setPullingEntity(entity);
                    SyncedPlayerData.setTrailer((PlayerEntity)entity, message.trailerId);
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

