/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.common.inventory.IAttachableChest;
import com.mrcrayfish.vehicle.common.inventory.IStorage;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.network.message.IMessage;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class MessageOpenStorage
implements IMessage<MessageOpenStorage> {
    private int entityId;

    public MessageOpenStorage() {
    }

    public MessageOpenStorage(int entityId) {
        this.entityId = entityId;
    }

    @Override
    public void encode(MessageOpenStorage message, PacketBuffer buffer) {
        buffer.writeInt(message.entityId);
    }

    @Override
    public MessageOpenStorage decode(PacketBuffer buffer) {
        return new MessageOpenStorage(buffer.readInt());
    }

    @Override
    public void handle(MessageOpenStorage message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            World world;
            Entity targetEntity;
            ServerPlayerEntity player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && !player.func_70093_af() && (targetEntity = (world = player.field_70170_p).func_73045_a(message.entityId)) instanceof IStorage) {
                IStorage storage = (IStorage)targetEntity;
                float reachDistance = (float)player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
                if (player.func_70032_d(targetEntity) < reachDistance) {
                    if (targetEntity instanceof IAttachableChest) {
                        IAttachableChest attachableChest = (IAttachableChest)targetEntity;
                        if (attachableChest.hasChest()) {
                            ItemStack stack = player.field_71071_by.func_70448_g();
                            if (stack.func_77973_b() == ModItems.WRENCH.get()) {
                                ((IAttachableChest)targetEntity).removeChest();
                            } else {
                                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)storage.getStorageContainerProvider(), buffer -> buffer.func_150787_b(message.entityId));
                            }
                        }
                    } else {
                        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)storage.getStorageContainerProvider(), buffer -> buffer.func_150787_b(message.entityId));
                    }
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

