/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.common.entity.SyncedPlayerData;
import com.mrcrayfish.vehicle.network.message.IMessage;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncPlayerData
implements IMessage<MessageSyncPlayerData> {
    private int entityId;
    private int trailerId;
    private Optional<BlockPos> gasPumpPos;

    public MessageSyncPlayerData() {
    }

    public MessageSyncPlayerData(int entityId, SyncedPlayerData.Holder holder) {
        this.entityId = entityId;
        this.trailerId = holder.getTrailer();
        this.gasPumpPos = holder.getGasPumpPos();
    }

    public MessageSyncPlayerData(int entityId, int trailerId, Optional<BlockPos> gasPumpPos) {
        this.entityId = entityId;
        this.trailerId = trailerId;
        this.gasPumpPos = gasPumpPos;
    }

    @Override
    public void encode(MessageSyncPlayerData message, PacketBuffer buffer) {
        buffer.func_150787_b(message.entityId);
        buffer.func_150787_b(message.trailerId);
        buffer.writeBoolean(message.gasPumpPos.isPresent());
        message.gasPumpPos.ifPresent(arg_0 -> ((PacketBuffer)buffer).func_179255_a(arg_0));
    }

    @Override
    public MessageSyncPlayerData decode(PacketBuffer buffer) {
        int entityId = buffer.func_150792_a();
        int trailerId = buffer.func_150792_a();
        boolean present = buffer.readBoolean();
        Optional<BlockPos> gasPumpPos = present ? Optional.of(buffer.func_179259_c()) : Optional.empty();
        return new MessageSyncPlayerData(entityId, trailerId, gasPumpPos);
    }

    @Override
    public void handle(MessageSyncPlayerData message, Supplier<NetworkEvent.Context> supplier) {
        if (supplier.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            supplier.get().enqueueWork(() -> VehicleMod.PROXY.syncPlayerData(message.entityId, message.trailerId, message.gasPumpPos));
        }
    }
}

