/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.network.message.IMessage;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncPlayerGasPumpPos
implements IMessage<MessageSyncPlayerGasPumpPos> {
    private int entityId;
    private Optional<BlockPos> gasPumpPos;

    public MessageSyncPlayerGasPumpPos() {
    }

    public MessageSyncPlayerGasPumpPos(int entityId, Optional<BlockPos> gasPumpPos) {
        this.entityId = entityId;
        this.gasPumpPos = gasPumpPos;
    }

    @Override
    public void encode(MessageSyncPlayerGasPumpPos message, PacketBuffer buffer) {
        buffer.func_150787_b(message.entityId);
        buffer.writeBoolean(message.gasPumpPos.isPresent());
        message.gasPumpPos.ifPresent(arg_0 -> ((PacketBuffer)buffer).func_179255_a(arg_0));
    }

    @Override
    public MessageSyncPlayerGasPumpPos decode(PacketBuffer buffer) {
        int entityId = buffer.func_150792_a();
        boolean present = buffer.readBoolean();
        return new MessageSyncPlayerGasPumpPos(entityId, present ? Optional.of(buffer.func_179259_c()) : Optional.empty());
    }

    @Override
    public void handle(MessageSyncPlayerGasPumpPos message, Supplier<NetworkEvent.Context> supplier) {
        if (supplier.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            supplier.get().enqueueWork(() -> VehicleMod.PROXY.syncGasPumpPos(message.entityId, message.gasPumpPos));
        }
    }
}

